/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.taglibprocessing.attributevalues;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jst.jsf.metadataprocessors.features.IPossibleValues;
import org.eclipse.jst.jsf.metadataprocessors.features.IValidValues;
import org.eclipse.jst.jsf.metadataprocessors.features.PossibleValue;
import org.eclipse.jst.jsf.metadataprocessors.features.ValidationMessage;
import org.eclipse.jst.jsf.taglibprocessing.attributevalues.Messages;
import org.eclipse.jst.jsf.taglibprocessing.attributevalues.ObjectType;

public class JavaClassType
extends ObjectType
implements IPossibleValues,
IValidValues {
    public static final String POSSIBLE_VALUES_INTERFACES_PROP_NAME = "valid-interfaces";
    public static final String POSSIBLE_VALUES_SUPERCLASS_PROP_NAME = "valid-superclass";
    private List validationMsgs;

    @Override
    public List getPossibleValues() {
        List results = this.getTypes();
        if (results != null && !results.isEmpty()) {
            HashSet vals = new HashSet(results.size());
            HashSet checkedTypes = new HashSet();
            for (SearchMatch match : results) {
                IType res = (IType)match.getElement();
                this.addValidSubClasses(res, vals, checkedTypes);
            }
            return this.createPossibleValues(vals);
        }
        return new ArrayList(0);
    }

    private List createPossibleValues(Set vals) {
        ArrayList<PossibleValue> list = new ArrayList<PossibleValue>(vals.size());
        for (IJavaElement elem : vals) {
            list.add(this.createPossibleValue(elem));
        }
        return list;
    }

    private void addValidSubClasses(IType res, Set vals, Set checkedTypes) {
        try {
            if (checkedTypes.contains(res)) {
                return;
            }
            if (this.isInnerOrAnonymousClass(res)) {
                return;
            }
            if (!this.isAbstractClass(res)) {
                vals.add(res);
            }
            ITypeHierarchy hierarchy = res.newTypeHierarchy(this.getJavaProject(), null);
            IType[] subclasses = hierarchy.getSubclasses(res);
            checkedTypes.add(res);
            int i = 0;
            while (i < subclasses.length) {
                this.addValidSubClasses(subclasses[i], vals, checkedTypes);
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    private List getTypes() {
        IJavaProject jp = this.getJavaProject();
        if (jp == null) {
            return null;
        }
        ArrayList<IType> elems = new ArrayList<IType>();
        elems.addAll(this.getInterfaces(jp));
        IType sc = this.getSuperClass(jp);
        if (sc != null) {
            elems.add(sc);
        }
        if (elems.size() > 0) {
            Searcher requestor = new Searcher();
            SearchEngine engine = new SearchEngine();
            IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{jp});
            SearchPattern combined = SearchPattern.createPattern((IJavaElement)((IJavaElement)elems.get(0)), (int)1, (int)0);
            try {
                engine.search(combined, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)requestor, null);
            }
            catch (CoreException coreException) {}
            return requestor.getResults();
        }
        return Collections.EMPTY_LIST;
    }

    private IJavaProject getJavaProject() {
        IProject proj = this.getProject2();
        if (proj != null) {
            return JavaCore.create((IProject)proj);
        }
        return null;
    }

    private List getInterfaces(IJavaProject jp) {
        ArrayList<IType> ret = new ArrayList<IType>();
        List propVals = this.getInterfaceNames();
        for (String propVal : propVals) {
            IType interfase = null;
            try {
                interfase = this.findType(jp, propVal);
                if (interfase == null) continue;
                ret.add(interfase);
            }
            catch (JavaModelException javaModelException) {}
        }
        return ret;
    }

    private IType getSuperClass(IJavaProject jp) {
        IType superclass = null;
        try {
            String sc = this.getSuperClassName();
            if (sc != null && !sc.trim().equals("") && (superclass = this.findType(jp, sc)) != null) {
                return superclass;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    private PossibleValue createPossibleValue(IJavaElement val) {
        return new PossibleValue(((IType)val).getFullyQualifiedName());
    }

    @Override
    public List getValidationMessages() {
        if (this.validationMsgs == null) {
            this.validationMsgs = new ArrayList();
        }
        return this.validationMsgs;
    }

    @Override
    public boolean isValidValue(String value) {
        if (value == null || value.trim().equals("")) {
            this.getValidationMessages().add(new ValidationMessage(Messages.JavaClassType_invalid_type));
            return false;
        }
        IJavaProject jp = this.getJavaProject();
        if (jp == null) {
            return false;
        }
        IType type = this.getTypeForValue(jp, value);
        if (type != null && !this.isInnerOrAnonymousClass(type) && !this.isAbstractClass(type)) {
            ITypeHierarchy hierarchy;
            try {
                hierarchy = type.newTypeHierarchy(jp, null);
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
            List interfaceNames = this.getInterfaceNames();
            Iterator it = interfaceNames.iterator();
            while (it.hasNext()) {
                IType interfase = this.getTypeForValue(jp, (String)it.next());
                if (interfase == null) {
                    this.addNewValidationMessage(Messages.JavaClassType_not_found);
                    return false;
                }
                if (this.containsType(hierarchy.getAllSupertypes(type), interfase)) continue;
                this.addNewValidationMessage(Messages.JavaClassType_not_found);
                return false;
            }
            IType superClass = this.getSuperClass(jp);
            if (superClass != null && superClass.equals(type)) {
                return true;
            }
            if (superClass != null && !this.containsType(hierarchy.getAllSuperclasses(type), superClass)) {
                this.addNewValidationMessage(Messages.JavaClassType_not_found);
                return false;
            }
            return true;
        }
        this.addNewValidationMessage(Messages.JavaClassType_not_found);
        return false;
    }

    private boolean containsType(IType[] types, IType type) {
        int i = 0;
        while (i < types.length) {
            if (type.equals(types[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private IType getTypeForValue(IJavaProject jp, String value) {
        try {
            return this.findType(jp, value);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    protected String getSuperClassName() {
        return this.getTraitValueAsString(POSSIBLE_VALUES_SUPERCLASS_PROP_NAME);
    }

    protected List getInterfaceNames() {
        return this.getTraitValueAsListOfStrings(POSSIBLE_VALUES_INTERFACES_PROP_NAME);
    }

    protected void addNewValidationMessage(String defaultMsg) {
        String msg = this.getCMValidationMessage();
        if (msg == null || msg.equals("")) {
            msg = defaultMsg;
        }
        String code = this.getValidationCode();
        int severity = this.getValidationSeverity();
        ValidationMessage val = new ValidationMessage(msg, code, severity);
        this.getValidationMessages().add(val);
    }

    protected String getCMValidationMessage() {
        return this.getTraitValueAsString("valid-values-message");
    }

    protected int getValidationSeverity() {
        String val = this.getTraitValueAsString("valid-values-severity");
        if (val == null) {
            return 2;
        }
        int severity = Integer.valueOf(val);
        return severity;
    }

    protected String getValidationCode() {
        return this.getTraitValueAsString("valid-values-code");
    }

    private boolean isInnerOrAnonymousClass(IType res) {
        try {
            if (res.isClass() && (res.isAnonymous() || Flags.isPrivate((int)res.getFlags()) || res.getFullyQualifiedName().indexOf("$") > 0)) {
                return true;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    private boolean isAbstractClass(IType res) {
        try {
            if (res.isClass() && Flags.isAbstract((int)res.getFlags())) {
                return true;
            }
        }
        catch (JavaModelException javaModelException) {}
        return false;
    }

    private IType findType(IJavaProject jproject, String fullyQualifiedName) throws JavaModelException {
        IType type = jproject.findType(fullyQualifiedName);
        if (type != null) {
            return type;
        }
        IPackageFragmentRoot[] roots = jproject.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            type = this.findType(root, fullyQualifiedName);
            if (type != null && type.exists()) {
                return type;
            }
            ++i;
        }
        return null;
    }

    private IType findType(IPackageFragmentRoot root, String fullyQualifiedName) throws JavaModelException {
        IJavaElement[] children = root.getChildren();
        int i = 0;
        while (i < children.length) {
            IType type;
            IPackageFragment pack;
            IJavaElement element = children[i];
            if (element.getElementType() == 4 && fullyQualifiedName.startsWith((pack = (IPackageFragment)element).getElementName()) && (type = this.findType(pack, fullyQualifiedName)) != null && type.exists()) {
                return type;
            }
            ++i;
        }
        return null;
    }

    private IType findType(IPackageFragment pack, String fullyQualifiedName) throws JavaModelException {
        ICompilationUnit[] cus = pack.getCompilationUnits();
        int i = 0;
        while (i < cus.length) {
            ICompilationUnit unit = cus[i];
            IType type = this.findType(unit, fullyQualifiedName);
            if (type != null && type.exists()) {
                return type;
            }
            ++i;
        }
        return null;
    }

    private IType findType(ICompilationUnit cu, String fullyQualifiedName) throws JavaModelException {
        IType[] types = cu.getAllTypes();
        int i = 0;
        while (i < types.length) {
            IType type = types[i];
            if (this.getFullyQualifiedName(type).equals(fullyQualifiedName)) {
                return type;
            }
            ++i;
        }
        return null;
    }

    private String getFullyQualifiedName(IType type) {
        try {
            IType declaringType;
            if (type.isBinary() && !type.isAnonymous() && (declaringType = type.getDeclaringType()) != null) {
                return String.valueOf(this.getFullyQualifiedName(declaringType)) + '.' + type.getElementName();
            }
        }
        catch (JavaModelException javaModelException) {}
        return type.getFullyQualifiedName('.');
    }

    private static class Searcher
    extends SearchRequestor {
        private List results = new ArrayList();

        private Searcher() {
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            this.results.add(match);
        }

        public List getResults() {
            return this.results;
        }
    }
}

