/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.java;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDCMDocumentManager;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TaglibTracker;
import org.eclipse.jst.jsp.core.internal.encoding.JSPDocumentLoader;
import org.eclipse.jst.jsp.core.internal.java.EscapedTextUtil;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslator;
import org.eclipse.jst.jsp.core.internal.parser.JSPSourceParser;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.jst.jsp.core.internal.util.FileContentCache;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.IModelHandler;
import org.eclipse.wst.sse.core.internal.ltk.parser.BlockMarker;
import org.eclipse.wst.sse.core.internal.ltk.parser.StructuredDocumentRegionHandler;
import org.eclipse.wst.sse.core.internal.modelhandler.ModelHandlerRegistry;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;

class XMLJSPRegionHelper
implements StructuredDocumentRegionHandler {
    private final JSPTranslator fTranslator;
    protected JSPSourceParser fLocalParser = null;
    protected String fTextToParse = null;
    protected int fStartOfTextToParse = 0;
    protected String fTagname = null;
    protected String fTextBefore = "";
    protected String fUnescapedText = "";
    protected String fStrippedText = "";
    int fPossibleOwner = 8;
    boolean fAppendAsIndirectSource;

    public XMLJSPRegionHelper(JSPTranslator translator, boolean appendAsIndirectSource) {
        this.getLocalParser().addStructuredDocumentRegionHandler(this);
        this.fTranslator = translator;
        this.fAppendAsIndirectSource = appendAsIndirectSource;
    }

    protected JSPSourceParser getLocalParser() {
        if (this.fLocalParser == null) {
            this.fLocalParser = new JSPSourceParser();
        }
        return this.fLocalParser;
    }

    public void addBlockMarker(BlockMarker marker) {
        this.fLocalParser.addBlockMarker(marker);
    }

    public void reset(String textToParse) {
        this.reset(textToParse, 0);
    }

    public void reset(String textToParse, int start) {
        this.fStartOfTextToParse = start;
        this.fTextToParse = textToParse;
    }

    public void forceParse() {
        String contents = this.fTextToParse;
        IStructuredDocument document = (IStructuredDocument)new JSPDocumentLoader().createNewStructuredDocument();
        if (contents != null && document != null) {
            List blockMarkers = this.fTranslator.getBlockMarkers();
            int i = 0;
            while (i < blockMarkers.size()) {
                this.addBlockMarker((BlockMarker)blockMarkers.get(i));
                ++i;
            }
            this.reset(contents);
            document.set(contents);
            IStructuredDocumentRegion cursor = document.getFirstStructuredDocumentRegion();
            while (cursor != null) {
                this.nodeParsed(cursor);
                cursor = cursor.getNext();
            }
        }
    }

    public boolean parse(String filePathString) {
        boolean parsed = false;
        IStructuredDocument document = null;
        String contents = null;
        Path filePath = new Path(filePathString);
        IFile f = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)filePath);
        if (f == null || !f.isAccessible()) {
            f = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)filePath);
        }
        if (f != null && f.isAccessible()) {
            try {
                IModelHandler handler = ModelHandlerRegistry.getInstance().getHandlerFor(f, false);
                if (handler == null) {
                    handler = ModelHandlerRegistry.getInstance().getHandlerForContentTypeId(ContentTypeIdForJSP.ContentTypeID_JSPFRAGMENT);
                }
                document = (IStructuredDocument)handler.getDocumentLoader().createNewStructuredDocument();
                contents = FileContentCache.getInstance().getContents(f.getFullPath());
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
        if (contents != null && document != null) {
            List blockMarkers = this.fTranslator.getBlockMarkers();
            int i = 0;
            while (i < blockMarkers.size()) {
                this.addBlockMarker((BlockMarker)blockMarkers.get(i));
                ++i;
            }
            this.reset(contents);
            document.set(contents);
            IStructuredDocumentRegion cursor = document.getFirstStructuredDocumentRegion();
            while (cursor != null) {
                this.nodeParsed(cursor);
                cursor = cursor.getNext();
            }
            parsed = true;
        }
        return parsed;
    }

    public void nodeParsed(IStructuredDocumentRegion sdRegion) {
        try {
            if (this.isJSPEndRegion(sdRegion)) {
                String nameStr = this.getRegionName(sdRegion);
                if (this.isPossibleCustomTag(nameStr)) {
                    this.fTranslator.addTaglibVariables(nameStr, (ITextRegionCollection)sdRegion);
                }
                this.fTagname = null;
            } else if (this.isJSPStartRegion(sdRegion)) {
                int illegalContent = this.hasIllegalContent(sdRegion);
                if (illegalContent >= 0) {
                    this.decodeRemainingRegions(sdRegion, illegalContent);
                }
                String nameStr = this.getRegionName(sdRegion);
                if (sdRegion.getFirstRegion().getType() == "XML_TAG_OPEN" && this.isPossibleCustomTag(nameStr)) {
                    this.fTranslator.addTaglibVariables(nameStr, (ITextRegionCollection)sdRegion);
                }
                this.fTagname = this.isJSPRegion(nameStr) ? nameStr : null;
                if (this.fTagname != null) {
                    this.processOtherRegions(sdRegion);
                }
                if (this.fTagname != null && this.fTagname.equals("jsp:useBean")) {
                    this.processUseBean(sdRegion);
                }
            } else if (sdRegion.getFirstRegion().getType() == "JSP_CONTENT" || sdRegion.getFirstRegion().getType() == "XML_CONTENT" || sdRegion.getFirstRegion().getType() == "CSS_JSP_SCRIPTLET" || sdRegion.getFirstRegion().getType() == "CSS_JSP_EXP" || sdRegion.getFirstRegion().getType() == "CSS_JSP_DECL") {
                if (this.fTagname != null) {
                    if (this.isScriptlet(this.fTagname)) {
                        this.processScriptlet(sdRegion);
                    } else if (this.isExpression(this.fTagname)) {
                        this.processExpression(sdRegion);
                    } else if (this.isDeclaration(this.fTagname)) {
                        this.processDeclaration(sdRegion);
                    }
                } else {
                    String previousType;
                    String string = previousType = sdRegion.getPrevious() != null ? sdRegion.getPrevious().getType() : null;
                    if (previousType != null || sdRegion.getPrevious() == null) {
                        if ("JSP_EXPRESSION_OPEN".equals(previousType) || "CSS_JSP_EXP".equals(sdRegion.getFirstRegion().getType())) {
                            this.processExpression(sdRegion, true);
                        } else if ("JSP_SCRIPTLET_OPEN".equals(previousType) || "CSS_JSP_SCRIPTLET".equals(sdRegion.getFirstRegion().getType())) {
                            this.processScriptlet(sdRegion, true);
                        } else if ("JSP_DECLARATION_OPEN".equals(previousType) || "CSS_JSP_DECL".equals(sdRegion.getFirstRegion().getType())) {
                            this.processDeclaration(sdRegion, true);
                        }
                    }
                }
            } else {
                this.fTagname = null;
                ITextRegion first = sdRegion.getFirstRegion();
                ITextRegion last = sdRegion.getLastRegion();
                if ("XML_COMMENT_OPEN".equals(first.getType()) && "XML_COMMENT_CLOSE".equals(last.getType())) {
                    this.fTranslator.decodeScriptBlock(sdRegion.getFullText().substring(first.getEnd(), last.getStart()), 0);
                }
            }
            this.checkCursorInRegion(sdRegion);
        }
        catch (NullPointerException e) {
            try {
                Logger.logException("XMLJSPRegionHelper: exception in node parsing", e);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
        }
    }

    private void decodeRemainingRegions(IStructuredDocumentRegion sdRegion, int start) {
        ITextRegionList regionList = sdRegion.getRegions();
        if (regionList != null) {
            ITextRegion region = regionList.get(start);
            String text = sdRegion.getFullText();
            if (text != null && region != null && region.getStart() <= text.length()) {
                this.fTranslator.decodeScriptBlock(text.substring(region.getStart(), text.length()), 0);
            }
        }
    }

    private int hasIllegalContent(IStructuredDocumentRegion sdRegion) {
        ITextRegionList list = sdRegion.getRegions();
        int i = 0;
        while (i < list.size()) {
            ITextRegion region = list.get(i);
            String type = region.getType();
            if (type == "UNDEFINED") {
                return i;
            }
            if (type == "XML_END_TAG_OPEN" || type == "XML_EMPTY_TAG_CLOSE" || type == "JSP_DIRECTIVE_CLOSE") {
                return -1;
            }
            ++i;
        }
        return -1;
    }

    public void resetNodes() {
    }

    private void checkCursorInRegion(IStructuredDocumentRegion sdRegion) {
        if (this.fTranslator.getSourcePosition() >= this.fStartOfTextToParse + sdRegion.getStartOffset() && this.fTranslator.getSourcePosition() <= this.fStartOfTextToParse + sdRegion.getEndOffset()) {
            int endOfNameTag = sdRegion.getStartOffset();
            int offset = this.fTextBefore.length() - this.fStrippedText.length();
            this.fTranslator.setRelativeOffset(this.fTranslator.getSourcePosition() - (this.fStartOfTextToParse + endOfNameTag) - offset);
            this.fTranslator.setCursorOwner(this.fPossibleOwner);
            this.fTranslator.setRelativeOffset(this.fTranslator.getRelativeOffset() + this.fTranslator.getCursorOwner().length());
            if (this.fPossibleOwner == 4) {
                this.fTranslator.setRelativeOffset(this.fTranslator.getRelativeOffset() + "out.print(".length());
            }
        }
    }

    protected void processDeclaration(IStructuredDocumentRegion sdRegion) {
        this.processDeclaration(sdRegion, false);
    }

    protected void processDeclaration(IStructuredDocumentRegion sdRegion, boolean embedded) {
        this.prepareText(sdRegion);
        IStructuredDocumentRegion currentNode = this.fTranslator.getCurrentNode();
        if (embedded) {
            this.fTranslator.translateDeclarationString(this.fStrippedText, (ITextRegionCollection)sdRegion, currentNode.getStartOffset() + sdRegion.getStartOffset(), sdRegion.getLength(), this.fAppendAsIndirectSource);
        } else {
            this.fTranslator.translateDeclarationString(this.fStrippedText, (ITextRegionCollection)currentNode, currentNode.getStartOffset(), currentNode.getLength(), this.fAppendAsIndirectSource);
        }
        this.fPossibleOwner = 2;
    }

    protected void processExpression(IStructuredDocumentRegion sdRegion) {
        this.processExpression(sdRegion, false);
    }

    protected void processExpression(IStructuredDocumentRegion sdRegion, boolean embedded) {
        this.prepareText(sdRegion);
        IStructuredDocumentRegion currentNode = this.fTranslator.getCurrentNode();
        if (embedded) {
            this.fTranslator.translateExpressionString(this.fStrippedText, (ITextRegionCollection)sdRegion, currentNode.getStartOffset() + sdRegion.getStartOffset(), sdRegion.getLength(), this.fAppendAsIndirectSource);
        } else {
            this.fTranslator.translateExpressionString(this.fStrippedText, (ITextRegionCollection)currentNode, currentNode.getStartOffset(), currentNode.getLength(), this.fAppendAsIndirectSource);
        }
        this.fPossibleOwner = 4;
    }

    protected void processScriptlet(IStructuredDocumentRegion sdRegion) {
        this.processScriptlet(sdRegion, false);
    }

    protected void processScriptlet(IStructuredDocumentRegion sdRegion, boolean embedded) {
        this.prepareText(sdRegion);
        IStructuredDocumentRegion currentNode = this.fTranslator.getCurrentNode();
        if (embedded) {
            this.fTranslator.translateScriptletString(this.fStrippedText, (ITextRegionCollection)sdRegion, currentNode.getStartOffset() + sdRegion.getStartOffset(), sdRegion.getLength(), this.fAppendAsIndirectSource);
        } else {
            this.fTranslator.translateScriptletString(this.fStrippedText, (ITextRegionCollection)currentNode, currentNode.getStartOffset(), currentNode.getLength(), this.fAppendAsIndirectSource);
        }
        this.fPossibleOwner = 8;
    }

    protected void prepareText(IStructuredDocumentRegion sdRegion) {
        this.fTextBefore = this.fTextToParse.substring(sdRegion.getStartOffset(), sdRegion.getEndOffset());
        this.fUnescapedText = EscapedTextUtil.getUnescapedText(this.fTextBefore);
        this.fStrippedText = this.fTranslator.stripCDATA(this.fUnescapedText);
    }

    protected void processUseBean(IStructuredDocumentRegion sdRegion) {
        if (this.fTagname != null && this.isUseBean(this.fTagname)) {
            String beanDecl = null;
            String beanClass = this.getAttributeValue("class", sdRegion);
            String beanType = this.getAttributeValue("type", sdRegion);
            String beanId = this.getAttributeValue("id", sdRegion);
            if (beanId != null && (beanType != null || beanClass != null)) {
                String prefix = null;
                prefix = beanType != null && beanType.length() > 0 ? String.valueOf(beanType) + " " + beanId + " = " : String.valueOf(beanClass) + " " + beanId + " = ";
                String suffix = "null;\n";
                if (beanClass != null && beanClass.length() > 0) {
                    suffix = "new " + beanClass + "();\n";
                }
                beanDecl = String.valueOf(prefix) + suffix;
            }
            IStructuredDocumentRegion currentNode = this.fTranslator.getCurrentNode();
            this.fTranslator.translateScriptletString(beanDecl, (ITextRegionCollection)currentNode, currentNode.getStartOffset(), currentNode.getLength(), this.fAppendAsIndirectSource);
            this.fPossibleOwner = 8;
        }
    }

    protected void processOtherRegions(IStructuredDocumentRegion sdRegion) {
        this.processIncludeDirective(sdRegion);
        this.processPageDirective(sdRegion);
    }

    protected void processIncludeDirective(IStructuredDocumentRegion sdRegion) {
        if (this.isIncludeDirective(this.fTagname)) {
            if (sdRegion.getRegions().get(0).getType() == "XML_CONTENT") {
                sdRegion = sdRegion.getPrevious();
            }
            String fileLocation = this.getAttributeValue("file", sdRegion);
            this.fTranslator.handleIncludeFile(fileLocation);
        } else if (this.isTaglibDirective(this.fTagname)) {
            String prefix = this.getAttributeValue("prefix", sdRegion);
            TLDCMDocumentManager documentManager = this.fTranslator.getTLDCMDocumentManager();
            if (documentManager != null) {
                List<TaglibTracker> docs = documentManager.getCMDocumentTrackers(prefix, this.fTranslator.getCurrentNode().getStartOffset());
                Iterator<TaglibTracker> it = docs.iterator();
                Iterator elements = null;
                CMNode node2 = null;
                CMDocument doc = null;
                BlockMarker marker = null;
                while (it.hasNext()) {
                    doc = it.next();
                    for (CMNode node2 : doc.getElements()) {
                        marker = new BlockMarker(node2.getNodeName(), null, "JSP_CONTENT", true);
                        this.addBlockMarker(marker);
                        this.fTranslator.getBlockMarkers().add(marker);
                    }
                }
            }
        }
    }

    protected void processPageDirective(IStructuredDocumentRegion sdRegion) {
        if (this.isPageDirective(this.fTagname)) {
            this.fTranslator.translatePageDirectiveAttributes(sdRegion.getRegions().iterator(), sdRegion);
        }
    }

    protected String getAttributeValue(String attrName, IStructuredDocumentRegion sdRegion) {
        String sdRegionText = this.fTextToParse.substring(sdRegion.getStartOffset(), sdRegion.getEndOffset());
        String attrValue = "";
        Iterator it = sdRegion.getRegions().iterator();
        ITextRegion valueRegion = null;
        block0: while (it.hasNext()) {
            String textRegionText;
            ITextRegion nameRegion = (ITextRegion)it.next();
            if (nameRegion.getType() != "XML_TAG_ATTRIBUTE_NAME" || !(textRegionText = sdRegionText.substring(nameRegion.getStart(), nameRegion.getTextEnd())).equalsIgnoreCase(attrName)) continue;
            while (it.hasNext()) {
                valueRegion = (ITextRegion)it.next();
                if (valueRegion.getType() != "XML_TAG_ATTRIBUTE_VALUE") continue;
                attrValue = sdRegionText.substring(valueRegion.getStart(), valueRegion.getEnd());
                break block0;
            }
            break block0;
        }
        return StringUtils.stripQuotes((String)attrValue);
    }

    protected boolean isJSPStartRegion(IStructuredDocumentRegion sdRegion) {
        return sdRegion.getFirstRegion().getType() == "XML_TAG_OPEN" || sdRegion.getFirstRegion().getType() == "JSP_DIRECTIVE_OPEN";
    }

    private boolean isJSPEndRegion(IStructuredDocumentRegion sdRegion) {
        return sdRegion.getFirstRegion().getType() == "XML_END_TAG_OPEN";
    }

    protected boolean isJSPRegion(String tagName) {
        return this.isDeclaration(tagName) || this.isExpression(tagName) || this.isScriptlet(tagName) || this.isUseBean(tagName) || this.isIncludeDirective(tagName) || this.isPossibleCustomTag(tagName) || this.isTaglibDirective(tagName) || this.isPageDirective(tagName);
    }

    protected boolean isDeclaration(String tagName) {
        return tagName.equalsIgnoreCase("jsp:declaration");
    }

    protected boolean isExpression(String tagName) {
        return tagName.equalsIgnoreCase("jsp:expression");
    }

    protected boolean isScriptlet(String tagName) {
        return tagName.equalsIgnoreCase("jsp:scriptlet");
    }

    protected boolean isUseBean(String tagName) {
        return tagName.equalsIgnoreCase("jsp:useBean");
    }

    protected boolean isIncludeDirective(String tagName) {
        return tagName.equalsIgnoreCase("jsp:directive.include");
    }

    protected boolean isPossibleCustomTag(String tagName) {
        return tagName.indexOf(58) > -1 && !tagName.startsWith("jsp:");
    }

    protected boolean isTaglibDirective(String tagName) {
        return tagName.equalsIgnoreCase("jsp:directive.taglib");
    }

    protected boolean isPageDirective(String tagName) {
        return tagName.equalsIgnoreCase("jsp:directive.page");
    }

    protected String getRegionName(IStructuredDocumentRegion sdRegion) {
        String nameStr = "";
        ITextRegionList regions = sdRegion.getRegions();
        int i = 0;
        while (i < regions.size()) {
            ITextRegion r = regions.get(i);
            if (r.getType() == "XML_TAG_NAME") {
                nameStr = this.fTextToParse.substring(sdRegion.getStartOffset(r), sdRegion.getTextEndOffset(r));
                break;
            }
            ++i;
        }
        return nameStr.trim();
    }

    protected String getContents(String filePath) {
        Path path = new Path(filePath);
        return FileContentCache.getInstance().getContents(path.makeAbsolute());
    }
}

