/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.service.policy.ui;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.ws.internal.service.policy.ui.BaseOperationImpl;
import org.eclipse.wst.ws.internal.service.policy.ui.PolicyOperationImpl;
import org.eclipse.wst.ws.internal.service.policy.ui.ServicePolicyRegistryUI;
import org.eclipse.wst.ws.service.policy.IServicePolicy;
import org.eclipse.wst.ws.service.policy.ServicePolicyPlatform;
import org.eclipse.wst.ws.service.policy.listeners.IPolicyChildChangeListener;
import org.eclipse.wst.ws.service.policy.ui.IPolicyOperation;
import org.eclipse.wst.ws.service.policy.ui.IQuickFixActionInfo;

public class ServicePolicyPlatformUIImpl {
    private Map<String, BaseOperationImpl> baseOperationMap;
    private Map<IServicePolicy, Set<IPolicyOperation>> policyCache;
    private Map<String, List<IQuickFixActionInfo>> quickFixes;

    public ServicePolicyPlatformUIImpl() {
        ServicePolicyPlatform platform = ServicePolicyPlatform.getInstance();
        ServicePolicyRegistryUI registry = new ServicePolicyRegistryUI();
        Set policyIds = platform.getAllPolicyIds();
        this.baseOperationMap = new HashMap<String, BaseOperationImpl>();
        this.policyCache = new HashMap<IServicePolicy, Set<IPolicyOperation>>();
        this.quickFixes = new HashMap<String, List<IQuickFixActionInfo>>();
        registry.load(this.baseOperationMap, this.quickFixes);
        this.createOperationCache(policyIds);
        platform.addChildChangeListener((IPolicyChildChangeListener)new ChildListener(), false);
    }

    public List<IQuickFixActionInfo> getQuickFixes(IStatus status) {
        String pluginId = status.getPlugin();
        int code = status.getCode();
        String key = String.valueOf(pluginId) + ":" + code;
        List<IQuickFixActionInfo> result = this.quickFixes.get(key);
        if (result == null) {
            result = new Vector<IQuickFixActionInfo>();
            this.quickFixes.put(key, result);
        }
        return result;
    }

    public List<IPolicyOperation> getAllOperations() {
        Vector<IPolicyOperation> operations = new Vector<IPolicyOperation>();
        for (Set<IPolicyOperation> operationSet : this.policyCache.values()) {
            operations.addAll(operationSet);
        }
        return operations;
    }

    public Set<IPolicyOperation> getOperationsForPolicy(IServicePolicy policy, boolean isWorkspace) {
        Set<IPolicyOperation> policyOperations = this.policyCache.get(policy);
        HashSet<IPolicyOperation> result = new HashSet<IPolicyOperation>();
        if (policyOperations != null) {
            result.addAll(policyOperations);
            if (!isWorkspace) {
                for (IPolicyOperation operation : policyOperations) {
                    if (!operation.isWorkspaceOnly()) continue;
                    result.remove(operation);
                }
            }
        }
        return result;
    }

    public List<List<IPolicyOperation>> getOperationsList(List<IServicePolicy> policies, boolean isWorkspace) {
        HashMap<String, Vector<IPolicyOperation>> operationMap = new HashMap<String, Vector<IPolicyOperation>>();
        for (IServicePolicy policy : policies) {
            Set<IPolicyOperation> operations = this.policyCache.get(policy);
            if (operations == null) continue;
            for (IPolicyOperation operation : operations) {
                String id = operation.getId();
                Vector<IPolicyOperation> entryList = (Vector<IPolicyOperation>)operationMap.get(id);
                if (!isWorkspace && operation.isWorkspaceOnly()) continue;
                if (entryList == null) {
                    entryList = new Vector<IPolicyOperation>();
                    operationMap.put(id, entryList);
                }
                entryList.add(operation);
            }
        }
        return new Vector<List<IPolicyOperation>>(operationMap.values());
    }

    private void createOperationCache(Set<String> policyIds) {
        ServicePolicyPlatform platform = ServicePolicyPlatform.getInstance();
        Collection<BaseOperationImpl> operations = this.baseOperationMap.values();
        for (BaseOperationImpl operation : operations) {
            String policyPattern = operation.getPolicyIdPattern();
            Pattern pattern = Pattern.compile(policyPattern);
            for (String policyId : policyIds) {
                Matcher matcher = pattern.matcher(policyId);
                if (!matcher.matches()) continue;
                IServicePolicy policy = platform.getServicePolicy(policyId);
                Set<IPolicyOperation> operationsSet = this.policyCache.get(policy);
                if (operationsSet == null) {
                    operationsSet = new HashSet<IPolicyOperation>();
                    this.policyCache.put(policy, operationsSet);
                }
                operationsSet.add(new PolicyOperationImpl(operation, policy));
            }
        }
    }

    private class ChildListener
    implements IPolicyChildChangeListener {
        private ChildListener() {
        }

        public void childChange(List<IServicePolicy> childList, List<Boolean> addedList) {
            HashSet<String> idSet = new HashSet<String>();
            int index = 0;
            while (index < childList.size()) {
                IServicePolicy policy = childList.get(index);
                boolean added = addedList.get(index);
                if (added) {
                    idSet.add(policy.getId());
                } else {
                    ServicePolicyPlatformUIImpl.this.policyCache.remove(policy);
                }
                ++index;
            }
            if (idSet.size() > 0) {
                ServicePolicyPlatformUIImpl.this.createOperationCache(idSet);
            }
        }
    }
}

