/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.converter.html;

import org.eclipse.jst.jsf.common.ui.JSFUICommonPlugin;
import org.eclipse.jst.pagedesigner.converter.AbstractTagConverter;
import org.eclipse.jst.pagedesigner.converter.DumDescriptionTagConverter;
import org.eclipse.jst.pagedesigner.converter.DumTagConverter;
import org.eclipse.jst.pagedesigner.converter.HiddenTagConverter2;
import org.eclipse.jst.pagedesigner.converter.IConverterFactory;
import org.eclipse.jst.pagedesigner.converter.ITagConverter;
import org.eclipse.jst.pagedesigner.converter.html.ATagConverter;
import org.eclipse.jst.pagedesigner.converter.html.TableTagConverter;
import org.eclipse.jst.pagedesigner.utils.HTMLUtil;
import org.eclipse.swt.graphics.Image;
import org.w3c.dom.Element;

public class HTMLConverterFactory
implements IConverterFactory {
    @Override
    public ITagConverter createConverter(Element element, int mode) {
        AbstractTagConverter c;
        String tagName = element.getLocalName();
        if (mode == 1) {
            return new DumTagConverter(element);
        }
        if (!HTMLUtil.isVisualHtmlElement(tagName)) {
            return new HiddenTagConverter2(element, HTMLConverterFactory.getUnknownImage());
        }
        if ("table".equalsIgnoreCase(tagName)) {
            c = new TableTagConverter(element);
        } else if ("a".equalsIgnoreCase(tagName)) {
            c = new ATagConverter(element);
        } else if ("form".equalsIgnoreCase(tagName)) {
            c = new DumTagConverter(element, true);
        } else if ("html".equalsIgnoreCase(tagName) || "body".equalsIgnoreCase(tagName)) {
            c = new DumDescriptionTagConverter(element);
            c.setNeedBorderDecorator(true);
        } else {
            c = new DumTagConverter(element);
        }
        c.setMode(mode);
        return c;
    }

    private static Image getUnknownImage() {
        return JSFUICommonPlugin.getDefault().getImage("PD_Palette_Default.gif");
    }

    @Override
    public String getSupportedURI() {
        return "html";
    }
}

