/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.dtmanager;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataDomainContext;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryContextFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.taglib.ITaglibDomainMetaDataQuery;
import org.eclipse.jst.jsf.core.internal.tld.CMUtil;
import org.eclipse.jst.pagedesigner.dtmanager.DefaultDTInfo;
import org.eclipse.jst.pagedesigner.dtmanager.IDTInfo;
import org.eclipse.jst.pagedesigner.dtmanager.IDTInfoFactory;
import org.eclipse.jst.pagedesigner.dtmanager.dtinfo.DTInfo;
import org.eclipse.jst.pagedesigner.utils.StructuredModelUtil;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;

public class DefaultDTInfoFactory
implements IDTInfoFactory {
    public static final String DTINFO_TRAIT_KEY = "dt-info";

    @Override
    public IDTInfo getDTInfo(Element element) {
        IFile file;
        DefaultDTInfo dtInfo = null;
        String nsURI = this.getURI(element);
        if (nsURI != null && (file = this.getFile(element)) != null) {
            DTInfo dtInfoModelObject;
            Trait trait;
            IMetaDataDomainContext context = MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(file);
            ITaglibDomainMetaDataQuery query = (ITaglibDomainMetaDataQuery)MetaDataQueryFactory.getInstance().createQuery(context);
            if (query != null && (trait = query.getQueryHelper().getTrait(nsURI, element.getLocalName(), DTINFO_TRAIT_KEY)) != null && (dtInfoModelObject = (DTInfo)trait.getValue()) != null) {
                dtInfo = new DefaultDTInfo(dtInfoModelObject, trait);
            }
        }
        return dtInfo;
    }

    private String getURI(Element element) {
        String uri = CMUtil.getElementNamespaceURI((Element)element);
        if (uri == null) {
            uri = element.getNamespaceURI();
        }
        if (uri == null) {
            return null;
        }
        if (uri.equals("jsp")) {
            uri = "JSP11";
        }
        if (uri.equals("html")) {
            uri = "HTML";
        }
        return uri;
    }

    protected IProject getProject(Element element) {
        IDOMModel model;
        IProject project = null;
        if (element instanceof IDOMNode && (model = ((IDOMNode)element).getModel()) != null) {
            project = StructuredModelUtil.getProjectFor((IStructuredModel)model);
        }
        return project;
    }

    protected IFile getFile(Element element) {
        IDOMModel model;
        IFile file = null;
        if (element instanceof IDOMNode && (model = ((IDOMNode)element).getModel()) != null) {
            file = StructuredModelUtil.getFileFor((IStructuredModel)model);
        }
        return file;
    }
}

