/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editpolicies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.handles.MoveHandle;
import org.eclipse.gef.handles.ResizeHandle;
import org.eclipse.gef.handles.SquareHandle;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.editpolicies.ColumnHelper;
import org.eclipse.jst.pagedesigner.editpolicies.CornerRelativeHandleLocator;
import org.eclipse.jst.pagedesigner.editpolicies.ElementResizableEditPolicy;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.w3c.dom.Element;

public class ColumnResizableEditPolicy
extends ElementResizableEditPolicy {
    @Override
    protected List createSelectionHandles() {
        String elementName = ((Element)this.getHost().getModel()).getLocalName();
        if ("column".equalsIgnoreCase(elementName)) {
            ArrayList<Object> list = new ArrayList<Object>();
            GraphicalEditPart part = (GraphicalEditPart)this.getHost();
            MoveHandle borderhandle = new MoveHandle(part, (Locator)new ColumnBorderHandleLocator(part));
            list.add(borderhandle);
            MyMoveHandle cornerHandle = new MyMoveHandle(part, (Locator)new ColumnHandleLocator(part, this.getHostFigure(), 9));
            list.add((Object)cornerHandle);
            SelectEditPartTracker tracker = new SelectEditPartTracker(this.getHost());
            list.add(this.createHandle(part, 20, (DragTracker)tracker, SharedCursors.ARROW));
            list.add(this.createHandle(part, 12, (DragTracker)tracker, SharedCursors.ARROW));
            list.add(this.createHandle(part, 9, (DragTracker)tracker, SharedCursors.ARROW));
            list.add(this.createHandle(part, 17, (DragTracker)tracker, SharedCursors.ARROW));
            return list;
        }
        return super.createSelectionHandles();
    }

    private Handle createHandle(GraphicalEditPart owner, int direction, DragTracker tracker, Cursor cursor) {
        ResizeHandle handle = new ResizeHandle(owner, (Locator)new ColumnCornerLocator(owner, direction), cursor);
        handle.setCursor(cursor);
        handle.setDragTracker(tracker);
        return handle;
    }

    private class ColumnBorderHandleLocator
    implements Locator {
        private GraphicalEditPart editPart;

        public ColumnBorderHandleLocator(GraphicalEditPart editPart) {
            this.editPart = editPart;
        }

        public void relocate(IFigure target) {
            target.setBounds(ColumnHelper.getColumnBounds(this.editPart, target));
        }
    }

    private class ColumnCornerLocator
    implements Locator {
        private double relativeX;
        private double relativeY;
        private GraphicalEditPart editPart;

        public ColumnCornerLocator(GraphicalEditPart editPart, int location) {
            this.editPart = editPart;
            switch (location & 5) {
                case 1: {
                    this.relativeY = 0.0;
                    break;
                }
                case 4: {
                    this.relativeY = 1.0;
                    break;
                }
                default: {
                    this.relativeY = 0.5;
                }
            }
            switch (location & 0x18) {
                case 8: {
                    this.relativeX = 0.0;
                    break;
                }
                case 16: {
                    this.relativeX = 1.0;
                    break;
                }
                default: {
                    this.relativeX = 0.5;
                }
            }
        }

        public void relocate(IFigure target) {
            Rectangle targetBounds = ColumnHelper.getColumnBounds(this.editPart, target);
            Dimension targetSize = target.getPreferredSize();
            targetBounds.x += (int)((double)targetBounds.width * this.relativeX - (double)((targetSize.width + 1) / 2));
            targetBounds.y += (int)((double)targetBounds.height * this.relativeY - (double)((targetSize.height + 1) / 2));
            targetBounds.setSize(targetSize);
            target.setBounds(targetBounds);
        }
    }

    private class ColumnHandleLocator
    extends CornerRelativeHandleLocator {
        private GraphicalEditPart editPart;

        public ColumnHandleLocator(GraphicalEditPart editPart, IFigure reference, int location) {
            super(reference, location);
            this.editPart = editPart;
        }

        @Override
        protected Dimension getNewTargetSize(IFigure relocateFigure) {
            return relocateFigure.getPreferredSize();
        }

        @Override
        protected Rectangle getCurrentTargetBounds(IFigure relocateFigure) {
            return ColumnHelper.getColumnBounds(this.editPart, relocateFigure);
        }
    }

    private static class MyMoveHandle
    extends SquareHandle {
        private static final String MOVE_HANDLE_IMAGE_FILE = "MoveHandle.png";

        public MyMoveHandle(GraphicalEditPart owner, Locator loc) {
            super(owner, loc);
            this.setCursor(SharedCursors.SIZEALL);
        }

        protected void init() {
            this.setPreferredSize(16, 16);
        }

        protected Color getBorderColor() {
            return ColorConstants.black;
        }

        protected Color getFillColor() {
            return ColorConstants.white;
        }

        protected DragTracker createDragTracker() {
            DragEditPartsTracker tracker = new DragEditPartsTracker((EditPart)this.getOwner());
            return tracker;
        }

        public void paintFigure(Graphics graphics) {
            super.paintFigure(graphics);
            Image moveImage = PDPlugin.getDefault().getImage(MOVE_HANDLE_IMAGE_FILE);
            Point topLeft = this.getBounds().getTopLeft().getCopy();
            topLeft.performTranslate(3, 3);
            graphics.drawImage(moveImage, topLeft);
        }
    }
}

