/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************
 *
 **/
/**
  * Object fieldSet()
  * @type fieldSet
  * @super Object
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535247.aspx
*/

function fieldSet(){};
fieldSet.prototype= new Object();
/**
  * Property accessKey
  * @type String
  * @returns {String}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533062.aspx
*/

fieldSet.prototype.accessKey="";
/**
  * Property align
  * @type String
  * @returns {String}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533066.aspx
*/

fieldSet.prototype.align="";
/**
  * Property blockDirection
  * @type String
  * @returns {String}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533508.aspx
*/

fieldSet.prototype.blockDirection="";
/**
  * Property canHaveChildren
  * @type Boolean
  * @returns {Boolean}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533546.aspx
*/

fieldSet.prototype.canHaveChildren=false;
/**
  * Property canHaveHTML
  * @type Boolean
  * @returns {Boolean}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537836.aspx
*/

fieldSet.prototype.canHaveHTML=false;
/**
  * Property className
  * @type String
  * @returns {String}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533560.aspx
*/

fieldSet.prototype.className="";
/**
  * Property clientHeight
  * @type Number
  * @returns {Number}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533563.aspx
*/

fieldSet.prototype.clientHeight=0;
/**
  * Property clientLeft
  * @type Number
  * @returns {Number}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533564.aspx
*/

fieldSet.prototype.clientLeft=0;
/**
  * Property offsetLeft
  * @type Number
  * @returns {Number}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534200.aspx
*/

fieldSet.prototype.offsetLeft=0;
/**
  * Property clientTop
  * @type Number
  * @returns {Number}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533565.aspx
*/

fieldSet.prototype.clientTop=0;
/**
  * Property offsetTop
  * @type Number
  * @returns {Number}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534303.aspx
*/

fieldSet.prototype.offsetTop=0;
/**
  * Property clientWidth
  * @type Number
  * @returns {Number}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533566.aspx
*/

fieldSet.prototype.clientWidth=0;
/**
  * Property contentEditable
  * @type String
  * @returns {String}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537837.aspx
*/

fieldSet.prototype.contentEditable="";
/**
  * Property dataFld
  * @type String
  * @returns {String}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533703.aspx
*/

fieldSet.prototype.dataFld="";
/**
  * Property dataSrc
  * @type String
  * @returns {String}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533709.aspx
*/

fieldSet.prototype.dataSrc="";
/**
  * Property dir
  * @type String
  * @returns {String}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533728.aspx
*/

fieldSet.prototype.dir="";
/**
  * Property firstChild
  * @type Object
  * @returns {Object}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533755.aspx
*/

fieldSet.prototype.firstChild=new Object();
/**
  * Property childNodes
  * @type childNodes
  * @returns {childNodes}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537445.aspx
*/

fieldSet.prototype.childNodes= new childNodes();
/**
  * Property form
  * @type Object
  * @returns {Object}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533768.aspx
*/

fieldSet.prototype.form=new Object();
/**
  * Property hideFocus
  * @type Boolean
  * @returns {Boolean}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533783.aspx
*/

fieldSet.prototype.hideFocus=false;
/**
  * Property id
  * @type String
  * @returns {String}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533880.aspx
*/

fieldSet.prototype.id="";
/**
  * Property innerHTML
  * @type String
  * @returns {String}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533897.aspx
*/

fieldSet.prototype.innerHTML="";
/**
  * Property innerText
  * @type String
  * @returns {String}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533899.aspx
*/

fieldSet.prototype.innerText="";
/**
  * Property isContentEditable
  * @type Boolean
  * @returns {Boolean}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537838.aspx
*/

fieldSet.prototype.isContentEditable=false;
/**
  * Property isDisabled
  * @type Boolean
  * @returns {Boolean}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533902.aspx
*/

fieldSet.prototype.isDisabled=false;
/**
  * Property isMultiLine
  * @type Boolean
  * @returns {Boolean}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537839.aspx
*/

fieldSet.prototype.isMultiLine=false;
/**
  * Property isTextEdit
  * @type Boolean
  * @returns {Boolean}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533920.aspx
*/

fieldSet.prototype.isTextEdit=false;
/**
  * Property TextRange
  * @type TextRange
  * @returns {TextRange}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535872.aspx
*/

fieldSet.prototype.TextRange= new TextRange();
/**
  * Property lang
  * @type String
  * @returns {String}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533935.aspx
*/

fieldSet.prototype.lang="";
/**
  * Property language
  * @type String
  * @returns {String}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533940.aspx
*/

fieldSet.prototype.language="";
/**
  * Property lastChild
  * @type Object
  * @returns {Object}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533943.aspx
*/

fieldSet.prototype.lastChild=new Object();
/**
  * Property nextSibling
  * @type Object
  * @returns {Object}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534189.aspx
*/

fieldSet.prototype.nextSibling=new Object();
/**
  * Property nodeName
  * @type String
  * @returns {String}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534190.aspx
*/

fieldSet.prototype.nodeName="";
/**
  * Property nodeType
  * @type Number
  * @returns {Number}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534191.aspx
*/

fieldSet.prototype.nodeType=0;
/**
  * Property nodeValue
  * @type Object
  * @returns {Object}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534192.aspx
*/

fieldSet.prototype.nodeValue=new Object();
/**
  * Property offsetHeight
  * @type Number
  * @returns {Number}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534199.aspx
*/

fieldSet.prototype.offsetHeight=0;
/**
  * Property offsetParent
  * @type Object
  * @returns {Object}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534302.aspx
*/

fieldSet.prototype.offsetParent=new Object();
/**
  * Property offsetWidth
  * @type Number
  * @returns {Number}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534304.aspx
*/

fieldSet.prototype.offsetWidth=0;
/**
  * Property onOffBehavior
  * @type DABoolean
  * @returns {DABoolean}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533630.aspx
*/

fieldSet.prototype.onOffBehavior=new DABoolean();
/**
  * Property outerHTML
  * @type String
  * @returns {String}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534310.aspx
*/

fieldSet.prototype.outerHTML="";
/**
  * Property outerText
  * @type String
  * @returns {String}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534311.aspx
*/

fieldSet.prototype.outerText="";
/**
  * Property ownerDocument
  * @type document
  * @returns {document}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534315.aspx
*/

fieldSet.prototype.ownerDocument=new document();
/**
  * Property document
  * @type document
  * @returns {document}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms531073.aspx
*/

fieldSet.prototype.document= new document();
/**
  * Property parentElement
  * @type Object
  * @returns {Object}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534327.aspx
*/

fieldSet.prototype.parentElement=new Object();
/**
  * Property parentNode
  * @type Object
  * @returns {Object}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534328.aspx
*/

fieldSet.prototype.parentNode=new Object();
/**
  * Property parentTextEdit
  * @type Object
  * @returns {Object}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534330.aspx
*/

fieldSet.prototype.parentTextEdit=new Object();
/**
  * Property previousSibling
  * @type Object
  * @returns {Object}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534350.aspx
*/

fieldSet.prototype.previousSibling=new Object();
/**
  * Property readyState
  * @type Object
  * @returns {Object}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534358.aspx
*/

fieldSet.prototype.readyState=new Object();
/**
  * Property scopeName
  * @type String
  * @returns {String}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534388.aspx
*/

fieldSet.prototype.scopeName="";
/**
  * Property scrollHeight
  * @type Object
  * @returns {Object}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534615.aspx
*/

fieldSet.prototype.scrollHeight=new Object();
/**
  * Property scrollLeft
  * @type Number
  * @returns {Number}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534617.aspx
*/

fieldSet.prototype.scrollLeft=0;
/**
  * Property scrollTop
  * @type Number
  * @returns {Number}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534618.aspx
*/

fieldSet.prototype.scrollTop=0;
/**
  * Property scrollWidth
  * @type Object
  * @returns {Object}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534619.aspx
*/

fieldSet.prototype.scrollWidth=new Object();
/**
  * Property sourceIndex
  * @type Number
  * @returns {Number}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534635.aspx
*/

fieldSet.prototype.sourceIndex=0;
/**
  * Property all
  * @type all
  * @returns {all}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537434.aspx
*/

fieldSet.prototype.all= new all();
/**
  * Property tabIndex
  * @type Number
  * @returns {Number}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534654.aspx
*/

fieldSet.prototype.tabIndex=0;
/**
  * Property tagName
  * @type String
  * @returns {String}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534657.aspx
*/

fieldSet.prototype.tagName="";
/**
  * Property tagUrn
  * @type String
  * @returns {String}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534658.aspx
*/

fieldSet.prototype.tagUrn="";
/**
  * Property title
  * @type String
  * @returns {String}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534683.aspx
*/

fieldSet.prototype.title="";
/**
  * Property uniqueID
  * @type String
  * @returns {String}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534704.aspx
*/

fieldSet.prototype.uniqueID="";
/**
  * function addBehavior(sUrl)
  * @param {String} sUrl
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535922.aspx
*/

fieldSet.prototype.addBehavior=function(sUrl){};
/**
  * function appendChild(oNode)
  * @param {appendChild} oNode
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535934.aspx
*/

fieldSet.prototype.appendChild=function(oNode){};
/**
  * function applyElement(oNewElement)
  * @param {String} oNewElement
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536341.aspx
*/

fieldSet.prototype.applyElement=function(oNewElement){};
/**
  * function attachEvent(sEvent,fpNotify)
  * @param {String} sEvent
  * @param {Boolean} fpNotify
  * @type Boolean
  * @returns {Boolean}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536343.aspx
*/

fieldSet.prototype.attachEvent=function(sEvent,fpNotify){};
/**
  * function blur()
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536347.aspx
*/

fieldSet.prototype.blur=function(){};
/**
  * Property onblur
  * @type onblur
  * @returns {onblur}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536909.aspx
*/

fieldSet.prototype.onblur= new onblur();
/**
  * function clearAttributes()
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536350.aspx
*/

fieldSet.prototype.clearAttributes=function(){};
/**
  * function click()
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536363.aspx
*/

fieldSet.prototype.click=function(){};
/**
  * Property onclick
  * @type onclick
  * @returns {onclick}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536913.aspx
*/

fieldSet.prototype.onclick= new onclick();
/**
  * function cloneNode(bCloneChildren)
  * @param {Boolean} bCloneChildren
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536365.aspx
*/

fieldSet.prototype.cloneNode=function(bCloneChildren){};
/**
  * function componentFromPoint(iCoordX,iCoordY)
  * @param {Number} iCoordX
  * @param {Number} iCoordY
  * @type String
  * @returns {String}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536375.aspx
*/

fieldSet.prototype.componentFromPoint=function(iCoordX,iCoordY){};
/**
  * function contains(oElement)
  * @param {Boolean} oElement
  * @type Boolean
  * @returns {Boolean}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536377.aspx
*/

fieldSet.prototype.contains=function(oElement){};
/**
  * function detachEvent(sEvent,fpNotify)
  * @param {String} sEvent
  * @param {attachEvent} fpNotify
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536411.aspx
*/

fieldSet.prototype.detachEvent=function(sEvent,fpNotify){};
/**
  * function fireEvent(sEvent,oEventObject)
  * @param {String} sEvent
  * @param {event} oEventObject
  * @type Boolean
  * @returns {Boolean}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536423.aspx
*/

fieldSet.prototype.fireEvent=function(sEvent,oEventObject){};
/**
  * function focus()
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536425.aspx
*/

fieldSet.prototype.focus=function(){};
/**
  * Property onfocus
  * @type onfocus
  * @returns {onfocus}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536934.aspx
*/

fieldSet.prototype.onfocus= new onfocus();
/**
  * function getAdjacentText(sWhere)
  * @param {String} sWhere
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536427.aspx
*/

fieldSet.prototype.getAdjacentText=function(sWhere){};
/**
  * function getAttribute(sAttrName,iFlags,sAttrName)
  * @param {String} sAttrName
  * @param {Number} iFlags
  * @param {getAttribute} sAttrName
  * @type Object
  * @returns {Object}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536429.aspx
*/

fieldSet.prototype.getAttribute=function(sAttrName,iFlags,sAttrName){};
/**
  * function getAttributeNode(sName)
  * @param {String} sName
  * @type attribute
  * @returns {attribute}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536430.aspx
*/

fieldSet.prototype.getAttributeNode=function(sName){};
/**
  * Property attribute
  * @type attribute
  * @returns {attribute}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535187.aspx
*/

fieldSet.prototype.attribute= new attribute();
/**
  * Property name
  * @type String
  * @returns {String}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534184.aspx
*/

fieldSet.prototype.name="";
/**
  * function getBoundingClientRect()
  * @type TextRectangle
  * @returns {TextRectangle}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536433.aspx
*/

fieldSet.prototype.getBoundingClientRect=function(){};
/**
  * Property TextRectangle
  * @type TextRectangle
  * @returns {TextRectangle}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535906.aspx
*/

fieldSet.prototype.TextRectangle= new TextRectangle();
/**
  * function getClientRects()
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536435.aspx
*/

fieldSet.prototype.getClientRects=function(){};
/**
  * function getElementsByTagName(sTagName)
  * @param {String} sTagName
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536439.aspx
*/

fieldSet.prototype.getElementsByTagName=function(sTagName){};
/**
  * function getExpression(sPropertyName)
  * @param {String} sPropertyName
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/aa358797.aspx
*/

fieldSet.prototype.getExpression=function(sPropertyName){};
/**
  * function hasChildNodes()
  * @type HTML Elements
  * @returns {HTML}
 Elements
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536445.aspx
*/

fieldSet.prototype.hasChildNodes=function(){};
/**
  * function insertAdjacentElement(sWhere,oElement)
  * @param {String} sWhere
  * @param {insertAdjacentElement} oElement
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536451.aspx
*/

fieldSet.prototype.insertAdjacentElement=function(sWhere,oElement){};
/**
  * function insertAdjacentHTML(sWhere,sText)
  * @param {String} sWhere
  * @param {String} sText
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536452.aspx
*/

fieldSet.prototype.insertAdjacentHTML=function(sWhere,sText){};
/**
  * function insertAdjacentText(sWhere,sText)
  * @param {String} sWhere
  * @param {String} sText
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536453.aspx
*/

fieldSet.prototype.insertAdjacentText=function(sWhere,sText){};
/**
  * function insertBefore(oNewNode,oChildNode)
  * @param {Object} oNewNode
  * @param {Object} oChildNode
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536454.aspx
*/

fieldSet.prototype.insertBefore=function(oNewNode,oChildNode){};
/**
  * function mergeAttributes(oSource,bPreserve)
  * @param {Object} oSource
  * @param {Boolean} bPreserve
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536614.aspx
*/

fieldSet.prototype.mergeAttributes=function(oSource,bPreserve){};
/**
  * function normalize()
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536646.aspx
*/

fieldSet.prototype.normalize=function(){};
/**
  * function releaseCapture()
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536689.aspx
*/

fieldSet.prototype.releaseCapture=function(){};
/**
  * function removeAttribute(sName,iCaseSensitive)
  * @param {String} sName
  * @param {Number} iCaseSensitive
  * @type Boolean
  * @returns {Boolean}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536696.aspx
*/

fieldSet.prototype.removeAttribute=function(sName,iCaseSensitive){};
/**
  * function removeAttributeNode(oSrcAttribute)
  * @param {attribute} oSrcAttribute
  * @type attribute
  * @returns {attribute}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536698.aspx
*/

fieldSet.prototype.removeAttributeNode=function(oSrcAttribute){};
/**
  * function removeBehavior(iID)
  * @param {Number} iID
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536700.aspx
*/

fieldSet.prototype.removeBehavior=function(iID){};
/**
  * function removeChild(oNode)
  * @param {Object} oNode
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536702.aspx
*/

fieldSet.prototype.removeChild=function(oNode){};
/**
  * function removeExpression(sPropertyName)
  * @param {String} sPropertyName
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/aa358798.aspx
*/

fieldSet.prototype.removeExpression=function(sPropertyName){};
/**
  * function removeNode(bRemoveChildren)
  * @param {Boolean} bRemoveChildren
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536708.aspx
*/

fieldSet.prototype.removeNode=function(bRemoveChildren){};
/**
  * function replaceAdjacentText(sWhere,sReplaceText)
  * @param {String} sWhere
  * @param {String} sReplaceText
  * @type String
  * @returns {String}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536714.aspx
*/

fieldSet.prototype.replaceAdjacentText=function(sWhere,sReplaceText){};
/**
  * function replaceChild(oNewNode,oChildNode)
  * @param {Object} oNewNode
  * @param {Object} oChildNode
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536716.aspx
*/

fieldSet.prototype.replaceChild=function(oNewNode,oChildNode){};
/**
  * function replaceNode(oNewNode)
  * @param {Object} oNewNode
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536719.aspx
*/

fieldSet.prototype.replaceNode=function(oNewNode){};
/**
  * function scrollIntoView(bAlignToTop)
  * @param {Boolean} bAlignToTop
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536730.aspx
*/

fieldSet.prototype.scrollIntoView=function(bAlignToTop){};
/**
  * function setActive()
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536738.aspx
*/

fieldSet.prototype.setActive=function(){};
/**
  * function setAttribute(sName,vValue)
  * @param {String} sName
  * @param {Number} vValue
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536739.aspx
*/

fieldSet.prototype.setAttribute=function(sName,vValue){};
/**
  * function setAttributeNode(oSrcAttribute)
  * @param {attribute} oSrcAttribute
  * @type attribute
  * @returns {attribute}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536741.aspx
*/

fieldSet.prototype.setAttributeNode=function(oSrcAttribute){};
/**
  * function setCapture(bContainerCapture)
  * @param {Boolean} bContainerCapture
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536742.aspx
*/

fieldSet.prototype.setCapture=function(bContainerCapture){};
/**
  * function setExpression(sPropertyName,sExpression,sLanguage)
  * @param {String} sPropertyName
  * @param {String} sExpression
  * @param {String} sLanguage
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms531196.aspx
*/

fieldSet.prototype.setExpression=function(sPropertyName,sExpression,sLanguage){};
/**
  * function swapNode(oNode)
  * @param {Object} oNode
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536774.aspx
*/

fieldSet.prototype.swapNode=function(oNode){};
/**
  * Property onactivate
  * @type onactivate
  * @returns {onactivate}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536787.aspx
*/

fieldSet.prototype.onactivate= new onactivate();
/**
  * Property activeElement
  * @type Object
  * @returns {Object}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533065.aspx
*/

fieldSet.prototype.activeElement=new Object();
/**
  * Property onbeforeactivate
  * @type onbeforeactivate
  * @returns {onbeforeactivate}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536791.aspx
*/

fieldSet.prototype.onbeforeactivate= new onbeforeactivate();
/**
  * Property onbeforecopy
  * @type onbeforecopy
  * @returns {onbeforecopy}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536901.aspx
*/

fieldSet.prototype.onbeforecopy= new onbeforecopy();
/**
  * Property onbeforecut
  * @type onbeforecut
  * @returns {onbeforecut}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536902.aspx
*/

fieldSet.prototype.onbeforecut= new onbeforecut();
/**
  * Property onbeforedeactivate
  * @type onbeforedeactivate
  * @returns {onbeforedeactivate}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536903.aspx
*/

fieldSet.prototype.onbeforedeactivate= new onbeforedeactivate();
/**
  * Property onbeforeeditfocus
  * @type onbeforeeditfocus
  * @returns {onbeforeeditfocus}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536904.aspx
*/

fieldSet.prototype.onbeforeeditfocus= new onbeforeeditfocus();
/**
  * Property onbeforepaste
  * @type onbeforepaste
  * @returns {onbeforepaste}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536905.aspx
*/

fieldSet.prototype.onbeforepaste= new onbeforepaste();
/**
  * Property onblur
  * @type onblur
  * @returns {onblur}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536909.aspx
*/

fieldSet.prototype.onblur= new onblur();
/**
  * Property onclick
  * @type onclick
  * @returns {onclick}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536913.aspx
*/

fieldSet.prototype.onclick= new onclick();
/**
  * Property oncontextmenu
  * @type oncontextmenu
  * @returns {oncontextmenu}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536914.aspx
*/

fieldSet.prototype.oncontextmenu= new oncontextmenu();
/**
  * Property oncontrolselect
  * @type oncontrolselect
  * @returns {oncontrolselect}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537844.aspx
*/

fieldSet.prototype.oncontrolselect= new oncontrolselect();
/**
  * Property oncopy
  * @type oncopy
  * @returns {oncopy}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536916.aspx
*/

fieldSet.prototype.oncopy= new oncopy();
/**
  * Property oncut
  * @type oncut
  * @returns {oncut}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536917.aspx
*/

fieldSet.prototype.oncut= new oncut();
/**
  * Property ondblclick
  * @type ondblclick
  * @returns {ondblclick}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536921.aspx
*/

fieldSet.prototype.ondblclick= new ondblclick();
/**
  * Property ondeactivate
  * @type ondeactivate
  * @returns {ondeactivate}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536922.aspx
*/

fieldSet.prototype.ondeactivate= new ondeactivate();
/**
  * Property ondrag
  * @type ondrag
  * @returns {ondrag}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536923.aspx
*/

fieldSet.prototype.ondrag= new ondrag();
/**
  * Property ondragend
  * @type ondragend
  * @returns {ondragend}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536924.aspx
*/

fieldSet.prototype.ondragend= new ondragend();
/**
  * Property ondragenter
  * @type ondragenter
  * @returns {ondragenter}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536925.aspx
*/

fieldSet.prototype.ondragenter= new ondragenter();
/**
  * Property ondragleave
  * @type ondragleave
  * @returns {ondragleave}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536926.aspx
*/

fieldSet.prototype.ondragleave= new ondragleave();
/**
  * Property ondragover
  * @type ondragover
  * @returns {ondragover}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536927.aspx
*/

fieldSet.prototype.ondragover= new ondragover();
/**
  * Property ondragstart
  * @type ondragstart
  * @returns {ondragstart}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536928.aspx
*/

fieldSet.prototype.ondragstart= new ondragstart();
/**
  * Property ondrop
  * @type ondrop
  * @returns {ondrop}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536929.aspx
*/

fieldSet.prototype.ondrop= new ondrop();
/**
  * Property onfilterchange
  * @type onfilterchange
  * @returns {onfilterchange}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536932.aspx
*/

fieldSet.prototype.onfilterchange= new onfilterchange();
/**
  * Property onfocus
  * @type onfocus
  * @returns {onfocus}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536934.aspx
*/

fieldSet.prototype.onfocus= new onfocus();
/**
  * Property onfocusin
  * @type onfocusin
  * @returns {onfocusin}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536935.aspx
*/

fieldSet.prototype.onfocusin= new onfocusin();
/**
  * Property onfocusout
  * @type onfocusout
  * @returns {onfocusout}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536936.aspx
*/

fieldSet.prototype.onfocusout= new onfocusout();
/**
  * Property onhelp
  * @type onhelp
  * @returns {onhelp}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536937.aspx
*/

fieldSet.prototype.onhelp= new onhelp();
/**
  * Property onkeydown
  * @type onkeydown
  * @returns {onkeydown}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536938.aspx
*/

fieldSet.prototype.onkeydown= new onkeydown();
/**
  * Property onkeypress
  * @type onkeypress
  * @returns {onkeypress}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536939.aspx
*/

fieldSet.prototype.onkeypress= new onkeypress();
/**
  * Property onkeyup
  * @type onkeyup
  * @returns {onkeyup}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536940.aspx
*/

fieldSet.prototype.onkeyup= new onkeyup();
/**
  * Property onlosecapture
  * @type onlosecapture
  * @returns {onlosecapture}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536943.aspx
*/

fieldSet.prototype.onlosecapture= new onlosecapture();
/**
  * Property onmousedown
  * @type onmousedown
  * @returns {onmousedown}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536944.aspx
*/

fieldSet.prototype.onmousedown= new onmousedown();
/**
  * Property onmouseenter
  * @type onmouseenter
  * @returns {onmouseenter}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536945.aspx
*/

fieldSet.prototype.onmouseenter= new onmouseenter();
/**
  * Property onmouseleave
  * @type onmouseleave
  * @returns {onmouseleave}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536946.aspx
*/

fieldSet.prototype.onmouseleave= new onmouseleave();
/**
  * Property onmousemove
  * @type onmousemove
  * @returns {onmousemove}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536947.aspx
*/

fieldSet.prototype.onmousemove= new onmousemove();
/**
  * Property onmouseout
  * @type onmouseout
  * @returns {onmouseout}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536948.aspx
*/

fieldSet.prototype.onmouseout= new onmouseout();
/**
  * Property onmouseover
  * @type onmouseover
  * @returns {onmouseover}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536949.aspx
*/

fieldSet.prototype.onmouseover= new onmouseover();
/**
  * Property onmouseup
  * @type onmouseup
  * @returns {onmouseup}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536950.aspx
*/

fieldSet.prototype.onmouseup= new onmouseup();
/**
  * Property onmousewheel
  * @type onmousewheel
  * @returns {onmousewheel}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536951.aspx
*/

fieldSet.prototype.onmousewheel= new onmousewheel();
/**
  * Property onmove
  * @type onmove
  * @returns {onmove}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536952.aspx
*/

fieldSet.prototype.onmove= new onmove();
/**
  * Property onmoveend
  * @type onmoveend
  * @returns {onmoveend}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536953.aspx
*/

fieldSet.prototype.onmoveend= new onmoveend();
/**
  * Property onmovestart
  * @type onmovestart
  * @returns {onmovestart}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536954.aspx
*/

fieldSet.prototype.onmovestart= new onmovestart();
/**
  * Property onpaste
  * @type onpaste
  * @returns {onpaste}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536955.aspx
*/

fieldSet.prototype.onpaste= new onpaste();
/**
  * Property onpropertychange
  * @type onpropertychange
  * @returns {onpropertychange}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536956.aspx
*/

fieldSet.prototype.onpropertychange= new onpropertychange();
/**
  * Property onreadystatechange
  * @type onreadystatechange
  * @returns {onreadystatechange}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536957.aspx
*/

fieldSet.prototype.onreadystatechange= new onreadystatechange();
/**
  * Property onresize
  * @type onresize
  * @returns {onresize}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536959.aspx
*/

fieldSet.prototype.onresize= new onresize();
/**
  * Property onresizeend
  * @type onresizeend
  * @returns {onresizeend}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536960.aspx
*/

fieldSet.prototype.onresizeend= new onresizeend();
/**
  * Property onresizestart
  * @type onresizestart
  * @returns {onresizestart}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536961.aspx
*/

fieldSet.prototype.onresizestart= new onresizestart();
/**
  * Property onselectstart
  * @type onselectstart
  * @returns {onselectstart}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536969.aspx
*/

fieldSet.prototype.onselectstart= new onselectstart();
/**
  * Property ontimeerror
  * @type ontimeerror
  * @returns {ontimeerror}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533588.aspx
*/

fieldSet.prototype.ontimeerror= new ontimeerror();
/**
  * Property all
  * @type all
  * @returns {all}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537434.aspx
*/

fieldSet.prototype.all= new all();
/**
  * Property attributes
  * @type attributes
  * @returns {attributes}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537438.aspx
*/

fieldSet.prototype.attributes= new attributes();
/**
  * Property behaviorUrns
  * @type behaviorUrns
  * @returns {behaviorUrns}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537439.aspx
*/

fieldSet.prototype.behaviorUrns= new behaviorUrns();
/**
  * Property childNodes
  * @type childNodes
  * @returns {childNodes}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537445.aspx
*/

fieldSet.prototype.childNodes= new childNodes();
/**
  * Property TextNode
  * @type TextNode
  * @returns {TextNode}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535905.aspx
*/

fieldSet.prototype.TextNode= new TextNode();
/**
  * Property children
  * @type children
  * @returns {children}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537446.aspx
*/

fieldSet.prototype.children= new children();
/**
  * Property filters
  * @type filters
  * @returns {filters}
  * @memberOf fieldSet
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537452.aspx
*/

fieldSet.prototype.filters= new filters();
