/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.parser;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class SelectionTest3 {
    @Rule
    public TestName name = new TestName();
    private String fContents1 = "/*\n * Attempt content assist on each function, verify that the proposal shows up, that\n * camel case CA works, the the propsoal looks correct, the proposal info is displayed,\n * that occurance support works, that F3 works, that hover help is displayed, and that\n * the function is correctly displayed in the outline.\n * \n * Also test out local functions, check functions that mask global functions. Try out\n * F3 and occurance support on function calls that have different parameter numbers than\n * the declared function.\n */\n\nfunction zooKeeper() {\n\t\n}\n\n/**\n * Some doc about zooKeeper1, can you see it?\n */\nfunction zooKeeper1() {\n\t\n}\n\nfunction zooKeeper2() {\n\treturn \"zoo\";\n}\n\n/**\n * \n * @returns {Boolean}\n */\nfunction zooKeeper3() {\n\treturn a;\n}\n\nfunction zooKeeper4(a, b) {\n\t\n}\n\n/**\n * Some doc about zooKeeper5\n * \n * @param {String} a\n * @param {Number} b\n */\nfunction zooKeeper5(a, b) {\n}\n\nfunction zooKeeper6(a) {\n\treturn true;\n}\n\n/**\n * hi\n * @param {Date} a\n * @returns {Date}\n */\nfunction zooKeeper7(a) {\n\treturn a;\n}\n\nzooKeeper();\nzooKeeper(1);\nzooKeeper1();\nzooKeeper2();\nzooKeeper3();\nzooKeeper4(1, 3);\nzooKeeper5(\"hi\", 3);\nzooKeeper6(1);\nzooKeeper7(new Date());\nzooKeeper7();\n\nfunction local1() {\n\t/**\n\t * hi\n\t */\n\tfunction zooKeeper7() {}\n\tfunction zooKeeper8(a) {}\n\t\n\tzooKeeper7();\n}\n";

    private IJavaScriptUnit getUnit(String string) throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("SelectionTest3_" + this.getName());
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription("SelectionTest3_" + this.getName());
        description.setNatureIds(new String[]{"org.eclipse.wst.jsdt.core.jsNature"});
        project.create(description, null);
        project.open(null);
        IFile file = project.getFile("testfile.js");
        file.create((InputStream)new ByteArrayInputStream(string.getBytes()), true, null);
        return (IJavaScriptUnit)JavaScriptCore.create((IFile)file);
    }

    @Test
    public void test01() throws Exception {
        IJavaScriptUnit unit = this.getUnit(this.fContents1);
        int offset = this.fContents1.indexOf("zooKeeper();\n");
        IJavaScriptElement[] selected = unit.codeSelect(offset, 9);
        Assert.assertEquals((String)"unexpected number of elements", (long)1L, (long)selected.length);
        Assert.assertEquals((String)"unexpected element", (Object)"zooKeeper", (Object)selected[0].getElementName());
        Assert.assertEquals((String)"unexpected element type", (long)9L, (long)selected[0].getElementType());
    }

    @Test
    public void test02() throws Exception {
        IJavaScriptUnit unit = this.getUnit(this.fContents1);
        int offset = this.fContents1.indexOf("zooKeeper2();\n");
        IJavaScriptElement[] selected = unit.codeSelect(offset, 10);
        Assert.assertEquals((String)"unexpected number of elements", (long)1L, (long)selected.length);
        Assert.assertEquals((String)"unexpected element", (Object)"zooKeeper2", (Object)selected[0].getElementName());
        Assert.assertEquals((String)"unexpected element type", (long)9L, (long)selected[0].getElementType());
    }

    @Test
    public void test03() throws Exception {
        IJavaScriptUnit unit = this.getUnit(this.fContents1);
        int offset = this.fContents1.indexOf("zooKeeper3();\n");
        IJavaScriptElement[] selected = unit.codeSelect(offset, 10);
        Assert.assertEquals((String)"unexpected number of elements", (long)1L, (long)selected.length);
        Assert.assertEquals((String)"unexpected element", (Object)"zooKeeper3", (Object)selected[0].getElementName());
        Assert.assertEquals((String)"unexpected element type", (long)9L, (long)selected[0].getElementType());
    }

    @Test
    public void test04() throws Exception {
        IJavaScriptUnit unit = this.getUnit(this.fContents1);
        int offset = this.fContents1.indexOf("zooKeeper5(\"hi");
        IJavaScriptElement[] selected = unit.codeSelect(offset, 10);
        Assert.assertEquals((String)"unexpected number of elements", (long)1L, (long)selected.length);
        Assert.assertEquals((String)"unexpected element", (Object)"zooKeeper5", (Object)selected[0].getElementName());
        Assert.assertEquals((String)"unexpected element type", (long)9L, (long)selected[0].getElementType());
    }

    @Test
    public void test05() throws Exception {
        IJavaScriptUnit unit = this.getUnit(this.fContents1);
        int offset = this.fContents1.indexOf("zooKeeper6(1");
        IJavaScriptElement[] selected = unit.codeSelect(offset, 10);
        Assert.assertEquals((String)"unexpected number of elements", (long)1L, (long)selected.length);
        Assert.assertEquals((String)"unexpected element", (Object)"zooKeeper6", (Object)selected[0].getElementName());
        Assert.assertEquals((String)"unexpected element type", (long)9L, (long)selected[0].getElementType());
    }

    private String getName() {
        return this.name.getMethodName();
    }
}

