/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.creation.ui.widgets.skeleton;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.ws.internal.axis.consumption.core.common.JavaWSDLParameter;
import org.eclipse.jst.ws.internal.axis.consumption.ui.AxisConsumptionUIMessages;
import org.eclipse.jst.ws.internal.axis.creation.ui.AxisCreationUIMessages;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class SkeletonConfigWidget
extends SimpleWidgetDataContributor {
    private JavaWSDLParameter javaWSDLParam;
    private static final String INFOPOP_PBSC_PAGE = "PBSC0001";
    private Combo skeletonFolderText_;
    private static final String INFOPOP_PBSC_TEXT_SKELETON_FOLDER = "PBSC0004";
    private Button showMappingsCheckbox_;
    private String INFOPOP_N2P_SHOW_MAPPINGS = "PBSC0016";
    private IProject serverProject_;

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        String pluginId = "org.eclipse.jst.ws.axis.creation.ui";
        UIUtils uiUtils = new UIUtils(pluginId);
        UIUtils conUiUtils = new UIUtils(pluginId);
        UIUtils baseConUiUtils = new UIUtils(pluginId);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(pluginId) + "." + INFOPOP_PBSC_PAGE);
        parent.setToolTipText(AxisCreationUIMessages.TOOLTIP_PBSC_PAGE);
        Composite textGroup = uiUtils.createComposite(parent, 2, 0, 0);
        this.skeletonFolderText_ = baseConUiUtils.createCombo(textGroup, ConsumptionUIMessages.LABEL_SKELETON_ROOT_NAME, ConsumptionUIMessages.TOOLTIP_PBSC_TEXT_SKELETON_FOLDER, INFOPOP_PBSC_TEXT_SKELETON_FOLDER, 2060);
        this.showMappingsCheckbox_ = conUiUtils.createCheckbox(parent, AxisConsumptionUIMessages.LABEL_EXPLORE_MAPPINGS_XML2BEAN, AxisConsumptionUIMessages.TOOLTIP_N2P_SHOW_MAPPINGS, this.INFOPOP_N2P_SHOW_MAPPINGS);
        return this;
    }

    public void setEndpointURI(String endpointURI) {
    }

    public void setOutputJavaFolder(String outputJavaFolder) {
        if (outputJavaFolder != null) {
            int index = this.skeletonFolderText_.indexOf(outputJavaFolder);
            if (index != -1) {
                this.skeletonFolderText_.select(index);
            } else if (this.skeletonFolderText_.getItemCount() <= 0) {
                String root = this.getWorkspaceRootLocation();
                if (outputJavaFolder.startsWith(root)) {
                    this.skeletonFolderText_.setText(outputJavaFolder.substring(root.length()));
                } else {
                    this.skeletonFolderText_.setText(outputJavaFolder);
                }
            }
        }
    }

    public void setShowMapping(boolean showMapping) {
        this.showMappingsCheckbox_.setSelection(showMapping);
    }

    public boolean getShowMapping() {
        return this.showMappingsCheckbox_.getSelection();
    }

    public JavaWSDLParameter getJavaWSDLParam() {
        String projectPathString;
        String projectSpecificRoot = this.serverProject_.getLocation().toString();
        String skeletonFolder = this.skeletonFolderText_.getText();
        if (skeletonFolder.startsWith(projectPathString = this.serverProject_.getFullPath().toString())) {
            skeletonFolder = skeletonFolder.substring(projectPathString.length());
        }
        this.javaWSDLParam.setJavaOutput(String.valueOf(projectSpecificRoot) + skeletonFolder);
        return this.javaWSDLParam;
    }

    public void setJavaWSDLParam(JavaWSDLParameter javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
    }

    public void setServerProject(IProject serviceProject) {
        this.serverProject_ = serviceProject;
        String originalSkeletonFolder = this.skeletonFolderText_.getText();
        this.skeletonFolderText_.removeAll();
        IPath[] paths = ResourceUtils.getAllJavaSourceLocations((IProject)serviceProject);
        int i = 0;
        while (i < paths.length) {
            this.skeletonFolderText_.add(paths[i].toString());
            ++i;
        }
        int index = this.skeletonFolderText_.indexOf(originalSkeletonFolder);
        if (index != -1) {
            this.skeletonFolderText_.select(index);
        } else {
            this.skeletonFolderText_.select(0);
        }
    }

    private String getWorkspaceRootLocation() {
        return ResourcesPlugin.getWorkspace().getRoot().getLocation().removeTrailingSeparator().toString();
    }
}

