/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.stack;

import java.util.Arrays;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.stack.LinkedStack;
import org.eclipse.jpt.common.utility.internal.stack.StackTools;
import org.eclipse.jpt.common.utility.stack.Stack;
import org.eclipse.jpt.common.utility.tests.internal.stack.StackTests;

public class LinkedStackTests
extends StackTests {
    public LinkedStackTests(String name) {
        super(name);
    }

    @Override
    Stack<String> buildStack() {
        return StackTools.linkedStack();
    }

    public void testConstructorInt_IAE() throws Exception {
        boolean exCaught = false;
        try {
            LinkedStack stack = StackTools.linkedStack((int)-3);
            LinkedStackTests.fail((String)("bogus stack: " + stack));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        LinkedStackTests.assertTrue((boolean)exCaught);
    }

    public void testSize() {
        Stack<String> stack = this.buildStack();
        String first = "first";
        String second = "second";
        String third = "third";
        LinkedStackTests.assertEquals((int)0, (int)((Integer)ObjectTools.execute(stack, (String)"size")));
        stack.push((Object)first);
        stack.push((Object)second);
        LinkedStackTests.assertEquals((int)2, (int)((Integer)ObjectTools.execute(stack, (String)"size")));
        stack.push((Object)third);
        LinkedStackTests.assertEquals((int)3, (int)((Integer)ObjectTools.execute(stack, (String)"size")));
        stack.pop();
        LinkedStackTests.assertEquals((int)2, (int)((Integer)ObjectTools.execute(stack, (String)"size")));
        stack.pop();
        stack.pop();
        LinkedStackTests.assertEquals((int)0, (int)((Integer)ObjectTools.execute(stack, (String)"size")));
    }

    public void testBuildElements() {
        Stack<String> stack = this.buildStack();
        String first = "first";
        String second = "second";
        String third = "third";
        stack.push((Object)first);
        stack.push((Object)second);
        stack.push((Object)third);
        Object[] elements = new Object[]{third, second, first};
        LinkedStackTests.assertTrue((boolean)Arrays.equals(elements, (Object[])ObjectTools.execute(stack, (String)"buildElements")));
    }

    public void testNodeCache_max() {
        LinkedStack stack = new LinkedStack(2);
        String first = "first";
        String second = "second";
        String third = "third";
        String fourth = "fourth";
        String fifth = "fifth";
        Object factory = ObjectTools.get((Object)stack, (String)"nodeFactory");
        this.verifyNodeCache(0, factory);
        stack.push((Object)first);
        this.verifyNodeCache(0, factory);
        stack.push((Object)second);
        stack.push((Object)third);
        stack.push((Object)fourth);
        stack.push((Object)fifth);
        this.verifyNodeCache(0, factory);
        LinkedStackTests.assertNull((Object)ObjectTools.get((Object)factory, (String)"cacheHead"));
        stack.pop();
        this.verifyNodeCache(1, factory);
        stack.pop();
        this.verifyNodeCache(2, factory);
        stack.pop();
        this.verifyNodeCache(2, factory);
        stack.pop();
        this.verifyNodeCache(2, factory);
        stack.pop();
        this.verifyNodeCache(2, factory);
        stack.push((Object)first);
        this.verifyNodeCache(1, factory);
        stack.push((Object)second);
        this.verifyNodeCache(0, factory);
        stack.push((Object)third);
        this.verifyNodeCache(0, factory);
    }

    public void testNodeCache_unlimited() {
        LinkedStack stack = new LinkedStack(-1);
        String first = "first";
        String second = "second";
        String third = "third";
        String fourth = "fourth";
        String fifth = "fifth";
        Object factory = ObjectTools.get((Object)stack, (String)"nodeFactory");
        this.verifyNodeCache(0, factory);
        stack.push((Object)first);
        this.verifyNodeCache(0, factory);
        stack.push((Object)second);
        stack.push((Object)third);
        stack.push((Object)fourth);
        stack.push((Object)fifth);
        this.verifyNodeCache(0, factory);
        LinkedStackTests.assertNull((Object)ObjectTools.get((Object)factory, (String)"cacheHead"));
        stack.pop();
        this.verifyNodeCache(1, factory);
        stack.pop();
        this.verifyNodeCache(2, factory);
        stack.pop();
        this.verifyNodeCache(3, factory);
        stack.pop();
        this.verifyNodeCache(4, factory);
        stack.pop();
        this.verifyNodeCache(5, factory);
        stack.push((Object)first);
        this.verifyNodeCache(4, factory);
        stack.push((Object)second);
        this.verifyNodeCache(3, factory);
        stack.push((Object)third);
        this.verifyNodeCache(2, factory);
        stack.push((Object)fourth);
        this.verifyNodeCache(1, factory);
        stack.push((Object)fifth);
        this.verifyNodeCache(0, factory);
    }

    public void verifyNodeCache(int size, Object factory) {
        LinkedStackTests.assertEquals((int)size, (int)((Integer)ObjectTools.get((Object)factory, (String)"cacheSize")));
        int nodeCount = 0;
        Object node = ObjectTools.get((Object)factory, (String)"cacheHead");
        while (node != null) {
            ++nodeCount;
            node = ObjectTools.get((Object)node, (String)"next");
        }
        LinkedStackTests.assertEquals((int)size, (int)nodeCount);
    }

    public void testNodeToString() {
        LinkedStack queue = StackTools.linkedStack();
        String first = "first";
        String second = "second";
        String third = "third";
        queue.push((Object)first);
        queue.push((Object)second);
        queue.push((Object)third);
        Object head = ObjectTools.get((Object)queue, (String)"head");
        LinkedStackTests.assertTrue((boolean)head.toString().startsWith("LinkedStack.Node"));
        LinkedStackTests.assertTrue((boolean)head.toString().endsWith("(third)"));
    }

    public void testToString_empty() throws Exception {
        Stack<String> stack = this.buildStack();
        LinkedStackTests.assertEquals((String)"[]", (String)stack.toString());
    }

    public void testSimpleNodeFactoryToString() {
        LinkedStack queue = StackTools.linkedStack();
        Object factory = ObjectTools.get((Object)queue, (String)"nodeFactory");
        LinkedStackTests.assertEquals((String)"LinkedStack.SimpleNodeFactory", (String)factory.toString());
    }

    public void testCachingNodeFactoryToString() {
        LinkedStack queue = StackTools.linkedStack((int)20);
        Object factory = ObjectTools.get((Object)queue, (String)"nodeFactory");
        LinkedStackTests.assertTrue((boolean)factory.toString().startsWith("LinkedStack.CachingNodeFactory"));
        LinkedStackTests.assertTrue((boolean)factory.toString().endsWith("(0)"));
    }

    public void testClone_caching() throws Exception {
        LinkedStack original = StackTools.linkedStack((int)20);
        original.push((Object)"first");
        LinkedStack clone = original.clone();
        LinkedStackTests.assertEquals((String)((String)original.peek()), (String)((String)clone.peek()));
        LinkedStackTests.assertEquals((String)((String)original.pop()), (String)((String)clone.pop()));
        LinkedStackTests.assertNotSame((Object)original, (Object)clone);
        LinkedStackTests.assertTrue((boolean)original.isEmpty());
        LinkedStackTests.assertEquals((boolean)original.isEmpty(), (boolean)clone.isEmpty());
        original.push((Object)"second");
        LinkedStackTests.assertFalse((boolean)original.isEmpty());
        LinkedStackTests.assertTrue((boolean)clone.isEmpty());
        Object factory = ObjectTools.get((Object)original, (String)"nodeFactory");
        LinkedStackTests.assertTrue((boolean)factory.toString().startsWith("LinkedStack.CachingNodeFactory"));
    }
}

