/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.read;

import java.util.List;
import org.eclipse.jst.jsf.facesconfig.emf.ComponentType;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.IconType;
import org.eclipse.jst.jsf.facesconfig.emf.PropertyType;
import org.eclipse.jst.jsf.facesconfig.tests.read.BaseReadTestCase;
import org.eclipse.jst.jsf.facesconfig.tests.util.FacesConfigModelUtil;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class ReadPropertyComponentTestCase
extends BaseReadTestCase {
    public ReadPropertyComponentTestCase(String name) {
        super(name);
    }

    public void testProperty() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadPropertyComponentTestCase.assertNotNull((Object)edit.getFacesConfig());
            PropertyType attribute1 = this.getProperty1(edit.getFacesConfig());
            ReadPropertyComponentTestCase.assertNotNull((Object)attribute1);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    private ComponentType getComponent1(FacesConfigType facesConfigType) {
        return (ComponentType)FacesConfigModelUtil.findEObjectElementById((List)facesConfigType.getComponent(), "component1");
    }

    private PropertyType getProperty1(FacesConfigType facesConfigType) {
        ComponentType component1 = this.getComponent1(facesConfigType);
        ReadPropertyComponentTestCase.assertNotNull((Object)component1);
        return (PropertyType)FacesConfigModelUtil.findEObjectElementById((List)component1.getProperty(), "componentProperty1");
    }

    public void testDescription() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadPropertyComponentTestCase.assertNotNull((Object)edit.getFacesConfig());
            PropertyType propertyType = this.getProperty1(edit.getFacesConfig());
            ReadPropertyComponentTestCase.assertNotNull((Object)propertyType);
            DescriptionType descType = (DescriptionType)FacesConfigModelUtil.findEObjectElementById((List)propertyType.getDescription(), "componentProperty1_descripton1");
            ReadPropertyComponentTestCase.assertEquals((String)"myDescript blah blah", (String)descType.getTextContent().trim());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testDisplayName() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadPropertyComponentTestCase.assertNotNull((Object)edit.getFacesConfig());
            PropertyType propertyType = this.getProperty1(edit.getFacesConfig());
            ReadPropertyComponentTestCase.assertNotNull((Object)propertyType);
            DisplayNameType displayNameType = (DisplayNameType)FacesConfigModelUtil.findEObjectElementById((List)propertyType.getDisplayName(), "componentProperty1_displayName1");
            ReadPropertyComponentTestCase.assertEquals((String)"Component Property 1", (String)displayNameType.getTextContent().trim());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testIcon() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadPropertyComponentTestCase.assertNotNull((Object)edit.getFacesConfig());
            PropertyType propertyType = this.getProperty1(edit.getFacesConfig());
            ReadPropertyComponentTestCase.assertNotNull((Object)propertyType);
            IconType iconType = (IconType)FacesConfigModelUtil.findEObjectElementById((List)propertyType.getIcon(), "componentProperty1_icon1");
            ReadPropertyComponentTestCase.assertNotNull((Object)iconType);
            ReadPropertyComponentTestCase.assertEquals((String)"property-small-icon", (String)iconType.getSmallIcon().getTextContent());
            ReadPropertyComponentTestCase.assertEquals((String)"property-large-icon", (String)iconType.getLargeIcon().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testPropertyNameAndClass() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadPropertyComponentTestCase.assertNotNull((Object)edit.getFacesConfig());
            PropertyType property1 = this.getProperty1(edit.getFacesConfig());
            ReadPropertyComponentTestCase.assertNotNull((Object)property1);
            ReadPropertyComponentTestCase.assertEquals((String)"property1", (String)property1.getPropertyName().getTextContent());
            ReadPropertyComponentTestCase.assertEquals((String)"ComponentProperty", (String)property1.getPropertyClass().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testSuggestedValue() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadPropertyComponentTestCase.assertNotNull((Object)edit.getFacesConfig());
            PropertyType propertyType = this.getProperty1(edit.getFacesConfig());
            ReadPropertyComponentTestCase.assertNotNull((Object)propertyType);
            ReadPropertyComponentTestCase.assertEquals((String)"suggestedValue", (String)propertyType.getSuggestedValue().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testDefaultValue() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadPropertyComponentTestCase.assertNotNull((Object)edit.getFacesConfig());
            PropertyType propertyType = this.getProperty1(edit.getFacesConfig());
            ReadPropertyComponentTestCase.assertNotNull((Object)propertyType);
            ReadPropertyComponentTestCase.assertEquals((String)"defaultValue6", (String)propertyType.getDefaultValue().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }
}

