/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.test.util.mock;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import junit.framework.Assert;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsf.test.util.ZipStreamWrapper;
import org.eclipse.jst.jsf.test.util.mock.IMockResourceFactory;
import org.eclipse.jst.jsf.test.util.mock.IWorkspaceContext;
import org.eclipse.jst.jsf.test.util.mock.IWorkspaceContextWithEvents;
import org.eclipse.jst.jsf.test.util.mock.MockContainer;
import org.eclipse.jst.jsf.test.util.mock.MockFile;
import org.eclipse.jst.jsf.test.util.mock.MockFolder;
import org.eclipse.jst.jsf.test.util.mock.MockProject;
import org.eclipse.jst.jsf.test.util.mock.MockResource;
import org.eclipse.jst.jsf.test.util.mock.MockWorkspace;
import org.eclipse.jst.jsf.test.util.mock.MockWorkspaceRoot;
import org.osgi.framework.Bundle;

public class MockWorkspaceContext
implements IWorkspaceContextWithEvents {
    private final MockWorkspace _ws;
    private final Map<IPath, MockResource> _ownedResources;

    public MockWorkspaceContext(MockWorkspace ws) {
        this._ws = ws;
        this._ownedResources = new HashMap<IPath, MockResource>();
        ((MockWorkspaceRoot)ws.getRoot()).setContext(this);
    }

    public MockWorkspaceContext() {
        this(new MockWorkspace(new MockWorkspaceRoot()));
    }

    @Override
    public void fireWorkspaceEvent(IResourceChangeEvent event) {
        this._ws.fireResourceChangeEvent(event);
    }

    @Override
    public void init() throws Exception {
    }

    @Override
    public void dispose() throws Exception {
        for (Map.Entry<IPath, MockResource> entry : this._ownedResources.entrySet()) {
            entry.getValue().dispose();
        }
        this._ownedResources.clear();
        this._ws.dispose();
    }

    @Override
    public MockWorkspace getWorkspace() {
        return this._ws;
    }

    @Override
    public IResource getResource(IPath path) {
        return this._ownedResources.get(path);
    }

    @Override
    public IFile getFile(IPath path) {
        return (MockFile)this.getResource(path);
    }

    @Override
    public IProject getProject(IPath path) {
        return (MockProject)this._ownedResources.get(path);
    }

    private IProject createProject(IPath path, boolean replace) {
        MockProject project = new MockProject(path, new MyMockResourceFactoryFromZipFile());
        this.attachProject(project, replace);
        return project;
    }

    @Override
    public IProject createProject(String baseId) {
        int i = 0;
        while (this._ownedResources.get(this.generateName(baseId, i)) != null) {
            ++i;
        }
        return this.createProject((IPath)this.generateName(baseId, i), false);
    }

    private Path generateName(String baseId, int i) {
        return new Path(String.valueOf(baseId) + "_TestProject_" + i);
    }

    @Override
    public IProject createProject(IPath path) {
        return this.createProject(path, false);
    }

    private void attachProject(IProject project, boolean replace) {
        this.checkExists(project.getFullPath(), replace);
        ((MockProject)project).setWorkspace(this._ws);
        this._ownedResources.put(project.getFullPath(), (MockProject)project);
    }

    @Override
    public IProject loadProject(IPath path, IWorkspaceContext.ZipFileLoader zipFileLoader) throws Exception {
        this.checkExists(path, false);
        MockProject project = new MockProject(path, new MyMockResourceFactoryFromZipFile(zipFileLoader.getZipFile(), zipFileLoader.getPathInZip()));
        this.attachProject(project, false);
        return project;
    }

    @Override
    public IProject loadProject(IPath path, Bundle bundle, String pathIntoZip) throws Exception {
        this.checkExists(path, false);
        MockProject project = new MockProject(path, new MyMockResourceFactoryFromBundle(bundle, pathIntoZip));
        this.attachProject(project, false);
        return project;
    }

    @Override
    public MockFile attachFile(IProject project, IPath projectRelativePath, File file) {
        Assert.assertEquals((Object)this.checkExists(project.getFullPath(), true), (Object)project);
        this.checkExists(project.getFullPath().append(projectRelativePath), false);
        Assert.assertTrue((boolean)file.exists());
        MockFile iFile = (MockFile)project.getFile(projectRelativePath);
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(file);
            iFile.setContents(inStream, 0, null);
            MockFile mockFile = iFile;
            return mockFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (inStream != null) {
                try {
                    ((InputStream)inStream).close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private MockResource checkExists(IPath path, boolean replace) {
        MockResource resource = this._ownedResources.get(path);
        if (resource != null && !replace) {
            throw new IllegalArgumentException(String.valueOf(path.toString()) + " already exists");
        }
        return resource;
    }

    @Override
    public List<IResourceChangeListener> getListeners() {
        return this.getWorkspace().getListeners();
    }

    @Override
    public List<IResourceChangeListener> getListeners(List<Class<? extends IResourceChangeListener>> includeListeners) {
        ArrayList<IResourceChangeListener> listeners = new ArrayList<IResourceChangeListener>();
        block0: for (IResourceChangeListener listener : this.getListeners()) {
            for (Class<? extends IResourceChangeListener> clazz : includeListeners) {
                if (!clazz.isAssignableFrom(listener.getClass())) continue;
                listeners.add(listener);
                continue block0;
            }
        }
        return listeners;
    }

    @Override
    public void ensureAllMembers(IProject project) throws Exception {
        ((MockProject)project).loadAllMembers();
    }

    private abstract class AbstractMockResourceFactory
    implements IMockResourceFactory {
        private AbstractMockResourceFactory() {
        }

        @Override
        public MockFolder createFolder(MockContainer container, IPath path) {
            IPath newFileFullPath = container.getFullPath().append(path);
            MockResource resource = MockWorkspaceContext.this.checkExists(newFileFullPath, true);
            if (resource == null) {
                resource = this.newFolder(container, newFileFullPath);
                this.ensurePathToNewResource(container, path);
            }
            return (MockFolder)resource;
        }

        protected void ensurePathToNewResource(MockContainer container, IPath path) {
            IPath leadingPath = path.removeLastSegments(1);
            IPath curPath = container.getFullPath();
            while (leadingPath.segmentCount() > 0) {
                String nextSegment = leadingPath.segments()[0];
                curPath = curPath.append(nextSegment);
                leadingPath = leadingPath.removeFirstSegments(1);
                MockResource newContainer = MockWorkspaceContext.this.checkExists(curPath, true);
                if (newContainer != null) continue;
                this.newFolder(container, curPath);
            }
        }

        protected MockResource newFolder(MockContainer container, IPath curPath) {
            MockFolder newContainer = new MockFolder(curPath, this);
            newContainer.setWorkspace(MockWorkspaceContext.this._ws);
            newContainer.setProject(container.getProject());
            MockWorkspaceContext.this._ownedResources.put(curPath, newContainer);
            return newContainer;
        }

        @Override
        public List<MockResource> getCurrentMembers(MockContainer container) {
            ArrayList<MockResource> members = new ArrayList<MockResource>();
            IPath containerPath = container.getFullPath();
            for (IPath path : MockWorkspaceContext.this._ownedResources.keySet()) {
                if (!containerPath.isPrefixOf(path) || path.segmentCount() != containerPath.segmentCount() + 1) continue;
                members.add(MockWorkspaceContext.this._ownedResources.get(path));
            }
            return members;
        }

        @Override
        public MockFile createFile(MockContainer container, IPath path) throws Exception {
            return this.createFile(container, path, null);
        }

        protected MockFile createFile(MockContainer container, IPath path, InputStream contents) throws Exception {
            IPath newFileFullPath = container.getFullPath().append(path);
            MockResource resource = MockWorkspaceContext.this.checkExists(newFileFullPath, true);
            if (resource == null) {
                resource = new MockFile(newFileFullPath);
                resource.setWorkspace(MockWorkspaceContext.this.getWorkspace());
                resource.setProject(container.getProject());
                if (contents != null) {
                    ((MockFile)resource).setContents(contents, false, true, (IProgressMonitor)new NullProgressMonitor());
                } else {
                    this.setContents((MockFile)resource, path);
                }
                this.ensurePathToNewResource(container, path);
                MockWorkspaceContext.this._ownedResources.put(newFileFullPath, resource);
            }
            return (MockFile)resource;
        }

        protected abstract void setContents(MockFile var1, IPath var2) throws Exception;
    }

    private class MyMockResourceFactoryFromBundle
    extends AbstractMockResourceFactory {
        private final URL _zipURL;
        private final String _pathIntoZip;

        public MyMockResourceFactoryFromBundle(Bundle bundle, String pathIntoZip) {
            this._zipURL = FileLocator.find((Bundle)bundle, (IPath)new Path(pathIntoZip), null);
            Assert.assertNotNull((Object)this._zipURL);
            this._pathIntoZip = this.getPrefix();
        }

        @Override
        public void dispose() throws Exception {
        }

        /*
         * Exception decompiling
         */
        private String getPrefix() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 13[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        @Override
        protected void setContents(MockFile file, IPath path) throws Exception {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 9[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public void forceLoad(MockProject project) throws Exception {
            ZipInputStream zis = null;
            try {
                zis = new ZipInputStream(this._zipURL.openStream());
                ZipEntry entry = zis.getNextEntry();
                while (entry != null) {
                    String name = entry.getName();
                    int removeIdx = name.indexOf(this._pathIntoZip);
                    if (removeIdx > -1) {
                        name = name.substring(this._pathIntoZip.length());
                        if (entry.isDirectory()) {
                            if (name.endsWith("/")) {
                                name = name.substring(0, name.length() - 1);
                            }
                            if (name.length() > 0) {
                                this.createFolder(project, (IPath)new Path(name));
                            }
                        } else {
                            this.createFile(project, (IPath)new Path(name), new ZipStreamWrapper(zis));
                        }
                    }
                    entry = zis.getNextEntry();
                }
            }
            catch (Throwable throwable) {
                try {
                    if (zis != null) {
                        zis.close();
                    }
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                if (zis != null) {
                    zis.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private class MyMockResourceFactoryFromZipFile
    extends AbstractMockResourceFactory {
        private final ZipFile _zip;
        private final String _pathIntoZip;

        public MyMockResourceFactoryFromZipFile() {
            this._zip = null;
            this._pathIntoZip = "";
        }

        public MyMockResourceFactoryFromZipFile(ZipFile zip, String pathIntoZip) {
            this._zip = zip;
            this._pathIntoZip = pathIntoZip;
        }

        @Override
        public void dispose() throws Exception {
            if (this._zip != null) {
                this._zip.close();
            }
        }

        @Override
        protected void setContents(MockFile file, IPath path) throws Exception {
            InputStream inputStream;
            ZipEntry entry;
            if (this._zip != null && (entry = this._zip.getEntry(String.valueOf(this._pathIntoZip) + path.toString())) != null && (inputStream = this._zip.getInputStream(entry)) != null) {
                file.setContents(inputStream, false, true, (IProgressMonitor)new NullProgressMonitor());
            }
        }

        @Override
        public void forceLoad(MockProject project) throws Exception {
            Enumeration<? extends ZipEntry> entries = this._zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                int removeIdx = name.indexOf(this._pathIntoZip);
                if (removeIdx <= -1) continue;
                name = name.substring(this._pathIntoZip.length());
                if (entry.isDirectory()) {
                    if (name.endsWith("/")) {
                        name = name.substring(0, name.length() - 1);
                    }
                    if (name.length() <= 0) continue;
                    this.createFolder(project, (IPath)new Path(name));
                    continue;
                }
                this.createFile(project, (IPath)new Path(name));
            }
        }
    }
}

