/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.java;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaContextModel;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkChangeTracking;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkChangeTrackingType;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.ChangeTrackingAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.ChangeTrackingType;

public class EclipseLinkJavaChangeTracking
extends AbstractJavaContextModel<JavaTypeMapping>
implements EclipseLinkChangeTracking {
    protected EclipseLinkChangeTrackingType specifiedType = this.buildSpecifiedType();

    public EclipseLinkJavaChangeTracking(JavaTypeMapping parent) {
        super((JpaContextModel)parent);
    }

    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        this.setSpecifiedType_(this.buildSpecifiedType());
    }

    @Override
    public EclipseLinkChangeTrackingType getType() {
        return this.specifiedType != null ? this.specifiedType : this.getDefaultType();
    }

    @Override
    public EclipseLinkChangeTrackingType getSpecifiedType() {
        return this.specifiedType;
    }

    @Override
    public void setSpecifiedType(EclipseLinkChangeTrackingType type) {
        if (ObjectTools.notEquals((Object)((Object)type), (Object)((Object)this.specifiedType))) {
            ChangeTrackingAnnotation annotation = this.getChangeTrackingAnnotation();
            if (type == null) {
                if (annotation != null) {
                    this.removeChangeTrackingAnnotation();
                }
            } else {
                if (annotation == null) {
                    annotation = this.addChangeTrackingAnnotation();
                }
                annotation.setValue(EclipseLinkChangeTrackingType.toJavaResourceModel(type));
            }
            this.setSpecifiedType_(type);
        }
    }

    protected void setSpecifiedType_(EclipseLinkChangeTrackingType type) {
        EclipseLinkChangeTrackingType old = this.specifiedType;
        this.specifiedType = type;
        this.firePropertyChanged("specifiedType", (Object)old, (Object)type);
    }

    protected EclipseLinkChangeTrackingType buildSpecifiedType() {
        ChangeTrackingAnnotation annotation = this.getChangeTrackingAnnotation();
        if (annotation == null) {
            return null;
        }
        ChangeTrackingType value = annotation.getValue();
        return value == null ? DEFAULT_TYPE : EclipseLinkChangeTrackingType.fromJavaResourceModel(value);
    }

    @Override
    public EclipseLinkChangeTrackingType getDefaultType() {
        return DEFAULT_TYPE;
    }

    protected ChangeTrackingAnnotation getChangeTrackingAnnotation() {
        return (ChangeTrackingAnnotation)this.getJavaResourceType().getAnnotation(this.getChangeTrackingAnnotationName());
    }

    protected ChangeTrackingAnnotation addChangeTrackingAnnotation() {
        return (ChangeTrackingAnnotation)this.getJavaResourceType().addAnnotation(this.getChangeTrackingAnnotationName());
    }

    protected void removeChangeTrackingAnnotation() {
        this.getJavaResourceType().removeAnnotation(this.getChangeTrackingAnnotationName());
    }

    protected String getChangeTrackingAnnotationName() {
        return "org.eclipse.persistence.annotations.ChangeTracking";
    }

    protected JavaTypeMapping getTypeMapping() {
        return (JavaTypeMapping)this.parent;
    }

    protected JavaPersistentType getPersistentType() {
        return this.getTypeMapping().getPersistentType();
    }

    protected JavaResourceType getJavaResourceType() {
        return this.getPersistentType().getJavaResourceType();
    }

    public TextRange getValidationTextRange() {
        TextRange textRange = this.getAnnotationTextRange();
        return textRange != null ? textRange : this.getTypeMapping().getValidationTextRange();
    }

    protected TextRange getAnnotationTextRange() {
        ChangeTrackingAnnotation annotation = this.getChangeTrackingAnnotation();
        return annotation == null ? null : annotation.getTextRange();
    }
}

