/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.ide;

import org.eclipse.core.runtime.Status;
import org.eclipse.jem.internal.proxy.common.IVMServer;
import org.eclipse.jem.internal.proxy.core.IArrayBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IBooleanBeanProxy;
import org.eclipse.jem.internal.proxy.core.ICharacterBeanProxy;
import org.eclipse.jem.internal.proxy.core.IExpression;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jem.internal.proxy.core.INumberBeanProxy;
import org.eclipse.jem.internal.proxy.core.IStandardBeanProxyFactory;
import org.eclipse.jem.internal.proxy.core.IStringBeanProxy;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.ide.IDEArrayBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEExpression;
import org.eclipse.jem.internal.proxy.ide.IDENumberBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.ide.IDEStandardBeanTypeProxyFactory;
import org.eclipse.jem.internal.proxy.ide.IIDEBeanProxy;
import org.eclipse.jem.internal.proxy.initParser.InitializationStringParser;

public class IDEStandardBeanProxyFactory
implements IStandardBeanProxyFactory {
    protected IDEProxyFactoryRegistry fRegistry;
    protected IDEStandardBeanTypeProxyFactory fBeanTypeProxyFactory;
    private IBeanProxy ivmServerProxy;

    static IIDEBeanProxy createBeanProxy(ProxyFactoryRegistry aRegistry, Object anObject) {
        return ((IDEStandardBeanProxyFactory)aRegistry.getBeanProxyFactory()).createIDEBeanProxyWith(anObject);
    }

    IDEStandardBeanProxyFactory(IDEProxyFactoryRegistry aRegistry) {
        this.fRegistry = aRegistry;
        this.fRegistry.registerBeanProxyFactory(this);
        this.fBeanTypeProxyFactory = (IDEStandardBeanTypeProxyFactory)aRegistry.getBeanTypeProxyFactory();
        this.ivmServerProxy = this.fRegistry.getBeanProxy(IVMServer.class, this.fRegistry);
    }

    @Override
    public IStringBeanProxy createBeanProxyWith(String aString) {
        return this.fBeanTypeProxyFactory.stringClass.createStringBeanProxy(aString);
    }

    @Override
    public INumberBeanProxy createBeanProxyWith(float aFloat) {
        return this.fBeanTypeProxyFactory.floatType.createFloatBeanProxy(aFloat);
    }

    @Override
    public INumberBeanProxy createBeanProxyWith(short aShort) {
        return this.fBeanTypeProxyFactory.shortType.createShortBeanProxy(aShort);
    }

    @Override
    public ICharacterBeanProxy createBeanProxyWith(char aChar) {
        return this.fBeanTypeProxyFactory.charType.createCharBeanProxy(aChar);
    }

    @Override
    public ICharacterBeanProxy createBeanProxyWith(Character aCharacter) {
        return this.fBeanTypeProxyFactory.charClass.createCharacterBeanProxy(aCharacter);
    }

    @Override
    public IIntegerBeanProxy createBeanProxyWith(int anInt) {
        return this.fBeanTypeProxyFactory.intType.createIntegerBeanProxy(anInt);
    }

    @Override
    public IIntegerBeanProxy createBeanProxyWith(Integer anInteger) {
        return this.fBeanTypeProxyFactory.integerClass.createIntegerBeanProxy(anInteger);
    }

    @Override
    public INumberBeanProxy createBeanProxyWith(long aLong) {
        return this.fBeanTypeProxyFactory.longType.createLongBeanProxy(aLong);
    }

    @Override
    public INumberBeanProxy createBeanProxyWith(Number aNumber) {
        IDENumberBeanTypeProxy numberTypeProxy = (IDENumberBeanTypeProxy)this.fBeanTypeProxyFactory.getBeanTypeProxy(aNumber.getClass());
        return numberTypeProxy.createNumberBeanProxy(aNumber);
    }

    @Override
    public IBooleanBeanProxy createBeanProxyWith(boolean aBoolean) {
        return this.fBeanTypeProxyFactory.booleanType.createBooleanBeanProxy(aBoolean);
    }

    @Override
    public IBooleanBeanProxy createBeanProxyWith(Boolean aBoolean) {
        return this.fBeanTypeProxyFactory.booleanClass.createBooleanBeanProxy(aBoolean);
    }

    @Override
    public INumberBeanProxy createBeanProxyWith(byte aByte) {
        return this.fBeanTypeProxyFactory.byteType.createByteBeanProxy(aByte);
    }

    @Override
    public INumberBeanProxy createBeanProxyWith(double aDouble) {
        return this.fBeanTypeProxyFactory.doubleType.createDoubleBeanProxy(aDouble);
    }

    @Override
    public IBeanProxy convertToPrimitiveBeanProxy(IBeanProxy nonPrimitiveProxy) {
        if (nonPrimitiveProxy == null) {
            return null;
        }
        if (!nonPrimitiveProxy.isValid()) {
            return nonPrimitiveProxy;
        }
        IDEBeanTypeProxy type = (IDEBeanTypeProxy)nonPrimitiveProxy.getTypeProxy();
        if (Boolean.class.equals(type.getClass())) {
            return this.createBeanProxyWith(((IBooleanBeanProxy)nonPrimitiveProxy).booleanValue());
        }
        if (Byte.class.equals(type.getClass())) {
            return this.createBeanProxyWith(((INumberBeanProxy)nonPrimitiveProxy).byteValue());
        }
        if (Character.class.equals(type.getClass())) {
            return this.createBeanProxyWith(((ICharacterBeanProxy)nonPrimitiveProxy).charValue());
        }
        if (Double.class.equals(type.getClass())) {
            return this.createBeanProxyWith(((INumberBeanProxy)nonPrimitiveProxy).doubleValue());
        }
        if (Float.class.equals(type.getClass())) {
            return this.createBeanProxyWith(((INumberBeanProxy)nonPrimitiveProxy).floatValue());
        }
        if (Integer.class.equals(type.getClass())) {
            return this.createBeanProxyWith(((INumberBeanProxy)nonPrimitiveProxy).intValue());
        }
        if (Long.class.equals(type.getClass())) {
            return this.createBeanProxyWith(((INumberBeanProxy)nonPrimitiveProxy).longValue());
        }
        if (Short.class.equals(type.getClass())) {
            return this.createBeanProxyWith(((INumberBeanProxy)nonPrimitiveProxy).shortValue());
        }
        return nonPrimitiveProxy;
    }

    @Override
    public IArrayBeanProxy createBeanProxyWith(IBeanTypeProxy type, int dimension) throws ThrowableProxy {
        return this.createBeanProxyWith(type, new int[]{dimension});
    }

    @Override
    public IArrayBeanProxy createBeanProxyWith(IBeanTypeProxy type, int[] dimensions) throws ThrowableProxy {
        if (type.isArray()) {
            return ((IDEArrayBeanTypeProxy)type).createBeanProxyWith(dimensions);
        }
        IDEArrayBeanTypeProxy arrayType = (IDEArrayBeanTypeProxy)this.fBeanTypeProxyFactory.getBeanTypeProxy(type.getTypeName(), dimensions.length);
        return arrayType.createBeanProxyWith(dimensions);
    }

    @Override
    public void releaseProxy(IBeanProxy aProxy) {
    }

    public IIDEBeanProxy createIDEBeanProxyWith(Object anObject) {
        if (anObject == null) {
            return null;
        }
        return ((IDEBeanTypeProxy)this.fBeanTypeProxyFactory.getBeanTypeProxy(anObject.getClass())).newBeanProxy(anObject);
    }

    IBeanProxy createBeanProxy(IDEBeanTypeProxy aTypeProxy, String initializationString) {
        if (initializationString.equals("null")) {
            return null;
        }
        try {
            ClassLoader pluginClassLoader = this.fRegistry.getPluginClassLoader();
            Object newValue = InitializationStringParser.evaluate(initializationString, pluginClassLoader);
            return newValue != null ? aTypeProxy.newBeanProxy(newValue) : null;
        }
        catch (Exception exc) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)exc));
            return null;
        }
    }

    IBeanProxy createBeanProxy(IDEBeanTypeProxy aTypeProxy) {
        Class beanType = aTypeProxy.fClass;
        try {
            return aTypeProxy.newBeanProxy(!aTypeProxy.isPrimitive() ? beanType.newInstance() : null);
        }
        catch (Exception exc) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)exc));
            return null;
        }
    }

    @Override
    public void terminateFactory(boolean wait) {
    }

    @Override
    public IExpression createExpression() {
        return new IDEExpression(this.fRegistry);
    }

    @Override
    public IBeanProxy createBeanProxyFrom(String initializationString) throws ThrowableProxy {
        if (initializationString.equals("null")) {
            return null;
        }
        try {
            ClassLoader pluginClassLoader = this.fRegistry.getPluginClassLoader();
            InitializationStringParser parser = InitializationStringParser.createParser(initializationString, pluginClassLoader);
            Object newValue = parser.evaluate();
            if (newValue != null) {
                return this.fRegistry.getBeanProxy(parser.getExpectedType(), newValue);
            }
            return null;
        }
        catch (Exception exc) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)exc));
            return null;
        }
    }

    @Override
    public IBeanProxy getIVMServerProxy() {
        return this.ivmServerProxy;
    }
}

