/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IBooleanBeanProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.IStringBeanProxy;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.remote.IREMBeanProxy;
import org.eclipse.jem.internal.proxy.remote.IREMConstantBeanProxy;
import org.eclipse.jem.internal.proxy.remote.ProxyRemoteMessages;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanProxyConstants;

public class REMThrowableBeanProxy
extends ThrowableProxy
implements IREMBeanProxy {
    private static final long serialVersionUID = 2076777336810215206L;
    private Integer fID;
    protected final REMProxyFactoryRegistry fFactory;
    private IBeanTypeProxy fTypeProxy;

    protected REMThrowableBeanProxy(REMProxyFactoryRegistry aRegistry, Integer anID, IBeanTypeProxy aType) {
        this.fFactory = aRegistry;
        this.fID = anID;
        this.fTypeProxy = aType;
    }

    @Override
    public boolean equals(Object anObject) {
        if (super.equals(anObject)) {
            return true;
        }
        if (anObject instanceof IBeanProxy && !(anObject instanceof IREMConstantBeanProxy) && this.fFactory.isValid() && ((IBeanProxy)anObject).getProxyFactoryRegistry() == this.fFactory) {
            try {
                return ((IBooleanBeanProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getObjectEquals().invoke((IBeanProxy)this, (IBeanProxy)anObject)).booleanValue();
            }
            catch (ThrowableProxy throwableProxy) {}
        }
        return false;
    }

    @Override
    public boolean sameAs(IBeanProxy aBeanProxy) {
        return this == aBeanProxy;
    }

    @Override
    public Integer getID() {
        return this.fID;
    }

    @Override
    public boolean isValid() {
        return this.fID != null;
    }

    @Override
    public void release() {
        this.fID = null;
        this.fTypeProxy = null;
    }

    @Override
    public ProxyFactoryRegistry getProxyFactoryRegistry() {
        return this.fFactory;
    }

    @Override
    public IBeanTypeProxy getTypeProxy() {
        return this.fTypeProxy;
    }

    @Override
    public String toBeanString() {
        IStringBeanProxy string = (IStringBeanProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getObjectToString().invokeCatchThrowableExceptions(this);
        return string != null ? string.stringValue() : null;
    }

    @Override
    public String getProxyLocalizedMessage() {
        IStringBeanProxy msg = (IStringBeanProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getThrowableLocalizedMessage().invokeCatchThrowableExceptions(this);
        return msg != null ? msg.stringValue() : null;
    }

    @Override
    public String getProxyMessage() {
        IStringBeanProxy msg = (IStringBeanProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getThrowableMessage().invokeCatchThrowableExceptions(this);
        return msg != null ? msg.stringValue() : null;
    }

    private String getProxyStackTrace() {
        IMethodProxy tempGetStackTrace = this.fFactory.getMethodProxyFactory().getMethodProxy("org.eclipse.jem.internal.proxy.vm.remote.StackTraceUtility", "printStackTrace", new String[]{"java.lang.Throwable"});
        IStringBeanProxy trace = (IStringBeanProxy)tempGetStackTrace.invokeCatchThrowableExceptions(null, this);
        return trace != null ? trace.stringValue() : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printProxyStackTrace(PrintWriter writer) {
        String trace = this.getProxyStackTrace();
        PrintWriter printWriter = writer;
        synchronized (printWriter) {
            writer.print(trace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printProxyStackTrace(PrintStream stream) {
        String trace = this.getProxyStackTrace();
        PrintStream printStream = stream;
        synchronized (printStream) {
            stream.print(trace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printProxyStackTrace() {
        String trace = this.getProxyStackTrace();
        PrintStream printStream = System.err;
        synchronized (printStream) {
            System.err.print(trace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace() {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            System.err.println(ProxyRemoteMessages.REMOTE_VM_TRACE_INFO_);
            this.printProxyStackTrace();
            System.err.println(ProxyRemoteMessages.REMOTE_VM_LOCAL_TRACE_INFO_);
            super.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter s) {
        PrintWriter printWriter = s;
        synchronized (printWriter) {
            s.println(ProxyRemoteMessages.REMOTE_VM_TRACE_INFO_);
            this.printProxyStackTrace(s);
            s.println(ProxyRemoteMessages.REMOTE_VM_LOCAL_TRACE_INFO_);
            super.printStackTrace(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            s.println(ProxyRemoteMessages.REMOTE_VM_TRACE_INFO_);
            this.printProxyStackTrace(s);
            s.println(ProxyRemoteMessages.REMOTE_VM_LOCAL_TRACE_INFO_);
            super.printStackTrace(s);
        }
    }

    @Override
    public void renderBean(Commands.ValueObject value) {
        value.setObjectID(this.getID());
    }

    @Override
    public final boolean isBeanProxy() {
        return true;
    }

    @Override
    public final boolean isExpressionProxy() {
        return false;
    }
}

