/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.html.core.tests.HTMLCoreTestsPlugin;

public class ProjectUtil {
    public static IProject createProject(String name, IPath location, String[] natureIds) {
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(name);
        if (location != null) {
            description.setLocation(location);
        }
        if (natureIds != null) {
            description.setNatureIds(natureIds);
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        try {
            project.create(description, (IProgressMonitor)new NullProgressMonitor());
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return project;
    }

    public static void copyBundleEntriesIntoWorkspace(final String rootEntry, final String fullTargetPath) {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ProjectUtil._copyBundleEntriesIntoWorkspace(rootEntry, fullTargetPath);
                ResourcesPlugin.getWorkspace().checkpoint(true);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    static void _copyBundleEntriesIntoWorkspace(String rootEntry, String fullTargetPath) throws CoreException {
        Enumeration entries = HTMLCoreTestsPlugin.getDefault().getBundle().getEntryPaths(rootEntry);
        while (entries != null && entries.hasMoreElements()) {
            String entryPath = entries.nextElement().toString();
            String targetPath = new Path(String.valueOf(fullTargetPath) + "/" + entryPath.substring(rootEntry.length())).toString();
            if (entryPath.endsWith("/")) {
                IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(targetPath));
                if (!folder.exists()) {
                    folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
                ProjectUtil._copyBundleEntriesIntoWorkspace(entryPath, targetPath);
                continue;
            }
            ProjectUtil._copyBundleEntryIntoWorkspace(entryPath, targetPath);
        }
    }

    static IFile _copyBundleEntryIntoWorkspace(String entryname, String fullPath) throws CoreException {
        IFile file = null;
        URL entry = HTMLCoreTestsPlugin.getDefault().getBundle().getEntry(entryname);
        if (entry != null) {
            try {
                byte[] b = new byte[2048];
                InputStream input = entry.openStream();
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                int i = -1;
                while ((i = input.read(b)) > -1) {
                    output.write(b, 0, i);
                }
                file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fullPath));
                if (file != null) {
                    if (!file.exists()) {
                        file.create((InputStream)new ByteArrayInputStream(output.toByteArray()), true, (IProgressMonitor)new NullProgressMonitor());
                    } else {
                        file.setContents((InputStream)new ByteArrayInputStream(output.toByteArray()), true, false, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return file;
    }
}

