/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.persistence.serializer;

import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebMethod;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.JaxWsWorkspaceResource;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.serializer.AbstractSerializerAdapter;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationFactory;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotation;
import org.eclipse.jst.ws.jaxws.utils.annotations.IParamValuePair;

public class MethodSerializerAdapter
extends AbstractSerializerAdapter {
    public MethodSerializerAdapter(JaxWsWorkspaceResource resource) {
        super(resource);
    }

    @Override
    protected boolean isAnnotationRequired() {
        return false;
    }

    @Override
    protected IAnnotation<? extends IJavaElement> getAnnotation() throws JavaModelException {
        assert (this.getTarget() instanceof IWebMethod);
        IWebMethod webMethod = (IWebMethod)this.getTarget();
        IServiceEndpointInterface sei = (IServiceEndpointInterface)webMethod.eContainer();
        if (sei == null) {
            return null;
        }
        IType seiType = this.findType(sei, sei.getImplementation());
        IMethod method = this.util().findMethod(seiType, webMethod);
        if (method == null) {
            throw new IllegalStateException("IMethod for DOM method was not found");
        }
        return AnnotationFactory.createAnnotation((String)"javax.jws.WebMethod", (IJavaElement)method, this.defineParamValues(webMethod, method));
    }

    private Set<IParamValuePair> defineParamValues(IWebMethod webMethod, IMethod method) {
        TreeSet<IParamValuePair> paramValuePairs = this.createParamValueSortedTreeSet();
        if (webMethod.getName() != null && !webMethod.getName().equals(method.getElementName())) {
            paramValuePairs.add(this.createParamValue("operationName", webMethod.getName()));
        }
        if (webMethod.isExcluded()) {
            paramValuePairs.add(this.createParamValue("exclude", true));
        }
        return paramValuePairs;
    }

    @Override
    protected boolean checkValue(Notification msg) {
        EStructuralFeature feature = (EStructuralFeature)msg.getFeature();
        if (feature.getFeatureID() != 1) {
            return false;
        }
        return super.checkValue(msg);
    }
}

