/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.tests.document;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import junit.framework.TestCase;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.IModelHandler;
import org.eclipse.wst.sse.core.internal.modelhandler.ModelHandlerRegistry;
import org.eclipse.wst.sse.core.internal.provisional.IModelLoader;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.events.AboutToBeChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.IModelAboutToBeChangedListener;
import org.eclipse.wst.sse.core.internal.provisional.events.IStructuredDocumentListener;
import org.eclipse.wst.sse.core.internal.provisional.events.NewDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.NoChangeEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentRegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class TestCompatibility
extends TestCase {
    public TestCompatibility() {
    }

    public TestCompatibility(String name) {
        super(name);
    }

    private String loadStringFromResource(String name) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream(name);){
                int charsRead;
                InputStreamReader inputStreamReader = new InputStreamReader(stream, "utf8");
                StringBuilder builder = new StringBuilder();
                char[] chars = new char[1024];
                while ((charsRead = inputStreamReader.read(chars)) != -1) {
                    builder.append(chars, 0, charsRead);
                }
                String s = builder.toString();
                s = s.replaceAll("\r\n", "\n");
                return s = s.replaceAll("\r", "\n");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return "Unable to read resource " + String.valueOf(e);
        }
    }

    private void testImplementation(IStructuredDocument document, String referenceResourceName) throws BadLocationException {
        final StringBuilder testBuffer = new StringBuilder();
        document.addDocumentAboutToChangeListener(new IModelAboutToBeChangedListener(){

            public void modelAboutToBeChanged(AboutToBeChangedEvent e) {
                testBuffer.append("BEGIN DocumentAboutToChange\n");
                testBuffer.append(e);
                testBuffer.append("\n");
                testBuffer.append("END DocumentAboutToChange\n");
            }
        });
        document.addDocumentChangingListener(new IStructuredDocumentListener(){

            private void append(StructuredDocumentEvent e) {
                testBuffer.append("BEGIN DocumentChanging\n");
                testBuffer.append(e);
                testBuffer.append("\n");
                testBuffer.append("END   DocumentChanging\n");
            }

            public void regionsReplaced(RegionsReplacedEvent structuredDocumentEvent) {
                this.append((StructuredDocumentEvent)structuredDocumentEvent);
            }

            public void regionChanged(RegionChangedEvent structuredDocumentEvent) {
                this.append((StructuredDocumentEvent)structuredDocumentEvent);
            }

            public void nodesReplaced(StructuredDocumentRegionsReplacedEvent structuredDocumentEvent) {
                this.append((StructuredDocumentEvent)structuredDocumentEvent);
            }

            public void noChange(NoChangeEvent structuredDocumentEvent) {
                this.append((StructuredDocumentEvent)structuredDocumentEvent);
            }

            public void newModel(NewDocumentEvent structuredDocumentEvent) {
                this.append((StructuredDocumentEvent)structuredDocumentEvent);
            }
        });
        document.addDocumentChangedListener(new IStructuredDocumentListener(){

            private void append(StructuredDocumentEvent e) {
                testBuffer.append("BEGIN DocumentChanged\n");
                testBuffer.append(e);
                testBuffer.append("\n");
                testBuffer.append("END   DocumentChanged\n");
            }

            public void regionsReplaced(RegionsReplacedEvent structuredDocumentEvent) {
                this.append((StructuredDocumentEvent)structuredDocumentEvent);
            }

            public void regionChanged(RegionChangedEvent structuredDocumentEvent) {
                this.append((StructuredDocumentEvent)structuredDocumentEvent);
            }

            public void nodesReplaced(StructuredDocumentRegionsReplacedEvent structuredDocumentEvent) {
                this.append((StructuredDocumentEvent)structuredDocumentEvent);
            }

            public void noChange(NoChangeEvent structuredDocumentEvent) {
                this.append((StructuredDocumentEvent)structuredDocumentEvent);
            }

            public void newModel(NewDocumentEvent structuredDocumentEvent) {
                this.append((StructuredDocumentEvent)structuredDocumentEvent);
            }
        });
        document.addPrenotifiedDocumentListener(new IDocumentListener(){

            private void append(DocumentEvent e) {
                testBuffer.append("BEGIN PrenotifiedDocumentListener\n");
                testBuffer.append(e);
                testBuffer.append("\n");
                testBuffer.append("END   PrenotifiedDocumentListener\n");
            }

            public void documentChanged(DocumentEvent event) {
                this.append(event);
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
                this.append(event);
            }
        });
        document.addDocumentListener(new IDocumentListener(){

            private void append(DocumentEvent e) {
                testBuffer.append("BEGIN DocumentListener\n");
                testBuffer.append(e);
                testBuffer.append("\n");
                testBuffer.append("END   DocumentListener\n");
            }

            public void documentChanged(DocumentEvent event) {
                this.append(event);
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
                this.append(event);
            }
        });
        testBuffer.append("BEGIN Setting Content\n");
        document.set("<?xml version=\"1.0\" encoding=\"UTF-8\"?><rss xmlns:itunes=\"http://www.itunes.com/dtds/podcast-1.0.dtd\" version=\"2.0\">");
        testBuffer.append("END   Setting Content\n");
        int i = document.get().indexOf("<rss");
        testBuffer.append("BEGIN Change Content\n");
        document.replace(i, 0, "\n");
        testBuffer.append("END   Change Content\n");
        i = document.get().indexOf("<rss ");
        testBuffer.append("BEGIN NoChangeContent\n");
        document.replace(i + 4, 1, " ");
        testBuffer.append("END   NoChangeContent\n");
        testBuffer.append("BEGIN Append\n");
        document.replace(document.getLength() - 1, 0, "\n</rss>");
        testBuffer.append("END   Append\n");
        TestCompatibility.assertEquals((String)this.loadStringFromResource(referenceResourceName).trim(), (String)testBuffer.toString().trim());
    }

    public void testBasicEventOrdering() throws BadLocationException {
        IModelHandler modelHandler = ModelHandlerRegistry.getInstance().getHandlerForContentTypeId("org.eclipse.core.runtime.xml");
        IModelLoader modelLoader = modelHandler.getModelLoader();
        IStructuredModel model = modelLoader.createModel();
        IStructuredDocument document = model.getStructuredDocument();
        this.testImplementation(document, "BasicEventOrdering1.txt");
    }
}

