/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.java;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.core.internal.utility.ContentTypeTools;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourcePackageFragmentRoot;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateAdapter;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.java.JarFile;
import org.eclipse.jpt.jpa.core.context.java.JavaManagedType;
import org.eclipse.jpt.jpa.core.context.java.JavaManagedTypeDefinition;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.persistence.JarFileRef;
import org.eclipse.jpt.jpa.core.internal.context.AbstractJpaContextModel;
import org.eclipse.jpt.jpa.core.internal.context.java.JavaPersistentTypeDefinition;
import org.eclipse.jpt.jpa.core.internal.context.persistence.AbstractPersistenceXmlContextModel;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public class GenericJarFile
extends AbstractPersistenceXmlContextModel<JarFileRef>
implements JarFile,
JavaPersistentType.Parent {
    protected final JavaResourcePackageFragmentRoot jarResourcePackageFragmentRoot;
    protected final AbstractJpaContextModel.ContextCollectionContainer<JavaManagedType, JavaResourceType> javaManagedTypeContainer;
    protected static final Predicate<JavaManagedType> TYPE_IS_PERSISTENT_TYPE = new TypeIsPersistentType();

    public GenericJarFile(JarFileRef parent, JavaResourcePackageFragmentRoot jarResourcePackageFragmentRoot) {
        super(parent);
        this.jarResourcePackageFragmentRoot = jarResourcePackageFragmentRoot;
        this.javaManagedTypeContainer = this.buildJavaManagedTypeContainer();
    }

    @Override
    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        this.syncJavaManagedTypes(monitor);
    }

    @Override
    public void update(IProgressMonitor monitor) {
        super.update(monitor);
        this.updateModels(this.getJavaManagedTypes(), monitor);
    }

    @Override
    public JavaResourcePackageFragmentRoot getJarResourcePackageFragmentRoot() {
        return this.jarResourcePackageFragmentRoot;
    }

    @Override
    public JptResourceType getResourceType() {
        return ContentTypeTools.getResourceType((IContentType)JavaResourcePackageFragmentRoot.JAR_CONTENT_TYPE);
    }

    @Override
    public JavaManagedType getManagedType(String typeName) {
        for (JavaManagedType mt : this.getJavaManagedTypes()) {
            if (!mt.getName().equals(typeName)) continue;
            return mt;
        }
        return null;
    }

    @Override
    public Iterable<JavaManagedType> getJavaManagedTypes() {
        return this.javaManagedTypeContainer;
    }

    @Override
    public int getJavaManagedTypesSize() {
        return this.javaManagedTypeContainer.size();
    }

    protected void syncJavaManagedTypes(IProgressMonitor monitor) {
        this.javaManagedTypeContainer.synchronizeWithResourceModel(monitor);
    }

    protected void addJavaManagedType(JavaResourceType jrt) {
        this.javaManagedTypeContainer.addContextElement(this.getJavaManagedTypesSize(), jrt);
    }

    protected void removeJavaManagedType(JavaManagedType javaManagedType) {
        this.javaManagedTypeContainer.remove(javaManagedType);
    }

    protected Iterable<JavaResourceType> getJavaResourceTypes() {
        return IterableTools.downCast((Iterable)IterableTools.filter(this.getJavaResourceAbstractTypes(), (Predicate)new JavaResourceAnnotatedElement.AstNodeTypeEquals(JavaResourceAnnotatedElement.AstNodeType.TYPE)));
    }

    protected Iterable<JavaResourceAbstractType> getJavaResourceAbstractTypes() {
        return this.jarResourcePackageFragmentRoot.getTypes();
    }

    protected JavaManagedType buildJavaManagedType(JavaResourceType jrt, JavaManagedTypeDefinition managedTypeDefinition) {
        return managedTypeDefinition.buildContextManagedType(this, jrt, this.getJpaFactory());
    }

    protected Iterable<JavaManagedTypeDefinition> getJavaManagedTypeDefinitions() {
        return this.getJpaPlatform().getJavaManagedTypeDefinitions();
    }

    protected JavaManagedTypeDefinition getJavaManagedTypeDefinition(JavaResourceType jrt) {
        for (JavaManagedTypeDefinition managedTypeDefinition : this.getJavaManagedTypeDefinitions()) {
            if (!jrt.isAnnotatedWithAnyOf(managedTypeDefinition.getAnnotationNames(this.getJpaProject()))) continue;
            return managedTypeDefinition;
        }
        return JavaPersistentTypeDefinition.instance();
    }

    protected JavaManagedType buildJavaManagedType(JavaResourceType jrt) {
        return this.getJavaManagedTypeDefinition(jrt).buildContextManagedType(this, jrt, this.getJpaFactory());
    }

    protected AbstractJpaContextModel.ContextCollectionContainer<JavaManagedType, JavaResourceType> buildJavaManagedTypeContainer() {
        return this.buildSpecifiedContextCollectionContainer("javaManagedTypes", new JavaManagedTypeContainerAdapter());
    }

    public Iterable<JavaManagedType> getManagedTypes() {
        return this.getJavaManagedTypes();
    }

    @Override
    public JavaPersistentType getPersistentType(String typeName) {
        JavaManagedType managedType = this.getManagedType(typeName);
        return managedType.getManagedTypeType() == PersistentType.class ? (JavaPersistentType)managedType : null;
    }

    public Iterable<JavaPersistentType> getPersistentTypes() {
        return IterableTools.downCast((Iterable)IterableTools.filter(this.getManagedTypes(), TYPE_IS_PERSISTENT_TYPE));
    }

    @Override
    public AccessType getDefaultPersistentTypeAccess() {
        return this.getPersistenceUnit().getDefaultAccess();
    }

    @Override
    public AccessType getOverridePersistentTypeAccess() {
        return null;
    }

    @Override
    public void attributeChanged(JavaSpecifiedPersistentAttribute attribute) {
    }

    protected JarFileRef getJarFileRef() {
        return (JarFileRef)this.parent;
    }

    @Override
    public IResource getResource() {
        return this.jarResourcePackageFragmentRoot.getFile();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
    }

    @Override
    public boolean isIn(IFolder folder) {
        IResource member = folder.findMember(this.jarResourcePackageFragmentRoot.getFile().getName());
        IFile file = this.jarResourcePackageFragmentRoot.getFile();
        return member != null && file != null && member.equals((Object)file);
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.getJarFileRef().getValidationTextRange();
    }

    public class JavaManagedTypeContainerAdapter
    extends AbstractJpaContextModel.AbstractContainerAdapter<JavaManagedType, JavaResourceType> {
        public JavaManagedTypeContainerAdapter() {
            super(GenericJarFile.this);
        }

        @Override
        public JavaManagedType buildContextElement(JavaResourceType resourceElement) {
            return GenericJarFile.this.buildJavaManagedType(resourceElement);
        }

        @Override
        public Iterable<JavaResourceType> getResourceElements() {
            return GenericJarFile.this.getJavaResourceTypes();
        }

        @Override
        public JavaResourceType extractResourceElement(JavaManagedType contextElement) {
            return contextElement.getJavaResourceType();
        }
    }

    public static class TypeIsPersistentType
    extends PredicateAdapter<JavaManagedType> {
        public boolean evaluate(JavaManagedType mt) {
            return mt.getManagedTypeType() == PersistentType.class;
        }
    }
}

