/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.utils.tests.internal.annotations;

import java.lang.annotation.ElementType;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jst.ws.jaxws.testutils.jmock.Mock;
import org.eclipse.jst.ws.jaxws.testutils.jmock.MockObjectTestCase;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotation;
import org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl.AnnotationProperty;
import org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl.AnnotationPropertyContainer;
import org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl.AttributeTypeEnum;

public class AnnotationPropertyContainerTest
extends MockObjectTestCase {
    private Mock<IType> type = this.mock(IType.class);
    private Mock<IMethod> method = this.mock(IMethod.class);
    private Mock<ITypeParameter> typeParameter = this.mock(ITypeParameter.class);

    public void testBase() throws Exception {
        AnnotationProperty annotationProperty;
        AnnotationPropertyContainer container = new AnnotationPropertyContainer();
        try {
            container.addAnnotationProperty(null, null);
            AnnotationPropertyContainerTest.fail((String)"NullPointerException was not thrown!");
        }
        catch (NullPointerException nullPointerException) {
            AnnotationPropertyContainerTest.assertTrue((boolean)true);
        }
        try {
            annotationProperty = new AnnotationProperty("annotationName", "attributeName", "value", AttributeTypeEnum.STRING);
            container.addAnnotationProperty(annotationProperty, null);
            AnnotationPropertyContainerTest.fail((String)"NullPointerException was not thrown!");
        }
        catch (NullPointerException nullPointerException) {
            AnnotationPropertyContainerTest.assertTrue((boolean)true);
        }
        try {
            annotationProperty = new AnnotationProperty("annotationName", "attributeName", "value", AttributeTypeEnum.STRING);
            container.addAnnotationProperty(annotationProperty, ElementType.PACKAGE);
            AnnotationPropertyContainerTest.fail((String)"IllegalArgumentException was not thrown!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            AnnotationPropertyContainerTest.assertTrue((boolean)true);
        }
    }

    public void testTypeLevel() throws Exception {
        AnnotationPropertyContainer container = new AnnotationPropertyContainer();
        AnnotationProperty annotationProperty = new AnnotationProperty("annotationName", "attributeNameBoolean", "true", AttributeTypeEnum.BOOLEAN);
        container.addAnnotationProperty(annotationProperty, ElementType.TYPE);
        annotationProperty = new AnnotationProperty("annotationName", "attributeNameInteger", "100", AttributeTypeEnum.INTEGER);
        container.addAnnotationProperty(annotationProperty, ElementType.TYPE);
        annotationProperty = new AnnotationProperty("annotationName", "attributeNameQualified", "org.eclipse.testEnumeration.VALUE", AttributeTypeEnum.QUALIFIED_NAME);
        container.addAnnotationProperty(annotationProperty, ElementType.TYPE);
        annotationProperty = new AnnotationProperty("annotationName", "attributeNameString", "valueString", AttributeTypeEnum.STRING);
        container.addAnnotationProperty(annotationProperty, ElementType.TYPE);
        AnnotationPropertyContainerTest.assertTrue((container.getTypeAnnotations((IType)this.type.proxy()).size() == 1 ? 1 : 0) != 0);
        AnnotationPropertyContainerTest.assertTrue((container.getParameterAnnotations((ITypeParameter)this.typeParameter.proxy()).size() == 0 ? 1 : 0) != 0);
        AnnotationPropertyContainerTest.assertTrue((container.getMethodAnnotations((IMethod)this.method.proxy()).size() == 0 ? 1 : 0) != 0);
        Set typeAnnotations = container.getTypeAnnotations((IType)this.type.proxy());
        for (IAnnotation annotation : typeAnnotations) {
            AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getAnnotationName().equals("annotationName"));
            AnnotationPropertyContainerTest.assertTrue((annotation.getParamValuePairs().size() == 4 ? 1 : 0) != 0);
            AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getPropertyValue("attributeNameBoolean").equals("true"));
            AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getPropertyValue("attributeNameInteger").equals("100"));
            AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getPropertyValue("attributeNameQualified").equals("org.eclipse.testEnumeration.VALUE"));
            AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getPropertyValue("attributeNameString").equals("valueString"));
        }
        container = new AnnotationPropertyContainer();
        annotationProperty = new AnnotationProperty("annotationName1", "attributeNameBoolean", "true", AttributeTypeEnum.BOOLEAN);
        container.addAnnotationProperty(annotationProperty, ElementType.TYPE);
        annotationProperty = new AnnotationProperty("annotationName2", "attributeNameInteger", "100", AttributeTypeEnum.INTEGER);
        container.addAnnotationProperty(annotationProperty, ElementType.TYPE);
        annotationProperty = new AnnotationProperty("annotationName3", "attributeNameQualified", "org.eclipse.testEnumeration.VALUE", AttributeTypeEnum.QUALIFIED_NAME);
        container.addAnnotationProperty(annotationProperty, ElementType.TYPE);
        annotationProperty = new AnnotationProperty("annotationName4", "attributeNameString", "valueString", AttributeTypeEnum.STRING);
        container.addAnnotationProperty(annotationProperty, ElementType.TYPE);
        AnnotationPropertyContainerTest.assertTrue((container.getTypeAnnotations((IType)this.type.proxy()).size() == 4 ? 1 : 0) != 0);
        AnnotationPropertyContainerTest.assertTrue((container.getParameterAnnotations((ITypeParameter)this.typeParameter.proxy()).size() == 0 ? 1 : 0) != 0);
        AnnotationPropertyContainerTest.assertTrue((container.getMethodAnnotations((IMethod)this.method.proxy()).size() == 0 ? 1 : 0) != 0);
        typeAnnotations = container.getTypeAnnotations((IType)this.type.proxy());
        HashSet<String> names = new HashSet<String>();
        names.clear();
        names.add("annotationName1");
        names.add("annotationName2");
        names.add("annotationName3");
        names.add("annotationName4");
        for (IAnnotation annotation : typeAnnotations) {
            AnnotationPropertyContainerTest.assertTrue((boolean)names.contains(annotation.getAnnotationName()));
            names.remove(annotation.getAnnotationName());
            if (annotation.getAnnotationName().equals("annotationName1")) {
                AnnotationPropertyContainerTest.assertTrue((annotation.getParamValuePairs().size() == 1 ? 1 : 0) != 0);
                AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getPropertyValue("attributeNameBoolean").equals("true"));
            }
            if (annotation.getAnnotationName().equals("annotationName2")) {
                AnnotationPropertyContainerTest.assertTrue((annotation.getParamValuePairs().size() == 1 ? 1 : 0) != 0);
                AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getPropertyValue("attributeNameInteger").equals("100"));
            }
            if (annotation.getAnnotationName().equals("annotationName3")) {
                AnnotationPropertyContainerTest.assertTrue((annotation.getParamValuePairs().size() == 1 ? 1 : 0) != 0);
                AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getPropertyValue("attributeNameQualified").equals("org.eclipse.testEnumeration.VALUE"));
            }
            if (!annotation.getAnnotationName().equals("annotationName4")) continue;
            AnnotationPropertyContainerTest.assertTrue((annotation.getParamValuePairs().size() == 1 ? 1 : 0) != 0);
            AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getPropertyValue("attributeNameString").equals("valueString"));
        }
    }

    public void testMethodLevel() throws Exception {
        AnnotationPropertyContainer container = new AnnotationPropertyContainer();
        AnnotationProperty annotationProperty = new AnnotationProperty("annotationName", "attributeNameBoolean", "true", AttributeTypeEnum.BOOLEAN);
        container.addAnnotationProperty(annotationProperty, ElementType.METHOD);
        annotationProperty = new AnnotationProperty("annotationName", "attributeNameInteger", "100", AttributeTypeEnum.INTEGER);
        container.addAnnotationProperty(annotationProperty, ElementType.METHOD);
        annotationProperty = new AnnotationProperty("annotationName", "attributeNameQualified", "org.eclipse.testEnumeration.VALUE", AttributeTypeEnum.QUALIFIED_NAME);
        container.addAnnotationProperty(annotationProperty, ElementType.METHOD);
        annotationProperty = new AnnotationProperty("annotationName", "attributeNameString", "valueString", AttributeTypeEnum.STRING);
        container.addAnnotationProperty(annotationProperty, ElementType.METHOD);
        AnnotationPropertyContainerTest.assertTrue((container.getTypeAnnotations((IType)this.type.proxy()).size() == 0 ? 1 : 0) != 0);
        AnnotationPropertyContainerTest.assertTrue((container.getParameterAnnotations((ITypeParameter)this.typeParameter.proxy()).size() == 0 ? 1 : 0) != 0);
        AnnotationPropertyContainerTest.assertTrue((container.getMethodAnnotations((IMethod)this.method.proxy()).size() == 1 ? 1 : 0) != 0);
        Set methodAnnotations = container.getMethodAnnotations((IMethod)this.method.proxy());
        for (IAnnotation annotation : methodAnnotations) {
            AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getAnnotationName().equals("annotationName"));
            AnnotationPropertyContainerTest.assertTrue((annotation.getParamValuePairs().size() == 4 ? 1 : 0) != 0);
            AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getPropertyValue("attributeNameBoolean").equals("true"));
            AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getPropertyValue("attributeNameInteger").equals("100"));
            AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getPropertyValue("attributeNameQualified").equals("org.eclipse.testEnumeration.VALUE"));
            AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getPropertyValue("attributeNameString").equals("valueString"));
        }
        container = new AnnotationPropertyContainer();
        annotationProperty = new AnnotationProperty("annotationName1", "attributeNameBoolean", "true", AttributeTypeEnum.BOOLEAN);
        container.addAnnotationProperty(annotationProperty, ElementType.METHOD);
        annotationProperty = new AnnotationProperty("annotationName2", "attributeNameInteger", "100", AttributeTypeEnum.INTEGER);
        container.addAnnotationProperty(annotationProperty, ElementType.METHOD);
        annotationProperty = new AnnotationProperty("annotationName3", "attributeNameQualified", "org.eclipse.testEnumeration.VALUE", AttributeTypeEnum.QUALIFIED_NAME);
        container.addAnnotationProperty(annotationProperty, ElementType.METHOD);
        annotationProperty = new AnnotationProperty("annotationName4", "attributeNameString", "valueString", AttributeTypeEnum.STRING);
        container.addAnnotationProperty(annotationProperty, ElementType.METHOD);
        AnnotationPropertyContainerTest.assertTrue((container.getTypeAnnotations((IType)this.type.proxy()).size() == 0 ? 1 : 0) != 0);
        AnnotationPropertyContainerTest.assertTrue((container.getParameterAnnotations((ITypeParameter)this.typeParameter.proxy()).size() == 0 ? 1 : 0) != 0);
        AnnotationPropertyContainerTest.assertTrue((container.getMethodAnnotations((IMethod)this.method.proxy()).size() == 4 ? 1 : 0) != 0);
        methodAnnotations = container.getMethodAnnotations((IMethod)this.method.proxy());
        HashSet<String> names = new HashSet<String>();
        names.clear();
        names.add("annotationName1");
        names.add("annotationName2");
        names.add("annotationName3");
        names.add("annotationName4");
        for (IAnnotation annotation : methodAnnotations) {
            AnnotationPropertyContainerTest.assertTrue((boolean)names.contains(annotation.getAnnotationName()));
            names.remove(annotation.getAnnotationName());
            if (annotation.getAnnotationName().equals("annotationName1")) {
                AnnotationPropertyContainerTest.assertTrue((annotation.getParamValuePairs().size() == 1 ? 1 : 0) != 0);
                AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getPropertyValue("attributeNameBoolean").equals("true"));
            }
            if (annotation.getAnnotationName().equals("annotationName2")) {
                AnnotationPropertyContainerTest.assertTrue((annotation.getParamValuePairs().size() == 1 ? 1 : 0) != 0);
                AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getPropertyValue("attributeNameInteger").equals("100"));
            }
            if (annotation.getAnnotationName().equals("annotationName3")) {
                AnnotationPropertyContainerTest.assertTrue((annotation.getParamValuePairs().size() == 1 ? 1 : 0) != 0);
                AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getPropertyValue("attributeNameQualified").equals("org.eclipse.testEnumeration.VALUE"));
            }
            if (!annotation.getAnnotationName().equals("annotationName4")) continue;
            AnnotationPropertyContainerTest.assertTrue((annotation.getParamValuePairs().size() == 1 ? 1 : 0) != 0);
            AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getPropertyValue("attributeNameString").equals("valueString"));
        }
    }

    public void testParameterLevel() throws Exception {
        AnnotationPropertyContainer container = new AnnotationPropertyContainer();
        AnnotationProperty annotationProperty = new AnnotationProperty("annotationName", "attributeNameBoolean", "true", AttributeTypeEnum.BOOLEAN);
        container.addAnnotationProperty(annotationProperty, ElementType.PARAMETER);
        annotationProperty = new AnnotationProperty("annotationName", "attributeNameInteger", "100", AttributeTypeEnum.INTEGER);
        container.addAnnotationProperty(annotationProperty, ElementType.PARAMETER);
        annotationProperty = new AnnotationProperty("annotationName", "attributeNameQualified", "org.eclipse.testEnumeration.VALUE", AttributeTypeEnum.QUALIFIED_NAME);
        container.addAnnotationProperty(annotationProperty, ElementType.PARAMETER);
        annotationProperty = new AnnotationProperty("annotationName", "attributeNameString", "valueString", AttributeTypeEnum.STRING);
        container.addAnnotationProperty(annotationProperty, ElementType.PARAMETER);
        AnnotationPropertyContainerTest.assertTrue((container.getTypeAnnotations((IType)this.type.proxy()).size() == 0 ? 1 : 0) != 0);
        AnnotationPropertyContainerTest.assertTrue((container.getParameterAnnotations((ITypeParameter)this.typeParameter.proxy()).size() == 1 ? 1 : 0) != 0);
        AnnotationPropertyContainerTest.assertTrue((container.getMethodAnnotations((IMethod)this.method.proxy()).size() == 0 ? 1 : 0) != 0);
        Set parameterAnnotations = container.getParameterAnnotations((ITypeParameter)this.typeParameter.proxy());
        for (IAnnotation annotation : parameterAnnotations) {
            AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getAnnotationName().equals("annotationName"));
            AnnotationPropertyContainerTest.assertTrue((annotation.getParamValuePairs().size() == 4 ? 1 : 0) != 0);
            AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getPropertyValue("attributeNameBoolean").equals("true"));
            AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getPropertyValue("attributeNameInteger").equals("100"));
            AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getPropertyValue("attributeNameQualified").equals("org.eclipse.testEnumeration.VALUE"));
            AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getPropertyValue("attributeNameString").equals("valueString"));
        }
        container = new AnnotationPropertyContainer();
        annotationProperty = new AnnotationProperty("annotationName1", "attributeNameBoolean", "true", AttributeTypeEnum.BOOLEAN);
        container.addAnnotationProperty(annotationProperty, ElementType.PARAMETER);
        annotationProperty = new AnnotationProperty("annotationName2", "attributeNameInteger", "100", AttributeTypeEnum.INTEGER);
        container.addAnnotationProperty(annotationProperty, ElementType.PARAMETER);
        annotationProperty = new AnnotationProperty("annotationName3", "attributeNameQualified", "org.eclipse.testEnumeration.VALUE", AttributeTypeEnum.QUALIFIED_NAME);
        container.addAnnotationProperty(annotationProperty, ElementType.PARAMETER);
        annotationProperty = new AnnotationProperty("annotationName4", "attributeNameString", "valueString", AttributeTypeEnum.STRING);
        container.addAnnotationProperty(annotationProperty, ElementType.PARAMETER);
        AnnotationPropertyContainerTest.assertTrue((container.getTypeAnnotations((IType)this.type.proxy()).size() == 0 ? 1 : 0) != 0);
        AnnotationPropertyContainerTest.assertTrue((container.getParameterAnnotations((ITypeParameter)this.typeParameter.proxy()).size() == 4 ? 1 : 0) != 0);
        AnnotationPropertyContainerTest.assertTrue((container.getMethodAnnotations((IMethod)this.method.proxy()).size() == 0 ? 1 : 0) != 0);
        parameterAnnotations = container.getParameterAnnotations((ITypeParameter)this.typeParameter.proxy());
        HashSet<String> names = new HashSet<String>();
        names.clear();
        names.add("annotationName1");
        names.add("annotationName2");
        names.add("annotationName3");
        names.add("annotationName4");
        for (IAnnotation annotation : parameterAnnotations) {
            AnnotationPropertyContainerTest.assertTrue((boolean)names.contains(annotation.getAnnotationName()));
            names.remove(annotation.getAnnotationName());
            if (annotation.getAnnotationName().equals("annotationName1")) {
                AnnotationPropertyContainerTest.assertTrue((annotation.getParamValuePairs().size() == 1 ? 1 : 0) != 0);
                AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getPropertyValue("attributeNameBoolean").equals("true"));
            }
            if (annotation.getAnnotationName().equals("annotationName2")) {
                AnnotationPropertyContainerTest.assertTrue((annotation.getParamValuePairs().size() == 1 ? 1 : 0) != 0);
                AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getPropertyValue("attributeNameInteger").equals("100"));
            }
            if (annotation.getAnnotationName().equals("annotationName3")) {
                AnnotationPropertyContainerTest.assertTrue((annotation.getParamValuePairs().size() == 1 ? 1 : 0) != 0);
                AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getPropertyValue("attributeNameQualified").equals("org.eclipse.testEnumeration.VALUE"));
            }
            if (!annotation.getAnnotationName().equals("annotationName4")) continue;
            AnnotationPropertyContainerTest.assertTrue((annotation.getParamValuePairs().size() == 1 ? 1 : 0) != 0);
            AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getPropertyValue("attributeNameString").equals("valueString"));
        }
    }

    public void testCombined() throws Exception {
        AnnotationPropertyContainer container = new AnnotationPropertyContainer();
        AnnotationProperty annotationProperty = new AnnotationProperty("paramAnnotationName", "paramAttributeNameBoolean", "true", AttributeTypeEnum.BOOLEAN);
        container.addAnnotationProperty(annotationProperty, ElementType.PARAMETER);
        annotationProperty = new AnnotationProperty("paramAnnotationName", "paramAttributeNameInteger", "100", AttributeTypeEnum.INTEGER);
        container.addAnnotationProperty(annotationProperty, ElementType.PARAMETER);
        annotationProperty = new AnnotationProperty("paramAnnotationName", "paramAttributeNameQualified", "org.eclipse.testEnumeration.PARAM_VALUE", AttributeTypeEnum.QUALIFIED_NAME);
        container.addAnnotationProperty(annotationProperty, ElementType.PARAMETER);
        annotationProperty = new AnnotationProperty("paramAnnotationName", "paramAttributeNameString", "paramValueString", AttributeTypeEnum.STRING);
        container.addAnnotationProperty(annotationProperty, ElementType.PARAMETER);
        annotationProperty = new AnnotationProperty("methodAnnotationName", "methodAttributeNameBoolean", "false", AttributeTypeEnum.BOOLEAN);
        container.addAnnotationProperty(annotationProperty, ElementType.METHOD);
        annotationProperty = new AnnotationProperty("methodAnnotationName", "methodAttributeNameInteger", "101", AttributeTypeEnum.INTEGER);
        container.addAnnotationProperty(annotationProperty, ElementType.METHOD);
        annotationProperty = new AnnotationProperty("methodAnnotationName", "methodAttributeNameQualified", "org.eclipse.testEnumeration.METHOD_VALUE", AttributeTypeEnum.QUALIFIED_NAME);
        container.addAnnotationProperty(annotationProperty, ElementType.METHOD);
        annotationProperty = new AnnotationProperty("methodAnnotationName", "methodAttributeNameString", "methodValueString", AttributeTypeEnum.STRING);
        container.addAnnotationProperty(annotationProperty, ElementType.METHOD);
        annotationProperty = new AnnotationProperty("typeAnnotationName", "typeAttributeNameBoolean", "false", AttributeTypeEnum.BOOLEAN);
        container.addAnnotationProperty(annotationProperty, ElementType.TYPE);
        annotationProperty = new AnnotationProperty("typeAnnotationName", "typeAttributeNameInteger", "1", AttributeTypeEnum.INTEGER);
        container.addAnnotationProperty(annotationProperty, ElementType.TYPE);
        annotationProperty = new AnnotationProperty("typeAnnotationName", "typeAttributeNameQualified", "org.eclipse.testEnumeration.TYPE_VALUE", AttributeTypeEnum.QUALIFIED_NAME);
        container.addAnnotationProperty(annotationProperty, ElementType.TYPE);
        annotationProperty = new AnnotationProperty("typeAnnotationName", "typeAttributeNameString", "typeValueString", AttributeTypeEnum.STRING);
        container.addAnnotationProperty(annotationProperty, ElementType.TYPE);
        AnnotationPropertyContainerTest.assertTrue((container.getTypeAnnotations((IType)this.type.proxy()).size() == 1 ? 1 : 0) != 0);
        AnnotationPropertyContainerTest.assertTrue((container.getParameterAnnotations((ITypeParameter)this.typeParameter.proxy()).size() == 1 ? 1 : 0) != 0);
        AnnotationPropertyContainerTest.assertTrue((container.getMethodAnnotations((IMethod)this.method.proxy()).size() == 1 ? 1 : 0) != 0);
        Set parameterAnnotations = container.getParameterAnnotations((ITypeParameter)this.typeParameter.proxy());
        for (IAnnotation annotation : parameterAnnotations) {
            AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getAnnotationName().equals("paramAnnotationName"));
            AnnotationPropertyContainerTest.assertTrue((annotation.getParamValuePairs().size() == 4 ? 1 : 0) != 0);
            AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getPropertyValue("paramAttributeNameBoolean").equals("true"));
            AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getPropertyValue("paramAttributeNameInteger").equals("100"));
            AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getPropertyValue("paramAttributeNameQualified").equals("org.eclipse.testEnumeration.PARAM_VALUE"));
            AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getPropertyValue("paramAttributeNameString").equals("paramValueString"));
        }
        Set methodAnnotations = container.getMethodAnnotations((IMethod)this.method.proxy());
        for (IAnnotation annotation : methodAnnotations) {
            AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getAnnotationName().equals("methodAnnotationName"));
            AnnotationPropertyContainerTest.assertTrue((annotation.getParamValuePairs().size() == 4 ? 1 : 0) != 0);
            AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getPropertyValue("methodAttributeNameBoolean").equals("false"));
            AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getPropertyValue("methodAttributeNameInteger").equals("101"));
            AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getPropertyValue("methodAttributeNameQualified").equals("org.eclipse.testEnumeration.METHOD_VALUE"));
            AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getPropertyValue("methodAttributeNameString").equals("methodValueString"));
        }
        Set typeAnnotations = container.getTypeAnnotations((IType)this.type.proxy());
        for (IAnnotation annotation : typeAnnotations) {
            AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getAnnotationName().equals("typeAnnotationName"));
            AnnotationPropertyContainerTest.assertTrue((annotation.getParamValuePairs().size() == 4 ? 1 : 0) != 0);
            AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getPropertyValue("typeAttributeNameBoolean").equals("false"));
            AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getPropertyValue("typeAttributeNameInteger").equals("1"));
            AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getPropertyValue("typeAttributeNameQualified").equals("org.eclipse.testEnumeration.TYPE_VALUE"));
            AnnotationPropertyContainerTest.assertTrue((boolean)annotation.getPropertyValue("typeAttributeNameString").equals("typeValueString"));
        }
    }
}

