/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.io;

import java.io.IOException;
import java.io.Writer;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.io.InvalidWriter;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class InvalidWriterTests
extends TestCase {
    private Writer invalidWriter;

    public InvalidWriterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.invalidWriter = InvalidWriter.instance();
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testClose() throws IOException {
        this.invalidWriter.close();
    }

    public void testFlush() throws IOException {
        this.invalidWriter.flush();
    }

    public void testWriteCharArray() throws IOException {
        char[] cbuf = new char[10];
        boolean exCaught = false;
        try {
            this.invalidWriter.write(cbuf);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        InvalidWriterTests.assertTrue((boolean)exCaught);
    }

    public void testWriteCharArrayIntInt() throws IOException {
        char[] cbuf = new char[10];
        boolean exCaught = false;
        try {
            this.invalidWriter.write(cbuf, 3, 2);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        InvalidWriterTests.assertTrue((boolean)exCaught);
    }

    public void testWriteInt() throws IOException {
        boolean exCaught = false;
        try {
            this.invalidWriter.write(77);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        InvalidWriterTests.assertTrue((boolean)exCaught);
    }

    public void testWriteString() throws IOException {
        boolean exCaught = false;
        try {
            this.invalidWriter.write("cbuf");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        InvalidWriterTests.assertTrue((boolean)exCaught);
    }

    public void testWriteStringIntInt() throws IOException {
        boolean exCaught = false;
        try {
            this.invalidWriter.write("cbuf", 1, 2);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        InvalidWriterTests.assertTrue((boolean)exCaught);
    }
}

