/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import java.util.HashMap;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jpt.common.ui.WidgetFactory;
import org.eclipse.jpt.common.ui.internal.swt.bindings.SWTBindingTools;
import org.eclipse.jpt.common.utility.internal.model.value.FilteringPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.StaticPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.predicate.CriterionPredicate;
import org.eclipse.jpt.common.utility.internal.transformer.AbstractTransformer;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.ui.JpaPlatformUi;
import org.eclipse.jpt.jpa.ui.details.JpaComposite;
import org.eclipse.jpt.jpa.ui.internal.details.AbstractJpaDetailsPageManager;
import org.eclipse.jpt.jpa.ui.internal.details.PersistentTypeMapAsComposite;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.PageBook;

public class PersistentTypeDetailsPageManager
extends AbstractJpaDetailsPageManager<PersistentType> {
    private final HashMap<String, JpaComposite> mappingComposites = new HashMap();
    private PageBook mappingPageBook;
    private PropertyValueModel<TypeMapping> mappingHolder;
    private static final PropertyValueModel<Boolean> TRUE_ENABLED_MODEL = new StaticPropertyValueModel((Object)Boolean.TRUE);
    private static final String TRACE_OPTION = PersistentTypeDetailsPageManager.class.getSimpleName();

    public PersistentTypeDetailsPageManager(Composite parent, WidgetFactory widgetFactory, ResourceManager resourceManager) {
        super(parent, widgetFactory, resourceManager);
    }

    protected void initialize() {
        super.initialize();
    }

    protected void initializeLayout(Composite container) {
        new PersistentTypeMapAsComposite(this, container);
        this.mappingPageBook = this.buildMappingPageBook(container);
    }

    protected PageBook buildMappingPageBook(Composite parent) {
        PageBook book = new PageBook(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 128;
        gridData.verticalIndent = 5;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        book.setLayoutData((Object)gridData);
        this.mappingHolder = this.buildMappingHolder();
        SWTBindingTools.bind(this.mappingHolder, this.buildPaneTransformer(), (PageBook)book);
        return book;
    }

    private Transformer<TypeMapping, Control> buildPaneTransformer() {
        return new PaneTransformer();
    }

    protected PropertyValueModel<TypeMapping> buildMappingHolder(String key) {
        return new FilteringPropertyValueModel(this.mappingHolder, this.buildMappingFilter(key));
    }

    private PropertyAspectAdapter<PersistentType, TypeMapping> buildMappingHolder() {
        return new PropertyAspectAdapter<PersistentType, TypeMapping>(this.getSubjectHolder(), new String[]{"mapping"}){

            protected TypeMapping buildValue_() {
                return ((PersistentType)this.subject).getMapping();
            }
        };
    }

    private Predicate<TypeMapping> buildMappingFilter(String key) {
        return new KeyEquals(key);
    }

    JpaComposite getMappingComposite(String key) {
        JpaComposite composite = this.mappingComposites.get(key);
        if (composite == null && (composite = this.buildMappingComposite(this.mappingPageBook, key)) != null) {
            this.mappingComposites.put(key, composite);
        }
        return composite;
    }

    protected JpaComposite buildMappingComposite(PageBook pageBook, String key) {
        JpaPlatformUi ui = this.getJpaPlatformUi();
        return ui == null ? null : ui.buildTypeMappingComposite(((PersistentType)this.getSubject()).getResourceType(), key, this.buildMappingHolder(key), this.getMappingCompositeEnabledModel(), (Composite)pageBook, this.getWidgetFactory(), this.getResourceManager());
    }

    protected PropertyValueModel<Boolean> getMappingCompositeEnabledModel() {
        return TRUE_ENABLED_MODEL;
    }

    @Override
    public void controlDisposed() {
        JptJpaUiPlugin.instance().trace(TRACE_OPTION, "dispose");
        this.mappingComposites.clear();
        super.controlDisposed();
    }

    class KeyEquals
    extends CriterionPredicate<TypeMapping, String> {
        private KeyEquals(String key) {
            super((Object)key);
        }

        public boolean evaluate(TypeMapping mapping) {
            return mapping == null || this.criterion == null || ((String)this.criterion).equals(mapping.getKey());
        }
    }

    protected class PaneTransformer
    extends AbstractTransformer<TypeMapping, Control> {
        protected PaneTransformer() {
        }

        public Control transform_(TypeMapping typeMapping) {
            return PersistentTypeDetailsPageManager.this.getMappingComposite(typeMapping.getKey()).getControl();
        }
    }
}

