/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis2.creation.ui.widgets.bean;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.axis2.creation.core.data.DataModel;
import org.eclipse.jst.ws.axis2.creation.core.messages.Axis2CreationUIMessages;
import org.eclipse.jst.ws.axis2.creation.core.utils.ServicesXMLUtils;
import org.eclipse.jst.ws.internal.ui.common.DialogResourceBrowser;
import org.eclipse.jst.ws.internal.ui.common.FileExtensionFilter;
import org.eclipse.jst.ws.internal.ui.common.IFilter;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class ServicesXMLSelectBeanWidget
extends SimpleWidgetDataContributor {
    private DataModel model;
    private Button browseButton;
    private Text servicesXMLPath;
    private Button generateServicesXML;
    private Button haveServicesXML;

    public ServicesXMLSelectBeanWidget(DataModel model) {
        this.model = model;
    }

    public WidgetDataEvents addControls(Composite parent, final Listener statusListener) {
        UIUtils uiUtils = new UIUtils("org.eclipse.jst.ws.axis2.consumption.ui");
        Text label = new Text(parent, 8);
        label.setText(Axis2CreationUIMessages.LABEL_AXIS2_PREFERENCE_PAGE);
        this.model.setGenerateServicesXML(true);
        this.model.setServicesXML(false);
        Composite radioComp = uiUtils.createComposite(parent, 1);
        this.haveServicesXML = uiUtils.createRadioButton(radioComp, Axis2CreationUIMessages.LABEL_HAVE_SERVICES_XML_FILE, null, null);
        this.haveServicesXML.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ServicesXMLSelectBeanWidget.this.haveServicesXML.getSelection()) {
                    ServicesXMLSelectBeanWidget.this.haveServicesXML.setSelection(true);
                    ServicesXMLSelectBeanWidget.this.generateServicesXML.setSelection(false);
                    ServicesXMLSelectBeanWidget.this.enableServicesXMLBrowse();
                } else if (!ServicesXMLSelectBeanWidget.this.generateServicesXML.getSelection()) {
                    ServicesXMLSelectBeanWidget.this.haveServicesXML.setSelection(true);
                    ServicesXMLSelectBeanWidget.this.generateServicesXML.setSelection(false);
                    ServicesXMLSelectBeanWidget.this.enableServicesXMLBrowse();
                } else {
                    ServicesXMLSelectBeanWidget.this.haveServicesXML.setSelection(false);
                    ServicesXMLSelectBeanWidget.this.disableServicesXMLBrowse();
                }
                ServicesXMLSelectBeanWidget.this.model.setGenerateServicesXML(false);
                ServicesXMLSelectBeanWidget.this.model.setServicesXML(true);
                statusListener.handleEvent(null);
            }
        });
        final Composite pathComp = uiUtils.createComposite(radioComp, 3);
        this.servicesXMLPath = uiUtils.createText(pathComp, "", null, null, 2048);
        this.servicesXMLPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServicesXMLSelectBeanWidget.this.model.setPathToServicesXML(ServicesXMLSelectBeanWidget.this.servicesXMLPath.getText());
                statusListener.handleEvent(null);
            }
        });
        this.browseButton = uiUtils.createPushButton(pathComp, Axis2CreationUIMessages.LABEL_BROWSE, null, null);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServicesXMLSelectBeanWidget.this.handleBrowse(pathComp.getShell());
                statusListener.handleEvent(null);
            }
        });
        this.generateServicesXML = uiUtils.createRadioButton(radioComp, Axis2CreationUIMessages.LABEL_DEFAULT_SERVICES_XML_FILE, null, null);
        this.generateServicesXML.setSelection(true);
        this.generateServicesXML.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ServicesXMLSelectBeanWidget.this.generateServicesXML.getSelection()) {
                    ServicesXMLSelectBeanWidget.this.generateServicesXML.setSelection(true);
                    ServicesXMLSelectBeanWidget.this.haveServicesXML.setSelection(false);
                    ServicesXMLSelectBeanWidget.this.disableServicesXMLBrowse();
                } else if (!ServicesXMLSelectBeanWidget.this.haveServicesXML.getSelection()) {
                    ServicesXMLSelectBeanWidget.this.generateServicesXML.setSelection(true);
                    ServicesXMLSelectBeanWidget.this.haveServicesXML.setSelection(false);
                } else {
                    ServicesXMLSelectBeanWidget.this.generateServicesXML.setSelection(false);
                }
                ServicesXMLSelectBeanWidget.this.model.setGenerateServicesXML(true);
                ServicesXMLSelectBeanWidget.this.model.setServicesXML(false);
                statusListener.handleEvent(null);
            }
        });
        this.disableServicesXMLBrowse();
        return this;
    }

    public IStatus getStatus() {
        Status result = null;
        String serviceXMLPathLocation = this.servicesXMLPath.getText();
        if (this.haveServicesXML.getSelection() && (serviceXMLPathLocation.equals("") || !new File(serviceXMLPathLocation).exists())) {
            result = new Status(4, "id", 0, Axis2CreationUIMessages.ERROR_INVALID_SERVICES_XML, null);
        }
        return result;
    }

    private void enableServicesXMLBrowse() {
        this.browseButton.setEnabled(true);
        this.servicesXMLPath.setEnabled(true);
    }

    private void disableServicesXMLBrowse() {
        this.browseButton.setEnabled(false);
        this.servicesXMLPath.setEnabled(false);
    }

    private void handleBrowse(Shell parent) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        FileExtensionFilter fileExtensionFilter = new FileExtensionFilter(new String[]{"xml"});
        DialogResourceBrowser dialog = new DialogResourceBrowser(parent.getShell(), (IResource)root, (IFilter)fileExtensionFilter);
        boolean isShowDialog = true;
        while (isShowDialog) {
            if (dialog.open() == 1) break;
            IResource res = dialog.getFirstSelection();
            if (res == null) continue;
            String fileLocation = res.getLocation().toOSString();
            if (ServicesXMLUtils.isServicesXMLValid((String)fileLocation)) {
                this.servicesXMLPath.setText(fileLocation);
                this.model.setPathToServicesXML(fileLocation);
                isShowDialog = false;
                continue;
            }
            MessageBox messageBox = new MessageBox(parent, 32);
            messageBox.setMessage(Axis2CreationUIMessages.ERROR_INVALID_SERVICES_XML);
            messageBox.open();
        }
    }
}

