/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.core.internal.validation.eclipse;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.common.uriresolver.internal.util.URIEncoder;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.xml.core.internal.validation.core.AbstractNestedValidator;
import org.eclipse.wst.xml.core.internal.validation.core.NestedValidatorContext;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationMessage;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationReport;
import org.eclipse.wst.xsl.core.XSLCore;
import org.eclipse.wst.xsl.core.internal.XSLCorePlugin;
import org.eclipse.wst.xsl.core.internal.validation.XSLValidationMessage;
import org.eclipse.wst.xsl.core.internal.validation.XSLValidator;
import org.eclipse.wst.xsl.core.internal.validation.eclipse.XSLValidationReport;
import org.eclipse.wst.xsl.core.model.StylesheetModel;
import org.eclipse.wst.xsl.core.model.XSLAttribute;
import org.eclipse.wst.xsl.core.model.XSLNode;

public class Validator
extends AbstractNestedValidator {
    private boolean asYouTypeValidation;

    public void clean(IProject project, ValidationState state, IProgressMonitor monitor) {
        super.clean(project, state, monitor);
        XSLCore.getInstance().clean(project, monitor);
    }

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        ValidationResult res = super.validate(resource, kind, state, monitor);
        if (resource.getType() == 1) {
            StylesheetModel stylesheet = XSLCore.getInstance().getStylesheet((IFile)resource);
            IFile[] dependencies = stylesheet.getFileDependencies().toArray(new IFile[0]);
            res.setDependsOn((IResource[])dependencies);
        }
        return res;
    }

    public IStatus validateInJob(IValidationContext context, IReporter reporter) throws ValidationException {
        this.asYouTypeValidation = true;
        return super.validateInJob(context, reporter);
    }

    public ValidationReport validate(String uri, InputStream inputstream, NestedValidatorContext context) {
        XSLValidationReport valreport = new XSLValidationReport(uri);
        try {
            String encUri = URIEncoder.encode((String)uri);
            IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(new URI(encUri));
            if (files.length > 0) {
                IFile xslFile = files[0];
                valreport = XSLValidator.getInstance().validate(xslFile, this.asYouTypeValidation);
            }
        }
        catch (URISyntaxException e) {
            XSLCorePlugin.log(e);
        }
        catch (CoreException e) {
            XSLCorePlugin.log(e);
        }
        return valreport;
    }

    protected void addInfoToMessage(ValidationMessage validationMessage, IMessage message) {
        XSLValidationMessage msg = (XSLValidationMessage)validationMessage;
        XSLNode node = msg.getNode();
        message.setSeverity(msg.getRealSeverity());
        if (node.getNodeType() == 2) {
            message.setAttribute("ERROR_SIDE", (Object)"ERROR_SIDE_RIGHT");
            message.setAttribute("columnNumber", (Object)validationMessage.getColumnNumber());
            message.setAttribute("squiggleSelectionStrategy", (Object)"ATTRIBUTE_VALUE");
            message.setAttribute("squiggleNameOrValue", (Object)((XSLAttribute)node).getName());
        } else if (node.getNodeType() == 1) {
            message.setAttribute("ERROR_SIDE", (Object)"ERROR_SIDE_RIGHT");
            message.setAttribute("columnNumber", (Object)validationMessage.getColumnNumber());
            message.setAttribute("squiggleSelectionStrategy", (Object)"START_TAG");
        }
    }
}

