/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import org.eclipse.jem.internal.proxy.common.MapTypes;
import org.eclipse.jem.internal.proxy.core.IArrayBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IConstructorProxy;
import org.eclipse.jem.internal.proxy.core.IFieldProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.remote.IREMBeanProxy;
import org.eclipse.jem.internal.proxy.remote.IREMBeanTypeProxy;
import org.eclipse.jem.internal.proxy.remote.IREMMethodProxy;
import org.eclipse.jem.internal.proxy.remote.REMAbstractBeanTypeProxy;
import org.eclipse.jem.internal.proxy.remote.REMArrayBeanProxy;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanProxyConstants;

public final class REMArrayBeanTypeProxy
extends REMAbstractBeanTypeProxy
implements IArrayBeanTypeProxy {
    protected REMArrayBeanTypeProxy(REMProxyFactoryRegistry aRegistry, Integer anID, String aClassname, IBeanTypeProxy objectType) {
        super(aRegistry, anID, aClassname, objectType);
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public IBeanTypeProxy getFinalComponentType() {
        int typeStart = this.getTypeName().lastIndexOf(91) + 1;
        if (this.getTypeName().charAt(typeStart) == 'L') {
            return this.fRegistry.getBeanTypeProxyFactory().getBeanTypeProxy(this.getTypeName().substring(typeStart + 1, this.getTypeName().length() - 1));
        }
        Class aType = (Class)MapTypes.MAP_SHORTSIG_TO_TYPE.get(this.getTypeName().substring(typeStart, typeStart + 1));
        return aType != null ? this.fRegistry.getBeanTypeProxyFactory().getBeanTypeProxy(aType.getName()) : null;
    }

    @Override
    public IBeanTypeProxy getComponentType() {
        if (this.getTypeName().charAt(1) != '[') {
            return this.getFinalComponentType();
        }
        return this.fRegistry.getBeanTypeProxyFactory().getBeanTypeProxy(this.getTypeName().substring(1));
    }

    @Override
    public int getDimensions() {
        return this.getTypeName().lastIndexOf(91) + 1;
    }

    @Override
    public IREMBeanProxy newBeanProxy(Integer anID) {
        return new REMArrayBeanProxy(this.fRegistry, anID, this);
    }

    @Override
    public IREMBeanTypeProxy newBeanTypeForClass(Integer anID, String aClassname, boolean anAbstract) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstructorProxy getNullConstructorProxy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstructorProxy getConstructorProxy(String[] argumentClassNames) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstructorProxy getConstructorProxy(IBeanTypeProxy[] argumentTypes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstructorProxy[] getConstructors() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstructorProxy[] getDeclaredConstructors() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstructorProxy getDeclaredConstructorProxy(String[] argumentClassNames) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IConstructorProxy getDeclaredConstructorProxy(IBeanTypeProxy[] argumentTypes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IFieldProxy getFieldProxy(String fieldName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IFieldProxy[] getFields() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IFieldProxy[] getDeclaredFields() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IMethodProxy[] getMethods() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IMethodProxy[] getDeclaredMethods() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IMethodProxy getMethodProxy(String methodName, IBeanTypeProxy[] argumentTypes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IMethodProxy getMethodProxy(String methodName, String[] argumentClassNames) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IMethodProxy getDeclaredMethodProxy(String methodName, IBeanTypeProxy[] argumentTypes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IMethodProxy getDeclaredMethodProxy(String methodName, String[] argumentClassNames) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IMethodProxy getMethodProxy(String methodName, String argumentQualifiedTypeName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IMethodProxy getMethodProxy(String methodName) {
        throw new UnsupportedOperationException();
    }

    REMArrayBeanProxy createBeanProxyWith(int[] dimensions) throws ThrowableProxy {
        Object[] parms;
        if (dimensions == null || dimensions.length == 0) {
            return this.createBeanProxyWith(new int[1]);
        }
        IBeanTypeProxy compType = null;
        int numDims = this.getDimensions();
        if (numDims <= dimensions.length) {
            compType = this.getFinalComponentType();
        } else {
            String compClass = this.getTypeName().substring(dimensions.length);
            compType = this.fRegistry.getBeanTypeProxyFactory().getBeanTypeProxy(compClass);
        }
        if (dimensions.length == 1) {
            parms = new Object[]{compType, new Integer(dimensions[0])};
            return (REMArrayBeanProxy)((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fRegistry).getArrayNewInstanceOneDimension()).invokeWithParms(null, parms);
        }
        parms = new Object[]{compType, dimensions};
        return (REMArrayBeanProxy)((IREMMethodProxy)REMStandardBeanProxyConstants.getConstants(this.fRegistry).getArrayNewInstanceMultiDimension()).invokeWithParms(null, parms);
    }

    @Override
    public String getFormalTypeName() {
        String name = this.getTypeName();
        int dims = name.lastIndexOf(91) + 1;
        String type = this.getFinalComponentType().getTypeName();
        StringBuffer formalType = new StringBuffer(type.length() + "[]".length() * dims);
        formalType.append(type);
        int i = 0;
        while (i < dims) {
            formalType.append("[]");
            ++i;
        }
        return formalType.toString();
    }

    @Override
    public IConstructorProxy getCompatibleConstructor(IBeanTypeProxy[] argumentTypes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IMethodProxy getCompatibleMethod(String methodName, IBeanTypeProxy[] argumentTypes) {
        throw new UnsupportedOperationException();
    }
}

