/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.predicate.int_;

import java.util.Arrays;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.StringBuilderTools;
import org.eclipse.jpt.common.utility.predicate.CompoundIntPredicate;
import org.eclipse.jpt.common.utility.predicate.IntPredicate;

public abstract class AbstractCompoundIntPredicate
implements CompoundIntPredicate {
    protected final IntPredicate[] predicates;

    @SafeVarargs
    protected AbstractCompoundIntPredicate(IntPredicate ... predicates) {
        if (ArrayTools.isOrContainsNull(predicates)) {
            throw new NullPointerException();
        }
        this.predicates = predicates;
    }

    @Override
    public IntPredicate[] getPredicates() {
        return this.predicates;
    }

    public boolean equals(Object o) {
        if (o.getClass() != this.getClass()) {
            return false;
        }
        AbstractCompoundIntPredicate other = (AbstractCompoundIntPredicate)o;
        return Arrays.equals(this.predicates, other.predicates);
    }

    public int hashCode() {
        return Arrays.hashCode(this.predicates);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.appendHashCodeToString(sb, this);
        sb.append('(');
        if (this.predicates.length > 0) {
            String operatorString = this.operatorString();
            IntPredicate[] intPredicateArray = this.predicates;
            int n = this.predicates.length;
            int n2 = 0;
            while (n2 < n) {
                IntPredicate predicate = intPredicateArray[n2];
                sb.append(predicate);
                sb.append(' ');
                sb.append(operatorString);
                sb.append(' ');
                ++n2;
            }
            sb.setLength(sb.length() - operatorString.length() - 2);
        }
        sb.append(')');
        return sb.toString();
    }

    protected abstract String operatorString();
}

