/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.internal.contentoutline;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.ui.internal.contentoutline.IJFaceNodeAdapter;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.ui.internal.editor.CMImageUtil;
import org.eclipse.wst.xml.ui.internal.editor.XMLEditorPluginImageHelper;
import org.eclipse.wst.xsl.ui.internal.contentoutline.JFaceNodeAdapterFactory;
import org.eclipse.wst.xsl.ui.internal.contentoutline.RefreshStructureJob;
import org.eclipse.wst.xsl.ui.internal.util.XSLPluginImageHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JFaceNodeAdapter
implements IJFaceNodeAdapter {
    static final Class ADAPTER_KEY = IJFaceNodeAdapter.class;
    JFaceNodeAdapterFactory fAdapterFactory;
    RefreshStructureJob fRefreshJob = null;

    public JFaceNodeAdapter(JFaceNodeAdapterFactory adapterFactory) {
        this.fAdapterFactory = adapterFactory;
    }

    protected ImageDescriptor getXSLImage(Element node) {
        return XSLPluginImageHelper.getInstance().getImageDescriptor(this.getImagePath(node));
    }

    protected ImageDescriptor getImageDescriptor(String path) {
        return XSLPluginImageHelper.getInstance().getImageDescriptor(path);
    }

    protected String getImagePath(Element node) {
        String name = node.getLocalName();
        if (name.equals("import") || name.equals("include")) {
            return "icons/full/import.gif";
        }
        if (name.equals("template")) {
            if (node.hasAttribute("name")) {
                return "icons/full/templatenamed_obj.gif";
            }
            return "icons/full/package_obj.gif";
        }
        if (name.equals("variable") || name.equals("param")) {
            return "icons/full/field_default_obj.gif";
        }
        if (name.equals("function")) {
            return "icons/full/function.gif";
        }
        return "icons/full/xslt_launch.gif";
    }

    protected Image createImage(Object object) {
        Image image = null;
        Node node = (Node)object;
        switch (node.getNodeType()) {
            case 1: {
                if ("http://www.w3.org/1999/XSL/Transform".equals(node.getNamespaceURI())) {
                    Element elem = (Element)node;
                    String path = this.getImagePath(elem);
                    ImageDescriptor imgDesc = this.getImageDescriptor(path);
                    if (imgDesc == null) {
                        image = this.createXMLImageDescriptor("icons/full/obj16/element_obj.gif");
                        break;
                    }
                    image = XSLPluginImageHelper.getInstance().getImage(path);
                    break;
                }
                image = this.createXMLImageDescriptor("icons/full/obj16/element_obj.gif");
                break;
            }
            case 2: {
                image = this.createXMLImageDescriptor("icons/full/obj16/attribute_obj.gif");
                break;
            }
            case 3: {
                image = this.createXMLImageDescriptor("icons/full/obj16/text.gif");
                break;
            }
            case 4: {
                image = this.createXMLImageDescriptor("icons/full/obj16/cdatasection.gif");
                break;
            }
            case 5: 
            case 6: {
                image = this.createXMLImageDescriptor("icons/full/obj16/entity.gif");
                break;
            }
            case 7: {
                image = this.createXMLImageDescriptor("icons/full/obj16/proinst_obj.gif");
                break;
            }
            case 8: {
                image = this.createXMLImageDescriptor("icons/full/obj16/comment_obj.gif");
                break;
            }
            case 10: {
                image = this.createXMLImageDescriptor("icons/full/obj16/doctype.gif");
                break;
            }
            case 12: {
                image = this.createXMLImageDescriptor("icons/full/obj16/notation.gif");
                break;
            }
            default: {
                image = this.createXMLImageDescriptor("icons/full/obj16/text.gif");
            }
        }
        return image;
    }

    protected Image createXMLImageDescriptor(String imageResourceName) {
        return XMLEditorPluginImageHelper.getInstance().getImage(imageResourceName);
    }

    public Object[] getChildren(Object object) {
        ArrayList<Node> v = new ArrayList<Node>();
        if (object instanceof Node) {
            Node node = (Node)object;
            Node child = node.getFirstChild();
            while (child != null) {
                Node n = child;
                if (n.getNodeType() != 3 && n.getNodeType() != 8) {
                    v.add(n);
                }
                child = child.getNextSibling();
            }
        }
        return v.toArray();
    }

    public Object[] getElements(Object node) {
        return this.getChildren(node);
    }

    public Image getLabelImage(Object node) {
        Image image = null;
        if (node instanceof Node && (image = CMImageUtil.getImage((CMNode)CMImageUtil.getDeclaration((Node)((Node)node)))) == null) {
            image = this.createImage(node);
        }
        return image;
    }

    public String getLabelText(Object node) {
        return this.getNodeName(node);
    }

    private String getNodeName(Object object) {
        StringBuffer nodeName = new StringBuffer();
        if (!(object instanceof Node)) {
            return nodeName.toString();
        }
        Node node = (Node)object;
        if (node.getNodeType() != 1) {
            nodeName.append(node.getNodeName());
            if (node.getNodeType() == 10) {
                nodeName.insert(0, "DOCTYPE:");
            }
            return nodeName.toString();
        }
        if ("http://www.w3.org/1999/XSL/Transform".equals(node.getNamespaceURI())) {
            Element elem = (Element)node;
            nodeName.append(elem.getLocalName());
        } else {
            nodeName.append(node.getNodeName());
        }
        return nodeName.toString();
    }

    public Object getParent(Object object) {
        if (object instanceof Node) {
            Node node = (Node)object;
            return node.getParentNode();
        }
        return null;
    }

    private synchronized RefreshStructureJob getRefreshJob() {
        if (this.fRefreshJob == null) {
            this.fRefreshJob = new RefreshStructureJob();
        }
        return this.fRefreshJob;
    }

    public boolean hasChildren(Object object) {
        Node node = (Node)object;
        Node child = node.getFirstChild();
        while (child != null) {
            if (child.getNodeType() != 3) {
                return true;
            }
            child = child.getNextSibling();
        }
        return false;
    }

    public boolean isAdapterForType(Object type) {
        if (type == null) {
            return false;
        }
        return type.equals(ADAPTER_KEY);
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (notifier instanceof Node) {
            Collection listeners = this.fAdapterFactory.getListeners();
            for (Object listener : listeners) {
                StructuredViewer structuredViewer;
                if (!(listener instanceof StructuredViewer) || eventType != 4 && eventType != 5 && eventType != 1 || (structuredViewer = (StructuredViewer)listener).getControl() == null) continue;
                this.getRefreshJob().refresh(structuredViewer, (Node)notifier);
            }
        }
    }
}

