/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import junit.framework.Test;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaModelTests;

public class ResolveTests
extends AbstractJavaModelTests {
    IJavaScriptUnit wc = null;
    WorkingCopyOwner owner = null;

    public static Test suite() {
        return ResolveTests.buildModelTestSuite(ResolveTests.class);
    }

    public ResolveTests(String name) {
        super(name);
    }

    @Override
    public IJavaScriptUnit getWorkingCopy(String path, String source) throws JavaScriptModelException {
        return super.getWorkingCopy(path, source, this.owner, null);
    }

    private IJavaScriptElement[] select(String path, String source, String selection) throws JavaScriptModelException {
        this.wc = this.getWorkingCopy(path, source);
        String str = this.wc.getSource();
        int start = str.lastIndexOf(selection);
        int length = selection.length();
        return this.wc.codeSelect(start, length, this.owner);
    }

    @Override
    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.setUpJavaProject("Resolve");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.owner = new WorkingCopyOwner(){};
    }

    @Override
    public void tearDownSuite() throws Exception {
        this.deleteProject("Resolve");
        super.tearDownSuite();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.wc != null) {
            this.wc.discardWorkingCopy();
        }
        super.tearDown();
    }

    public void testAmbiguousMethod1() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/Resolve/src/test/Test.java", "package test;\npublic class Test {\n  void foo(Test1 t) {}\n  void foo(Test2 t) {}\n  void bar(Object o) {\n    foo(o);\n  }\n}\nclass Test1 {\n}\nclass Test2 {\n}");
        String str = this.workingCopies[0].getSource();
        int start = str.lastIndexOf("foo(o)");
        int length = "foo".length();
        IJavaScriptElement[] elements = this.workingCopies[0].codeSelect(start, length, this.wcOwner);
        this.assertElementsEqual("Unexpected elements", "foo(Test1) [in Test [in [Working copy] Test.java [in test [in src [in Resolve]]]]]", elements);
    }

    public void testArgumentName1() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit("Resolve", "src", "", "ResolveArgumentName.js");
        IJavaScriptElement[] elements = this.codeSelect((ISourceReference)cu, "var1", "var1");
        this.assertElementsEqual("Unexpected elements", "var1 [in foo(p0, p1) [in ResolveArgumentName.js [in <default> [in src [in Resolve]]]]]", elements);
    }

    public void testArgumentName2() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit("Resolve", "src", "", "ResolveArgumentName.js");
        IJavaScriptElement[] elements = this.codeSelect((ISourceReference)cu, "var2", "var2");
        this.assertElementsEqual("Unexpected elements", "var2 [in foo(p0, p1) [in ResolveArgumentName.js [in <default> [in src [in Resolve]]]]]", elements);
    }

    public void testArrayLength() throws JavaScriptModelException {
        ResolveTests.assertTrue((String)"implement?", (boolean)false);
    }

    public void testCatchArgumentName1() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit("Resolve", "src", "", "ResolveCatchArgumentName.js");
        IJavaScriptElement[] elements = this.codeSelect((ISourceReference)cu, "var1", "var1");
        this.assertElementsEqual("Unexpected elements", "var1 [in foo() [in ResolveCatchArgumentName.js [in <default> [in src [in Resolve]]]]]", elements);
    }

    public void testCatchArgumentName2() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit("Resolve", "src", "", "ResolveCatchArgumentName.js");
        IJavaScriptElement[] elements = this.codeSelect((ISourceReference)cu, "var2", "var2");
        this.assertElementsEqual("Unexpected elements", "var2 [in foo() [in ResolveCatchArgumentName.js [in <default> [in src [in Resolve]]]]]", elements);
    }

    public void testClass1() throws JavaScriptModelException {
        ResolveTests.assertTrue((String)"implement?", (boolean)false);
    }

    public void testClass2() throws JavaScriptModelException {
        ResolveTests.assertTrue((String)"implement?", (boolean)false);
    }

    public void testClass3() throws JavaScriptModelException {
        ResolveTests.assertTrue((String)"implement?", (boolean)false);
    }

    public void testClass4() throws JavaScriptModelException {
        ResolveTests.assertTrue((String)"implement?", (boolean)false);
    }

    public void testClass5() throws JavaScriptModelException {
        ResolveTests.assertTrue((String)"implement?", (boolean)false);
    }

    public void testConstructor() throws JavaScriptModelException {
        ResolveTests.assertTrue((String)"implement?", (boolean)false);
    }

    public void testConstructorDeclaration() throws JavaScriptModelException {
        ResolveTests.assertTrue((String)"implement?", (boolean)false);
    }

    public void testEmptySelectionOnMethod() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit("Resolve", "src", "", "ResolveEmptySelectionOnMethod.js");
        IJavaScriptElement[] elements = this.codeSelect((ISourceReference)cu, "oo();", "");
        this.assertElementsEqual("Unexpected elements", "foo() [in ResolveEmptySelectionOnMethod.js [in <default> [in src [in Resolve]]]]", elements);
    }

    public void testField() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit("Resolve", "src", "", "ResolveField.js");
        IJavaScriptElement[] elements = this.codeSelect((ISourceReference)cu, "foo =", "foo");
        this.assertElementsEqual("Unexpected elements", "foo [in ResolveField.js [in <default> [in src [in Resolve]]]]", elements);
    }

    public void testField0() throws JavaScriptModelException {
        ResolveTests.assertTrue((String)"implement", (boolean)false);
    }

    public void testFieldDeclaration() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit("Resolve", "src", "", "ResolveFieldDeclaration.js");
        IJavaScriptElement[] elements = this.codeSelect((ISourceReference)cu, "foo", "foo");
        this.assertElementsEqual("Unexpected elements", "foo [in ResolveFieldDeclaration.js [in <default> [in src [in Resolve]]]]", elements);
    }

    public void testInvalidResolve() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit("Resolve", "src", "p1", "X.js");
        try {
            cu.codeSelect(-1, 10);
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return;
        }
        ResolveTests.assertTrue((String)"Exception should have been thrown for out of bounds resolution", (boolean)false);
    }

    public void testLocalName1() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit("Resolve", "src", "", "ResolveLocalName.js");
        IJavaScriptElement[] elements = this.codeSelect((ISourceReference)cu, "var1 = new Object();", "var1");
        this.assertElementsEqual("Unexpected elements", "var1 [in foo() [in ResolveLocalName.js [in <default> [in src [in Resolve]]]]]", elements);
    }

    public void testLocalName2() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit("Resolve", "src", "", "ResolveLocalName.js");
        IJavaScriptElement[] elements = this.codeSelect((ISourceReference)cu, "var2 = 1;", "var2");
        this.assertElementsEqual("Unexpected elements", "var2 [in foo() [in ResolveLocalName.js [in <default> [in src [in Resolve]]]]]", elements);
    }

    public void testLocalName3() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit("Resolve", "src", "", "ResolveLocalName.js");
        IJavaScriptElement[] elements = this.codeSelect((ISourceReference)cu, "var1.toString();", "var1");
        this.assertElementsEqual("Unexpected elements", "var1 [in foo() [in ResolveLocalName.js [in <default> [in src [in Resolve]]]]]", elements);
    }

    public void testLocalName4() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit("Resolve", "src", "", "ResolveLocalName.js");
        IJavaScriptElement[] elements = this.codeSelect((ISourceReference)cu, "var2++;", "var2");
        this.assertElementsEqual("Unexpected elements", "var2 [in foo() [in ResolveLocalName.js [in <default> [in src [in Resolve]]]]]", elements);
    }

    public void testLocalName5() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit("Resolve", "src", "", "ResolveLocalName.js");
        IJavaScriptElement[] elements = this.codeSelect((ISourceReference)cu, "var3.hashCode();", "var3");
        this.assertElementsEqual("Unexpected elements", "var3 [in foo() [in ResolveLocalName.js [in <default> [in src [in Resolve]]]]]", elements);
    }

    public void testLocalName6() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit("Resolve", "src", "", "ResolveLocalName.js");
        IJavaScriptElement[] elements = this.codeSelect((ISourceReference)cu, "var3.toString();", "var3");
        this.assertElementsEqual("Unexpected elements", "var3 [in foo() [in ResolveLocalName.js [in <default> [in src [in Resolve]]]]]", elements);
    }

    public void testLocalName7() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit("Resolve", "src", "", "ResolveLocalName.js");
        IJavaScriptElement[] elements = this.codeSelect((ISourceReference)cu, "var4;", "var4");
        this.assertElementsEqual("Unexpected elements", "var4 [in foo() [in ResolveLocalName.js [in <default> [in src [in Resolve]]]]]", elements);
    }

    public void testLocalVarIsStructureKnown() throws JavaScriptModelException {
        ILocalVariable localVar = this.getLocalVariable("/Resolve/src/ResolveLocalName.js", "var1 = new Object();", "var1");
        ResolveTests.assertTrue((boolean)localVar.isStructureKnown());
    }

    public void testLocalVarTypeSignature1() throws JavaScriptModelException {
        ILocalVariable localVar = this.getLocalVariable("/Resolve/src/ResolveLocalName.js", "var1 = new Object();", "var1");
        ResolveTests.assertEquals((String)"Unexpected type signature", (String)"QObject;", (String)localVar.getTypeSignature());
    }

    public void testLocalVarTypeSignature2() throws JavaScriptModelException {
        ILocalVariable localVar = this.getLocalVariable("/Resolve/src/ResolveLocalName.js", "var2 = 1;", "var2");
        ResolveTests.assertEquals((String)"Unexpected type signature", (String)"I", (String)localVar.getTypeSignature());
    }

    public void testMessageSendOnBaseType() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit("Resolve", "src", "", "ResolveMessageSendOnBaseType.js");
        IJavaScriptElement[] elements = this.codeSelect((ISourceReference)cu, "hello", "hello");
        this.assertElementsEqual("Unexpected elements", "", elements);
    }

    public void testMethod() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit("Resolve", "src", "", "ResolveMethod.js");
        IJavaScriptElement[] elements = this.codeSelect((ISourceReference)cu, "foo(\"", "foo");
        this.assertElementsEqual("Unexpected elements", "foo(p0) [in ResolveMethod.js [in <default> [in src [in Resolve]]]]", elements);
    }

    public void testMethodDeclaration() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit("Resolve", "src", "", "ResolveMethodDeclaration.js");
        IJavaScriptElement[] elements = this.codeSelect((ISourceReference)cu, "foo(i", "foo");
        this.assertElementsEqual("Unexpected elements", "foo(p0) [in ResolveMethodDeclaration.js [in <default> [in src [in Resolve]]]]", elements);
    }

    public void testMethodWithIncorrectParameter() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit("Resolve", "src", "", "ResolveMethodWithIncorrectParameter.js");
        IJavaScriptElement[] elements = this.codeSelect((ISourceReference)cu, "foo(\"String", "foo");
        this.assertElementsEqual("Unexpected elements", "foo(p0) [in ResolveMethodWithIncorrectParameter.js [in <default> [in src [in Resolve]]]]", elements);
    }

    public void testMethodWithIncorrectParameter2() throws JavaScriptModelException {
        ResolveTests.assertTrue((String)"implement", (boolean)false);
    }

    public void testNegativeResolveUnicode() throws JavaScriptModelException {
        ResolveTests.assertTrue((String)"implement", (boolean)false);
    }

    public void testPartiallyQualifiedType() throws JavaScriptModelException {
        ResolveTests.assertTrue((String)"implement", (boolean)false);
    }

    public void testTypeDeclaration() throws JavaScriptModelException {
        ResolveTests.assertTrue((String)"implement", (boolean)false);
    }

    public void testTypeInComment() throws JavaScriptModelException {
        ResolveTests.assertTrue((String)"implement", (boolean)false);
    }

    public void testUnicode() throws JavaScriptModelException {
        ResolveTests.assertTrue((String)"implement", (boolean)false);
    }

    public void testDuplicateLocals1() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[2];
        this.workingCopies[0] = this.getWorkingCopy("/Resolve/src/test/Test.java", "package test;public class Test {\n\tvoid foo() {\n\t\tint x = 0;\n\t\tTestString x = null;\n\t\tx.bar;\n\t}\n}");
        this.workingCopies[1] = this.getWorkingCopy("/Resolve/src/test/TestString.java", "package test;public class TestString {\n\tpublic void bar() {\n\t}\n}");
        String str = this.workingCopies[0].getSource();
        int start = str.lastIndexOf("x");
        int length = "x".length();
        IJavaScriptElement[] elements = this.workingCopies[0].codeSelect(start, length, this.wcOwner);
        this.assertElementsEqual("Unexpected elements", "x [in foo() [in Test [in [Working copy] Test.java [in test [in src [in Resolve]]]]]]", elements);
        ResolveTests.assertEquals((String)"Unexpected type", (String)"QTestString;", (String)((ILocalVariable)elements[0]).getTypeSignature());
    }

    public void testDuplicateLocals2() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[2];
        this.workingCopies[0] = this.getWorkingCopy("/Resolve/src/test/Test.java", "package test;public class Test {\n        public static void main(String[] args) {\n                int x = 2;\n                try {\n                \n                } catch(TestException x) {\n                        x.bar();\n                } catch(Exception e) {\n                }\n        }\n}");
        this.workingCopies[1] = this.getWorkingCopy("/Resolve/src/test/TestException.java", "package test;public class TestException extends Exception {\n\tpublic void bar() {\n\t}\n}");
        String str = this.workingCopies[0].getSource();
        int start = str.lastIndexOf("x.");
        int length = "x".length();
        IJavaScriptElement[] elements = this.workingCopies[0].codeSelect(start, length, this.wcOwner);
        this.assertElementsEqual("Unexpected elements", "x [in main(String[]) [in Test [in [Working copy] Test.java [in test [in src [in Resolve]]]]]]", elements);
        ResolveTests.assertEquals((String)"Unexpected type", (String)"QTestException;", (String)((ILocalVariable)elements[0]).getTypeSignature());
    }

    public void testDuplicateLocals3() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[2];
        this.workingCopies[0] = this.getWorkingCopy("/Resolve/src/test/Test.java", "package test;public class Test {\n        public static void main(String[] args) {\n                int x = x = 0;\n                if (true) {\n                        TestString x = x = null;\n                }\n        }\n}");
        this.workingCopies[1] = this.getWorkingCopy("/Resolve/src/test/TestString.java", "package test;public class TestString {\n\tpublic void bar() {\n\t}\n}");
        String str = this.workingCopies[0].getSource();
        int start = str.lastIndexOf("x");
        int length = "x".length();
        IJavaScriptElement[] elements = this.workingCopies[0].codeSelect(start, length, this.wcOwner);
        this.assertElementsEqual("Unexpected elements", "x [in main(String[]) [in Test [in [Working copy] Test.java [in test [in src [in Resolve]]]]]]", elements);
        ResolveTests.assertEquals((String)"Unexpected type", (String)"QTestString;", (String)((ILocalVariable)elements[0]).getTypeSignature());
    }

    public void testDuplicateLocals4() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[2];
        this.workingCopies[0] = this.getWorkingCopy("/Resolve/src/test/Test.java", "package test;public class Test {\n        public static void main(String[] args) {\n                for (int x = 0; x < 10; x++) {\n                        for (TestString x = null; x.bar() < 5;)  {\n                                // do something\n                        }\n                }\n        }\n}");
        this.workingCopies[1] = this.getWorkingCopy("/Resolve/src/test/TestString.java", "package test;public class TestString {\n\tpublic int bar() {\n\t\treturn 0;\n\t}\n}");
        String str = this.workingCopies[0].getSource();
        int start = str.lastIndexOf("x");
        int length = "x".length();
        IJavaScriptElement[] elements = this.workingCopies[0].codeSelect(start, length, this.wcOwner);
        this.assertElementsEqual("Unexpected elements", "x [in main(String[]) [in Test [in [Working copy] Test.java [in test [in src [in Resolve]]]]]]", elements);
        ResolveTests.assertEquals((String)"Unexpected type", (String)"QTestString;", (String)((ILocalVariable)elements[0]).getTypeSignature());
    }

    public void testDuplicateLocals5() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[2];
        this.workingCopies[0] = this.getWorkingCopy("/Resolve/src/test/Test.java", "package test;public class Test {\n        public static void main(String[] args) {\n                for (int x = 0; x < 10; x++) {\n                        for (TestString x = null; x.bar() < 5;)  {\n                                x.bar(); // do something\n                        }\n                }\n        }\n}");
        this.workingCopies[1] = this.getWorkingCopy("/Resolve/src/test/TestString.java", "package test;public class TestString {\n\tpublic int bar() {\n\t\treturn 0;\n\t}\n}");
        String str = this.workingCopies[0].getSource();
        int start = str.lastIndexOf("x");
        int length = "x".length();
        IJavaScriptElement[] elements = this.workingCopies[0].codeSelect(start, length, this.wcOwner);
        this.assertElementsEqual("Unexpected elements", "x [in main(String[]) [in Test [in [Working copy] Test.java [in test [in src [in Resolve]]]]]]", elements);
        ResolveTests.assertEquals((String)"Unexpected type", (String)"QTestString;", (String)((ILocalVariable)elements[0]).getTypeSignature());
    }

    public void testDuplicateLocalsType1() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[2];
        this.workingCopies[0] = this.getWorkingCopy("/Resolve/src/test/Test.java", "package test;public class Test {\n  void foo() {\n     class Local {\n        public void foo() {}\n     }\n     {\n        class Local {\n                Local(int i) {\n                        this.init(i);\n                }\n\t\t\t\t void init(int i) {}\n                public void bar() {}\n        }\n        Local l = new Local(0);\n        l.bar();\n     }\n  }\n}");
        this.workingCopies[1] = this.getWorkingCopy("/Resolve/src/test/TestString.java", "package test;public class TestString {\n\tpublic int bar() {\n\t\treturn 0;\n\t}\n}");
        String str = this.workingCopies[0].getSource();
        int start = str.lastIndexOf("bar");
        int length = "bar".length();
        IJavaScriptElement[] elements = this.workingCopies[0].codeSelect(start, length, this.wcOwner);
        this.assertElementsEqual("Unexpected elements", "bar() [in Local#2 [in foo() [in Test [in [Working copy] Test.java [in test [in src [in Resolve]]]]]]]", elements);
    }

    public void testDuplicateLocalsType2() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[2];
        this.workingCopies[0] = this.getWorkingCopy("/Resolve/src/test/Test.java", "package test;public class Test {\n        void foo() {\n                class Local {\n                        void foo() {\n                        }\n                }\n                {\n                        class Local {\n                               Local(int i) {\n                                       this.init(i);\n                                       this.bar();\n                               }\n\t\t\t\t \t\t\t\tvoid init(int i) {}\n                        \t\tvoid bar() {\n                        \t\t}\n                        }\n                        Local l = new Local(0);\n                }\n                Local l = new Local();\n                l.foo();\n        }\n}");
        this.workingCopies[1] = this.getWorkingCopy("/Resolve/src/test/TestString.java", "package test;public class TestString {\n\tpublic int bar() {\n\t\treturn 0;\n\t}\n}");
        String str = this.workingCopies[0].getSource();
        int start = str.lastIndexOf("foo");
        int length = "foo".length();
        IJavaScriptElement[] elements = this.workingCopies[0].codeSelect(start, length, this.wcOwner);
        this.assertElementsEqual("Unexpected elements", "foo() [in Local [in foo() [in Test [in [Working copy] Test.java [in test [in src [in Resolve]]]]]]]", elements);
    }

    public void testEndOfFile() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit("Resolve", "src", "", "ResolveEndOfFile.js");
        IJavaScriptElement[] elements = this.codeSelectAt((ISourceReference)cu, "zzz");
        this.assertElementsEqual("Unexpected elements", "", elements);
    }

    public void testDuplicateMethodDeclaration() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit("Resolve", "src", "", "ResolveDuplicateMethodDeclaration.js");
        String str = cu.getSource();
        int start = str.indexOf("foo");
        int length = "foo".length();
        IJavaScriptElement[] elements = cu.codeSelect(start, length);
        this.assertElementsEqual("Unexpected elements", "foo() [in ResolveDuplicateMethodDeclaration.js [in <default> [in src [in Resolve]]]]", elements);
    }

    public void testDuplicateMethodDeclaration2() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit("Resolve", "src", "", "ResolveDuplicateMethodDeclaration.js");
        String str = cu.getSource();
        int start = str.lastIndexOf("foo");
        int length = "foo".length();
        IJavaScriptElement[] elements = cu.codeSelect(start, length);
        this.assertElementsEqual("Unexpected elements", "foo()#2 [in ResolveDuplicateMethodDeclaration.js [in <default> [in src [in Resolve]]]]", elements);
    }

    public void testDuplicateMethodDeclaration3() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit("Resolve", "src", "", "ResolveDuplicateMethodDeclaration3.js");
        String str = cu.getSource();
        int start = str.indexOf("foo");
        int length = "foo".length();
        IJavaScriptElement[] elements = cu.codeSelect(start, length);
        this.assertElementsEqual("Unexpected elements", "foo(p0) [in ResolveDuplicateMethodDeclaration3.js [in <default> [in src [in Resolve]]]]", elements);
    }

    public void testDuplicateMethodDeclaration4() throws JavaScriptModelException {
        IJavaScriptUnit cu = this.getCompilationUnit("Resolve", "src", "", "ResolveDuplicateMethodDeclaration3.js");
        String str = cu.getSource();
        int start = str.lastIndexOf("foo");
        int length = "foo".length();
        IJavaScriptElement[] elements = cu.codeSelect(start, length);
        this.assertElementsEqual("Unexpected elements", "foo(p0)#2 [in ResolveDuplicateMethodDeclaration3.js [in <default> [in src [in Resolve]]]]", elements);
    }

    public void testDuplicateFieldDeclaration() throws JavaScriptModelException {
        ResolveTests.assertTrue((String)"implement", (boolean)false);
    }

    public void testDuplicateFieldDeclaration2() throws JavaScriptModelException {
        ResolveTests.assertTrue((String)"implement", (boolean)false);
    }

    public void testLocalVariable() throws JavaScriptModelException {
        ResolveTests.assertTrue((String)"implement", (boolean)false);
    }
}

