/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.protocolparser.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.wst.jsdt.chromium.internal.JsonUtil;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonNullable;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonOptionalField;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonParseMethod;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonParserRoot;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolModelParseException;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonType;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.DynamicParserImpl;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class FieldTypesTest {
    @Test
    public void testNullLongValue() throws JsonProtocolModelParseException, JsonProtocolParseException {
        TypeWithNullableLongParser parser = FieldTypesTest.createDynamicParser(TypeWithNullableLongParser.class, TypeWithNullableLong.class);
        JSONObject json = this.parseJson("{'val': 2 }");
        TypeWithNullableLong val = parser.parseTypeWithNullableLong(json);
        Assert.assertEquals((Object)2L, (Object)val.val());
        json = this.parseJson("{'val': null }");
        val = parser.parseTypeWithNullableLong(json);
        Assert.assertNull((Object)val.val());
    }

    @Test
    public void testBrokenLongValue() throws JsonProtocolModelParseException, JsonProtocolParseException {
        TypeWithLongParser parser = FieldTypesTest.createDynamicParser(TypeWithLongParser.class, TypeWithLong.class);
        JSONObject json = this.parseJson("{'val': 2 }");
        TypeWithLong val = parser.parseTypeWithLong(json);
        Assert.assertEquals((long)2L, (long)val.val());
        try {
            json = this.parseJson("{'val': null }");
            val = parser.parseTypeWithLong(json);
            val.val();
            Assert.fail();
        }
        catch (Exception exception) {}
    }

    @Test
    public void testNullStructValue() throws JsonProtocolModelParseException, JsonProtocolParseException {
        TypeWithNullableSomethingParser parser = FieldTypesTest.createDynamicParser(TypeWithNullableSomethingParser.class, Something.class, TypeWithNullableSomething.class);
        JSONObject json = this.parseJson("{'data': {} }");
        TypeWithNullableSomething val = parser.parseTypeWithNullableSomething(json);
        Assert.assertNotNull((Object)val.data());
        json = this.parseJson("{'data': null }");
        val = parser.parseTypeWithNullableSomething(json);
        Assert.assertNull((Object)val.data());
    }

    @Test
    public void testBrokenNullStructValue() throws JsonProtocolModelParseException, JsonProtocolParseException {
        TypeWithSomethingParser parser = FieldTypesTest.createDynamicParser(TypeWithSomethingParser.class, Something.class, TypeWithSomething.class);
        JSONObject json = this.parseJson("{'data': {} }");
        TypeWithSomething val = parser.parseTypeWithSomething(json);
        Assert.assertNotNull((Object)val.data());
        json = this.parseJson("{'data': null }");
        try {
            parser.parseTypeWithSomething(json);
            Assert.fail();
        }
        catch (Exception exception) {}
    }

    @Test
    public void testNonoptionalFields() throws JsonProtocolModelParseException, JsonProtocolParseException {
        ArrayList types = new ArrayList(3);
        types.add(TypeWithNullableLong.class);
        types.add(TypeWithSomething.class);
        types.add(Something.class);
        SeveralTypesWithSomethingParser parser = FieldTypesTest.createDynamicParser(SeveralTypesWithSomethingParser.class, types);
        JSONObject json = this.parseJson("{'val': null}");
        Object val = parser.parseTypeWithNullableLong(json);
        Assert.assertNull((Object)val.val());
        json = this.parseJson("{'data': {} }");
        val = parser.parseTypeWithSomething(json);
        Assert.assertNotNull((Object)val.data());
        JSONObject emptyJson = this.parseJson("{}");
        try {
            val = parser.parseTypeWithNullableLong(emptyJson);
            val.val();
            Assert.fail();
        }
        catch (Exception exception) {}
        try {
            parser.parseTypeWithSomething(emptyJson);
            Assert.fail();
        }
        catch (Exception exception) {}
    }

    @Test
    public void testOptionalFields() throws JsonProtocolModelParseException, JsonProtocolParseException {
        ArrayList types = new ArrayList(3);
        types.add(TypeWithOptionalLong.class);
        types.add(TypeWithOptionalSomething.class);
        types.add(Something.class);
        SeveralTypesWithLongParser parser = FieldTypesTest.createDynamicParser(SeveralTypesWithLongParser.class, types);
        JSONObject emptyJson = this.parseJson("{}");
        Object val = parser.parseTypeWithOptionalLong(emptyJson);
        Long l = val.val();
        Assert.assertNull((Object)l);
        val = parser.parseTypeWithOptionalSomething(emptyJson);
        Something something = val.data();
        Assert.assertNull((Object)something);
    }

    private JSONObject parseJson(String semiJson) {
        JSONObject json;
        String jsonString = semiJson.replace('\'', '\"');
        try {
            json = JsonUtil.jsonObjectFromJson((String)jsonString);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return json;
    }

    private static <ROOT> ROOT createDynamicParser(Class<ROOT> rootType, Class<?> oneType) throws JsonProtocolModelParseException {
        return FieldTypesTest.createDynamicParser(rootType, Collections.singletonList(oneType));
    }

    private static <ROOT> ROOT createDynamicParser(Class<ROOT> rootType, Class<?> firstType, Class<?> secondType) throws JsonProtocolModelParseException {
        ArrayList list = new ArrayList(2);
        list.add(firstType);
        list.add(secondType);
        return FieldTypesTest.createDynamicParser(rootType, list);
    }

    private static <ROOT> ROOT createDynamicParser(Class<ROOT> rootType, List<Class<?>> protocolInterfaces) throws JsonProtocolModelParseException {
        DynamicParserImpl parser = new DynamicParserImpl(rootType, protocolInterfaces);
        return (ROOT)parser.getParserRoot();
    }

    @JsonParserRoot
    static interface SeveralTypesWithLongParser {
        @JsonParseMethod
        public TypeWithOptionalLong parseTypeWithOptionalLong(JSONObject var1) throws JsonProtocolParseException;

        @JsonParseMethod
        public TypeWithOptionalSomething parseTypeWithOptionalSomething(JSONObject var1) throws JsonProtocolParseException;
    }

    @JsonParserRoot
    static interface SeveralTypesWithSomethingParser {
        @JsonParseMethod
        public TypeWithSomething parseTypeWithSomething(JSONObject var1) throws JsonProtocolParseException;

        @JsonParseMethod
        public TypeWithNullableLong parseTypeWithNullableLong(JSONObject var1) throws JsonProtocolParseException;
    }

    @JsonType
    static interface Something {
    }

    @JsonType
    static interface TypeWithLong {
        public long val();
    }

    @JsonParserRoot
    static interface TypeWithLongParser {
        @JsonParseMethod
        public TypeWithLong parseTypeWithLong(JSONObject var1) throws JsonProtocolParseException;
    }

    @JsonType
    static interface TypeWithNullableLong {
        public Long val();
    }

    @JsonParserRoot
    static interface TypeWithNullableLongParser {
        @JsonParseMethod
        public TypeWithNullableLong parseTypeWithNullableLong(JSONObject var1) throws JsonProtocolParseException;
    }

    @JsonType
    static interface TypeWithNullableSomething {
        @JsonNullable
        public Something data();
    }

    @JsonParserRoot
    static interface TypeWithNullableSomethingParser {
        @JsonParseMethod
        public TypeWithNullableSomething parseTypeWithNullableSomething(JSONObject var1) throws JsonProtocolParseException;
    }

    @JsonType
    static interface TypeWithOptionalLong {
        @JsonOptionalField
        public Long val();
    }

    @JsonType
    static interface TypeWithOptionalSomething {
        @JsonOptionalField
        public Something data();
    }

    @JsonType
    static interface TypeWithSomething {
        public Something data();
    }

    @JsonParserRoot
    static interface TypeWithSomethingParser {
        @JsonParseMethod
        public TypeWithSomething parseTypeWithSomething(JSONObject var1) throws JsonProtocolParseException;
    }
}

