/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.deque;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jpt.common.utility.deque.Deque;
import org.eclipse.jpt.common.utility.internal.collection.MapTools;
import org.eclipse.jpt.common.utility.internal.comparator.ComparatorTools;
import org.eclipse.jpt.common.utility.internal.deque.ArrayDeque;
import org.eclipse.jpt.common.utility.internal.deque.EmptyDeque;
import org.eclipse.jpt.common.utility.internal.deque.FixedCapacityArrayDeque;
import org.eclipse.jpt.common.utility.internal.deque.FixedCapacityPriorityDeque;
import org.eclipse.jpt.common.utility.internal.deque.LinkedDeque;
import org.eclipse.jpt.common.utility.internal.deque.ListDeque;
import org.eclipse.jpt.common.utility.internal.deque.PriorityDeque;
import org.eclipse.jpt.common.utility.internal.deque.ReverseDeque;
import org.eclipse.jpt.common.utility.internal.deque.SynchronizedDeque;
import org.eclipse.jpt.common.utility.queue.Queue;
import org.eclipse.jpt.common.utility.stack.Stack;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public final class DequeTools {
    public static <E> boolean enqueueTailAll(Deque<? super E> deque, Iterable<? extends E> iterable) {
        return DequeTools.enqueueTailAll(deque, iterable.iterator());
    }

    public static <E> boolean enqueueHeadAll(Deque<? super E> deque, Iterable<? extends E> iterable) {
        return DequeTools.enqueueHeadAll(deque, iterable.iterator());
    }

    public static <E> boolean enqueueTailAll(Deque<? super E> deque, Iterator<? extends E> iterator) {
        return iterator.hasNext() && DequeTools.enqueueTailAll_(deque, iterator);
    }

    private static <E> boolean enqueueTailAll_(Deque<? super E> deque, Iterator<? extends E> iterator) {
        do {
            deque.enqueueTail(iterator.next());
        } while (iterator.hasNext());
        return true;
    }

    public static <E> boolean enqueueHeadAll(Deque<? super E> deque, Iterator<? extends E> iterator) {
        return iterator.hasNext() && DequeTools.enqueueHeadAll_(deque, iterator);
    }

    private static <E> boolean enqueueHeadAll_(Deque<? super E> deque, Iterator<? extends E> iterator) {
        do {
            deque.enqueueHead(iterator.next());
        } while (iterator.hasNext());
        return true;
    }

    public static <E> boolean enqueueTailAll(Deque<? super E> deque, E ... array) {
        int len = array.length;
        return len != 0 && DequeTools.enqueueTailAll_(deque, array, len);
    }

    private static <E> boolean enqueueTailAll_(Deque<? super E> deque, E[] array, int arrayLength) {
        int i = 0;
        do {
            deque.enqueueTail(array[i++]);
        } while (i < arrayLength);
        return true;
    }

    public static <E> boolean enqueueHeadAll(Deque<? super E> deque, E ... array) {
        int len = array.length;
        return len != 0 && DequeTools.enqueueHeadAll_(deque, array, len);
    }

    private static <E> boolean enqueueHeadAll_(Deque<? super E> deque, E[] array, int arrayLength) {
        int i = 0;
        do {
            deque.enqueueHead(array[i++]);
        } while (i < arrayLength);
        return true;
    }

    public static <E> ArrayList<E> drainHead(Deque<? extends E> deque) {
        ArrayList result = new ArrayList();
        DequeTools.drainHeadTo(deque, result);
        return result;
    }

    public static <E> ArrayList<E> drainTail(Deque<? extends E> deque) {
        ArrayList result = new ArrayList();
        DequeTools.drainTailTo(deque, result);
        return result;
    }

    public static <E> boolean drainHeadTo(Deque<? extends E> deque, Collection<? super E> collection) {
        return !deque.isEmpty() && DequeTools.drainHeadTo_(deque, collection);
    }

    private static <E> boolean drainHeadTo_(Deque<? extends E> deque, Collection<? super E> collection) {
        do {
            collection.add(deque.dequeueHead());
        } while (!deque.isEmpty());
        return true;
    }

    public static <E> boolean drainTailTo(Deque<? extends E> deque, Collection<? super E> collection) {
        return !deque.isEmpty() && DequeTools.drainTailTo_(deque, collection);
    }

    private static <E> boolean drainTailTo_(Deque<? extends E> deque, Collection<? super E> collection) {
        do {
            collection.add(deque.dequeueTail());
        } while (!deque.isEmpty());
        return true;
    }

    public static <E> boolean drainHeadTo(Deque<? extends E> deque, List<? super E> list, int index) {
        return !deque.isEmpty() && DequeTools.drainHeadTo_(deque, list, index);
    }

    private static <E> boolean drainHeadTo_(Deque<? extends E> deque, List<? super E> list, int index) {
        return index == list.size() ? DequeTools.drainHeadTo_(deque, list) : list.addAll(index, DequeTools.drainHead(deque));
    }

    public static <E> boolean drainTailTo(Deque<? extends E> deque, List<? super E> list, int index) {
        return !deque.isEmpty() && DequeTools.drainTailTo_(deque, list, index);
    }

    private static <E> boolean drainTailTo_(Deque<? extends E> deque, List<? super E> list, int index) {
        return index == list.size() ? DequeTools.drainTailTo_(deque, list) : list.addAll(index, DequeTools.drainTail(deque));
    }

    public static <E> boolean drainHeadTo(Deque<? extends E> deque, Stack<? super E> stack) {
        return !deque.isEmpty() && DequeTools.drainHeadTo_(deque, stack);
    }

    private static <E> boolean drainHeadTo_(Deque<? extends E> deque, Stack<? super E> stack) {
        do {
            stack.push(deque.dequeueHead());
        } while (!deque.isEmpty());
        return true;
    }

    public static <E> boolean drainTailTo(Deque<? extends E> deque, Stack<? super E> stack) {
        return !deque.isEmpty() && DequeTools.drainTailTo_(deque, stack);
    }

    private static <E> boolean drainTailTo_(Deque<? extends E> deque, Stack<? super E> stack) {
        do {
            stack.push(deque.dequeueTail());
        } while (!deque.isEmpty());
        return true;
    }

    public static <E> boolean drainHeadTo(Deque<? extends E> deque, Queue<? super E> queue) {
        return !deque.isEmpty() && DequeTools.drainHeadTo_(deque, queue);
    }

    private static <E> boolean drainHeadTo_(Deque<? extends E> deque, Queue<? super E> queue) {
        do {
            queue.enqueue(deque.dequeueHead());
        } while (!deque.isEmpty());
        return true;
    }

    public static <E> boolean drainTailTo(Deque<? extends E> deque, Queue<? super E> queue) {
        return !deque.isEmpty() && DequeTools.drainTailTo_(deque, queue);
    }

    private static <E> boolean drainTailTo_(Deque<? extends E> deque, Queue<? super E> queue) {
        do {
            queue.enqueue(deque.dequeueTail());
        } while (!deque.isEmpty());
        return true;
    }

    public static <E> boolean drainHeadTo(Deque<? extends E> deque1, Deque<? super E> deque2) {
        return !deque1.isEmpty() && DequeTools.drainHeadTo_(deque1, deque2);
    }

    private static <E> boolean drainHeadTo_(Deque<? extends E> deque1, Deque<? super E> deque2) {
        do {
            deque2.enqueueTail(deque1.dequeueHead());
        } while (!deque1.isEmpty());
        return true;
    }

    public static <E> boolean drainTailTo(Deque<? extends E> deque1, Deque<? super E> deque2) {
        return !deque1.isEmpty() && DequeTools.drainTailTo_(deque1, deque2);
    }

    private static <E> boolean drainTailTo_(Deque<? extends E> deque1, Deque<? super E> deque2) {
        do {
            deque2.enqueueHead(deque1.dequeueTail());
        } while (!deque1.isEmpty());
        return true;
    }

    public static <K, V, E extends V> boolean drainHeadTo(Deque<E> deque, Map<K, V> map, Transformer<? super E, ? extends K> keyTransformer) {
        return !deque.isEmpty() && DequeTools.drainHeadTo_(deque, map, keyTransformer);
    }

    private static <K, V, E extends V> boolean drainHeadTo_(Deque<E> deque, Map<K, V> map, Transformer<? super E, ? extends K> keyTransformer) {
        do {
            MapTools.add(map, deque.dequeueHead(), keyTransformer);
        } while (!deque.isEmpty());
        return true;
    }

    public static <K, V, E extends V> boolean drainTailTo(Deque<E> deque, Map<K, V> map, Transformer<? super E, ? extends K> keyTransformer) {
        return !deque.isEmpty() && DequeTools.drainTailTo_(deque, map, keyTransformer);
    }

    private static <K, V, E extends V> boolean drainTailTo_(Deque<E> deque, Map<K, V> map, Transformer<? super E, ? extends K> keyTransformer) {
        do {
            MapTools.add(map, deque.dequeueTail(), keyTransformer);
        } while (!deque.isEmpty());
        return true;
    }

    public static <K, V, E> boolean drainHeadTo(Deque<E> deque, Map<K, V> map, Transformer<? super E, ? extends K> keyTransformer, Transformer<? super E, ? extends V> valueTransformer) {
        return !deque.isEmpty() && DequeTools.drainHeadTo_(deque, map, keyTransformer, valueTransformer);
    }

    private static <K, V, E> boolean drainHeadTo_(Deque<E> deque, Map<K, V> map, Transformer<? super E, ? extends K> keyTransformer, Transformer<? super E, ? extends V> valueTransformer) {
        do {
            MapTools.add(map, deque.dequeueHead(), keyTransformer, valueTransformer);
        } while (!deque.isEmpty());
        return true;
    }

    public static <K, V, E> boolean drainTailTo(Deque<E> deque, Map<K, V> map, Transformer<? super E, ? extends K> keyTransformer, Transformer<? super E, ? extends V> valueTransformer) {
        return !deque.isEmpty() && DequeTools.drainTailTo_(deque, map, keyTransformer, valueTransformer);
    }

    private static <K, V, E> boolean drainTailTo_(Deque<E> deque, Map<K, V> map, Transformer<? super E, ? extends K> keyTransformer, Transformer<? super E, ? extends V> valueTransformer) {
        do {
            MapTools.add(map, deque.dequeueTail(), keyTransformer, valueTransformer);
        } while (!deque.isEmpty());
        return true;
    }

    public static <E> ArrayDeque<E> arrayDeque() {
        return DequeTools.arrayDeque(10);
    }

    public static <E> ArrayDeque<E> arrayDeque(int initialCapacity) {
        return new ArrayDeque(initialCapacity);
    }

    public static <E> ArrayDeque<E> arrayDeque(Iterable<? extends E> iterable) {
        return DequeTools.arrayDeque(iterable.iterator());
    }

    public static <E> ArrayDeque<E> reverseArrayDeque(Iterable<? extends E> iterable) {
        return DequeTools.reverseArrayDeque(iterable.iterator());
    }

    public static <E> ArrayDeque<E> arrayDeque(Iterable<? extends E> iterable, int iterableSize) {
        return DequeTools.arrayDeque(iterable.iterator(), iterableSize);
    }

    public static <E> ArrayDeque<E> reverseArrayDeque(Iterable<? extends E> iterable, int iterableSize) {
        return DequeTools.reverseArrayDeque(iterable.iterator(), iterableSize);
    }

    public static <E> ArrayDeque<E> arrayDeque(Iterator<? extends E> iterator) {
        ArrayDeque<E> deque = DequeTools.arrayDeque();
        DequeTools.enqueueTailAll(deque, iterator);
        return deque;
    }

    public static <E> ArrayDeque<E> reverseArrayDeque(Iterator<? extends E> iterator) {
        ArrayDeque<E> deque = DequeTools.arrayDeque();
        DequeTools.enqueueHeadAll(deque, iterator);
        return deque;
    }

    public static <E> ArrayDeque<E> arrayDeque(Iterator<? extends E> iterator, int iteratorSize) {
        ArrayDeque<E> deque = DequeTools.arrayDeque(iteratorSize);
        DequeTools.enqueueTailAll(deque, iterator);
        return deque;
    }

    public static <E> ArrayDeque<E> reverseArrayDeque(Iterator<? extends E> iterator, int iteratorSize) {
        ArrayDeque<E> deque = DequeTools.arrayDeque(iteratorSize);
        DequeTools.enqueueHeadAll(deque, iterator);
        return deque;
    }

    public static <E> ArrayDeque<E> arrayDeque(E ... array) {
        ArrayDeque<E> deque = DequeTools.arrayDeque(array.length);
        DequeTools.enqueueTailAll(deque, array);
        return deque;
    }

    public static <E> ArrayDeque<E> reverseArrayDeque(E ... array) {
        ArrayDeque<E> deque = DequeTools.arrayDeque(array.length);
        DequeTools.enqueueHeadAll(deque, array);
        return deque;
    }

    public static <E> LinkedDeque<E> linkedDeque() {
        return DequeTools.linkedDeque(0);
    }

    public static <E> LinkedDeque<E> linkedDeque(int cacheSize) {
        return new LinkedDeque(cacheSize);
    }

    public static <E> LinkedDeque<E> linkedDeque(Iterable<? extends E> iterable) {
        return DequeTools.linkedDeque(iterable, 0);
    }

    public static <E> LinkedDeque<E> reverseLinkedDeque(Iterable<? extends E> iterable) {
        return DequeTools.reverseLinkedDeque(iterable, 0);
    }

    public static <E> LinkedDeque<E> linkedDeque(Iterable<? extends E> iterable, int cacheSize) {
        return DequeTools.linkedDeque(iterable.iterator(), cacheSize);
    }

    public static <E> LinkedDeque<E> reverseLinkedDeque(Iterable<? extends E> iterable, int cacheSize) {
        return DequeTools.reverseLinkedDeque(iterable.iterator(), cacheSize);
    }

    public static <E> LinkedDeque<E> linkedDeque(Iterator<? extends E> iterator) {
        return DequeTools.linkedDeque(iterator, 0);
    }

    public static <E> LinkedDeque<E> reverseLinkedDeque(Iterator<? extends E> iterator) {
        return DequeTools.reverseLinkedDeque(iterator, 0);
    }

    public static <E> LinkedDeque<E> linkedDeque(Iterator<? extends E> iterator, int cacheSize) {
        LinkedDeque<E> deque = DequeTools.linkedDeque(cacheSize);
        DequeTools.enqueueTailAll(deque, iterator);
        return deque;
    }

    public static <E> LinkedDeque<E> reverseLinkedDeque(Iterator<? extends E> iterator, int cacheSize) {
        LinkedDeque<E> deque = DequeTools.linkedDeque(cacheSize);
        DequeTools.enqueueHeadAll(deque, iterator);
        return deque;
    }

    public static <E> LinkedDeque<E> linkedDeque(E ... array) {
        return DequeTools.linkedDeque(array, 0);
    }

    public static <E> LinkedDeque<E> reverseLinkedDeque(E ... array) {
        return DequeTools.reverseLinkedDeque(array, 0);
    }

    public static <E> LinkedDeque<E> linkedDeque(E[] array, int cacheSize) {
        LinkedDeque<E> deque = DequeTools.linkedDeque(cacheSize);
        DequeTools.enqueueTailAll(deque, array);
        return deque;
    }

    public static <E> LinkedDeque<E> reverseLinkedDeque(E[] array, int cacheSize) {
        LinkedDeque<E> deque = DequeTools.linkedDeque(cacheSize);
        DequeTools.enqueueHeadAll(deque, array);
        return deque;
    }

    public static <E> FixedCapacityArrayDeque<E> fixedCapacityArrayDeque(int capacity) {
        return new FixedCapacityArrayDeque(capacity);
    }

    public static <E> FixedCapacityArrayDeque<E> fixedCapacityArrayDeque(Collection<? extends E> collection) {
        FixedCapacityArrayDeque<E> deque = DequeTools.fixedCapacityArrayDeque(collection.size());
        DequeTools.enqueueTailAll(deque, collection);
        return deque;
    }

    public static <E> FixedCapacityArrayDeque<E> reverseFixedCapacityArrayDeque(Collection<? extends E> collection) {
        FixedCapacityArrayDeque<E> deque = DequeTools.fixedCapacityArrayDeque(collection.size());
        DequeTools.enqueueHeadAll(deque, collection);
        return deque;
    }

    public static <E extends Comparable<E>> PriorityDeque<E> priorityDeque() {
        return DequeTools.priorityDeque(10);
    }

    public static <E extends Comparable<E>> PriorityDeque<E> priorityDeque(int initialCapacity) {
        return DequeTools.priorityDeque(ComparatorTools.naturalComparator(), initialCapacity);
    }

    public static <E> PriorityDeque<E> priorityDeque(Comparator<? super E> comparator) {
        return DequeTools.priorityDeque(comparator, 10);
    }

    public static <E> PriorityDeque<E> priorityDeque(Comparator<? super E> comparator, int initialCapacity) {
        return new PriorityDeque<E>(comparator, initialCapacity);
    }

    public static <E extends Comparable<E>> FixedCapacityPriorityDeque<E> fixedCapacityPriorityDeque(int capacity) {
        return DequeTools.fixedCapacityPriorityDeque(ComparatorTools.naturalComparator(), capacity);
    }

    public static <E> FixedCapacityPriorityDeque<E> fixedCapacityPriorityDeque(Comparator<? super E> comparator, int capacity) {
        return new FixedCapacityPriorityDeque<E>(comparator, capacity);
    }

    public static <E> SynchronizedDeque<E> synchronizedDeque() {
        ArrayDeque<E> deque = DequeTools.arrayDeque();
        return DequeTools.synchronizedDeque(deque);
    }

    public static <E> SynchronizedDeque<E> synchronizedDeque(Object mutex) {
        ArrayDeque<E> deque = DequeTools.arrayDeque();
        return DequeTools.synchronizedDeque(deque, mutex);
    }

    public static <E> SynchronizedDeque<E> synchronizedDeque(Deque<E> deque) {
        return new SynchronizedDeque<E>(deque);
    }

    public static <E> SynchronizedDeque<E> synchronizedDeque(Deque<E> deque, Object mutex) {
        return new SynchronizedDeque<E>(deque, mutex);
    }

    public static <E> ListDeque<E> adapt(List<E> list) {
        return new ListDeque<E>(list);
    }

    public static <E> Deque<E> reverse(Deque<E> deque) {
        return new ReverseDeque<E>(deque);
    }

    public static <E> Deque<E> emptyDeque() {
        return EmptyDeque.instance();
    }

    private DequeTools() {
        throw new UnsupportedOperationException();
    }
}

