/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.jface;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jpt.common.ui.internal.plugin.JptCommonUiPlugin;

public class ArchiveFileViewerFilter
extends ViewerFilter {
    private static final String[] archiveExtensions = new String[]{"jar", "zip"};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof IFile) {
            return ArchiveFileViewerFilter.isArchivePath(((IFile)element).getFullPath());
        }
        if (!(element instanceof IFolder)) return false;
        IFolder folder = (IFolder)element;
        try {
            IResource[] iResourceArray = folder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IResource each = iResourceArray[n2];
                if (this.select(viewer, folder, each)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException ce) {
            JptCommonUiPlugin.instance().logError(ce);
        }
        return false;
    }

    public static boolean isArchivePath(IPath path) {
        String ext = path.getFileExtension();
        if (ext != null && ext.length() != 0) {
            int i = 0;
            while (i < archiveExtensions.length) {
                if (ext.equalsIgnoreCase(archiveExtensions[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

