/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.perspective;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;

public class NodeManager {
    public static final String PATH_PLUS_NOTLAST = "images/plus_notlast.gif";
    public static final String PATH_PLUS_LAST = "images/plus_last.gif";
    public static final String PATH_MINUS_NOTLAST = "images/minus_notlast.gif";
    public static final String PATH_MINUS_LAST = "images/minus_last.gif";
    public static final String PATH_LINE = "images/line.gif";
    public static final String PATH_LINE_NOTLAST = "images/line_notlast.gif";
    public static final String PATH_LINE_LAST = "images/line_last.gif";
    public static final String PATH_SPACE = "images/space.gif";
    private Controller controller_;
    private Node rootNode_;
    private Hashtable nodeTable_;
    private int focusedNodeId_;
    private int selectedNodeId_;
    private int previousSelectedNodeId_;
    private int maxDepthVisible_;
    private int nextId_;

    public NodeManager(Controller controller) {
        this.controller_ = controller;
        this.rootNode_ = null;
        this.nodeTable_ = new Hashtable();
        this.focusedNodeId_ = -1;
        this.selectedNodeId_ = -1;
        this.previousSelectedNodeId_ = -1;
        this.maxDepthVisible_ = 1;
        this.nextId_ = 0;
    }

    public Controller getController() {
        return this.controller_;
    }

    public void setRootNode(Node rootNode) {
        this.rootNode_ = rootNode;
    }

    public Node getRootNode() {
        return this.rootNode_;
    }

    public int addToNodeTable(Node node) {
        int assignedNodeId = this.nextId_++;
        this.nodeTable_.put(String.valueOf(assignedNodeId), node);
        return assignedNodeId;
    }

    public void removeFromNodeTable(int nodeId) {
        Vector nodesToRemove = new Vector();
        Node node = this.getNode(nodeId);
        this.gatherNodesToRemove(nodesToRemove, node);
        Iterator it = nodesToRemove.iterator();
        while (it.hasNext()) {
            this.nodeTable_.remove(String.valueOf(((Node)it.next()).getNodeId()));
        }
    }

    private void gatherNodesToRemove(Vector nodesToRemove, Node node) {
        if (node != null) {
            nodesToRemove.add(node);
            Vector childNodes = node.getChildNodes();
            Iterator it = childNodes.iterator();
            while (it.hasNext()) {
                this.gatherNodesToRemove(nodesToRemove, (Node)it.next());
            }
        }
    }

    public int getMaxDepthVisible() {
        return this.maxDepthVisible_;
    }

    public void updateMaxDepthVisible() {
        if (this.rootNode_ != null) {
            this.maxDepthVisible_ = this.rootNode_.getMaxDepthVisible();
        }
    }

    public int getNextNodeId() {
        return this.nextId_;
    }

    public int getFocusedNodeId() {
        return this.focusedNodeId_;
    }

    public void setFocusedNodeId(int nodeId) {
        this.focusedNodeId_ = nodeId;
    }

    public Node getFocusedNode() {
        return this.getNode(this.focusedNodeId_);
    }

    public int getSelectedNodeId() {
        return this.selectedNodeId_;
    }

    public Node getSelectedNode() {
        return this.getNode(this.selectedNodeId_);
    }

    public Node getNode(int nodeId) {
        return (Node)this.nodeTable_.get(String.valueOf(nodeId));
    }

    public void setSelectedNodeId(int nodeId) {
        this.previousSelectedNodeId_ = this.selectedNodeId_;
        this.selectedNodeId_ = nodeId;
        this.setFocusedNodeId(this.selectedNodeId_);
    }

    public int getPreviousSelectedNodeId() {
        return this.previousSelectedNodeId_;
    }

    public Node getPreviousSelectedNode() {
        return (Node)this.nodeTable_.get(String.valueOf(this.previousSelectedNodeId_));
    }

    public String renderTreeView(HttpServletResponse response) {
        StringBuffer treeView = new StringBuffer();
        this.rootNode_.renderNode(response, treeView, "", false);
        return treeView.toString();
    }

    public final boolean makeNodeVisible(Node node) {
        boolean requiresTreeViewRefresh = false;
        while ((node = node.getParent()) != null) {
            if (node.isOpen()) continue;
            requiresTreeViewRefresh = true;
            node.setVisibilityOfChildren(true);
        }
        return requiresTreeViewRefresh;
    }

    public final boolean makeSelectedNodeVisible() {
        return this.makeNodeVisible(this.getSelectedNode());
    }
}

