/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.feature;

import java.util.Set;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.CreateOneToOneRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.ICreateBiDirRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.HasReferanceRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.OneToOneBiDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;

public class CreateOneToOneBiDirRelationFeature
extends CreateOneToOneRelationFeature
implements ICreateBiDirRelationFeature {
    public CreateOneToOneBiDirRelationFeature(IJPAEditorFeatureProvider fp, boolean isDerivedIdFeature) {
        super(fp, JPAEditorMessages.CreateOneToOneBiDirRelationFeature_oneToOneBiDirFeatureName, JPAEditorMessages.CreateOneToOneBiDirRelationFeature_oneToOneBiDirFeatureDescription, isDerivedIdFeature);
    }

    @Override
    public OneToOneBiDirRelation createRelation(IJPAEditorFeatureProvider fp, PictogramElement source, PictogramElement target, PersistentType embeddingEntity) {
        String inverseAttributeName;
        String ownerAttributeName;
        PersistentType owner = (PersistentType)this.getBusinessObjectForPictogramElement(source);
        PersistentType inverse = (PersistentType)this.getBusinessObjectForPictogramElement(target);
        String nameWithNonCapitalLetter = ownerAttributeName = JPAEditorUtil.returnSimpleName(JpaArtifactFactory.instance().getEntityName(inverse));
        if (JpaArtifactFactory.instance().isMethodAnnotated(owner)) {
            nameWithNonCapitalLetter = JPAEditorUtil.produceValidAttributeName(ownerAttributeName);
        }
        String ownerAttributeText = JPAEditorUtil.produceUniqueAttributeName(owner, nameWithNonCapitalLetter);
        String nameWithNonCapitalLetter2 = inverseAttributeName = JPAEditorUtil.returnSimpleName(JpaArtifactFactory.instance().getEntityName(owner));
        if (JpaArtifactFactory.instance().isMethodAnnotated(inverse)) {
            nameWithNonCapitalLetter2 = JPAEditorUtil.produceValidAttributeName(inverseAttributeName);
        }
        String inverseAttributeText = JPAEditorUtil.produceUniqueAttributeName(inverse, ownerAttributeText, nameWithNonCapitalLetter2);
        OneToOneBiDirRelation rel = new OneToOneBiDirRelation(fp, owner, inverse, ownerAttributeText, inverseAttributeText, true, embeddingEntity, this.isDerivedIdFeature);
        return rel;
    }

    public String getCreateImageId() {
        if (this.isDerivedIdFeature) {
            return "org.eclipse.jpt.jpadiagrameditor.ui.one_to_one_2_key_relation";
        }
        return "org.eclipse.jpt.jpadiagrameditor.ui.one_to_one_2_dir_relation";
    }

    @Override
    protected boolean isRelationshipPossible() {
        if (JpaArtifactFactory.instance().isEmbeddable(this.owner)) {
            Set<HasReferanceRelation> refs = JpaArtifactFactory.instance().findAllHasReferenceRelsByEmbeddableWithEntity(this.owner, this.getFeatureProvider());
            if (refs.size() != 1) {
                return false;
            }
            for (HasReferanceRelation ref : refs) {
                AttributeMapping attributeMapping = JpaArtifactFactory.instance().getAttributeMapping(ref.getEmbeddedAnnotatedAttribute());
                if (!(attributeMapping instanceof EmbeddedIdMapping)) continue;
                return false;
            }
        }
        return true;
    }
}

