/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.util;

import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import org.json.simple.JSONValue;

public class JavaScriptExpressionBuilder {
    public static final ExpressionComponentFormatter SHORT_NAME = new ExpressionComponentFormatter(){

        @Override
        public void formatRecursively(StringBuilder output, VariableAccess access) {
            output.append(access.getShortName());
        }

        @Override
        public boolean needsParentheses() {
            return false;
        }
    };
    public static final ExpressionComponentFormatter SHORT_NAME_PAREN = new ExpressionComponentFormatter(){

        @Override
        public void formatRecursively(StringBuilder output, VariableAccess access) {
            output.append(access.getShortName());
        }

        @Override
        public boolean needsParentheses() {
            return true;
        }
    };
    public static final ExpressionComponentFormatter OBJECT_PROPERTY_NAME_BUILDER = new ExpressionComponentFormatter(){

        @Override
        public void formatRecursively(StringBuilder output, VariableAccess wrapper) {
            String name = wrapper.getShortName();
            JavaScriptExpressionBuilder.buildParentRef(output, wrapper.getParent());
            if (KEY_NOTATION_PROPERTY_NAME_PATTERN.matcher(name).matches()) {
                output.append(".").append(name);
            } else {
                output.append("[").append(JSONValue.toJSONString((Object)name)).append("]");
            }
        }

        @Override
        public boolean needsParentheses() {
            return false;
        }
    };
    public static final Pattern KEY_NOTATION_PROPERTY_NAME_PATTERN = Pattern.compile("[_\\p{L}$]*");
    public static final Collection<String> SEMI_INTERNAL_PROPERTY_NAMES = Collections.singleton("__proto__");
    private static final Pattern ALL_DIGITS_PATTERN = Pattern.compile("\\d+");

    public static String buildQualifiedName(VariableAccess variableAccess) {
        StringBuilder builder = new StringBuilder();
        ExpressionComponentFormatter formatter = variableAccess.getVariableFormatter();
        formatter.formatRecursively(builder, variableAccess);
        return builder.toString();
    }

    public static Long parsePropertyNameAsArrayIndex(String propertyName) {
        Long index;
        if (propertyName.length() > 10) {
            return null;
        }
        if (!ALL_DIGITS_PATTERN.matcher(propertyName).matches()) {
            return null;
        }
        try {
            index = Long.valueOf(propertyName);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        if (!JavaScriptExpressionBuilder.checkArrayIndexValue(index)) {
            return null;
        }
        return index;
    }

    public static boolean checkArrayIndexValue(long l) {
        return l >= 0L && l <= 0xFFFFFFFEL;
    }

    private static void buildParentRef(StringBuilder output, VariableAccess variableAccess) {
        ExpressionComponentFormatter objectNameBuilder = variableAccess.getVariableFormatter();
        if (objectNameBuilder.needsParentheses()) {
            output.append('(');
            objectNameBuilder.formatRecursively(output, variableAccess);
            output.append(')');
        } else {
            objectNameBuilder.formatRecursively(output, variableAccess);
        }
    }

    public static interface ExpressionComponentFormatter {
        public void formatRecursively(StringBuilder var1, VariableAccess var2);

        public boolean needsParentheses();
    }

    public static interface VariableAccess {
        public String getShortName();

        public ExpressionComponentFormatter getVariableFormatter();

        public VariableAccess getParent();
    }
}

