/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.properties.celleditors;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataDomainContext;
import org.eclipse.jst.jsf.common.metadata.internal.TraitValueHelper;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryContextFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.taglib.ITaglibDomainMetaDataQuery;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogField;
import org.eclipse.jst.jsf.metadataprocessors.features.IDefaultValue;
import org.eclipse.jst.jsf.metadataprocessors.features.IPossibleValues;
import org.eclipse.jst.pagedesigner.editors.properties.IPropertyPageDescriptor;
import org.eclipse.jst.pagedesigner.meta.ITagAttributeCellEditorFactory;
import org.eclipse.jst.pagedesigner.properties.celleditors.CSSDialogCellEditor;
import org.eclipse.jst.pagedesigner.properties.celleditors.EditableDialogCellEditor;
import org.eclipse.jst.pagedesigner.properties.celleditors.LabeledStyleComboCellEditor;
import org.eclipse.jst.pagedesigner.properties.celleditors.LoadbundleSelectionCellEditor;
import org.eclipse.jst.pagedesigner.properties.celleditors.ResourceBoundle;
import org.eclipse.jst.pagedesigner.properties.celleditors.ResourceDialogCellEditor;
import org.eclipse.jst.pagedesigner.properties.dialogfields.MDEnabledComboDialogField;
import org.eclipse.jst.pagedesigner.ui.dialogfields.ClasspathResourceButtonDialogField;
import org.eclipse.jst.pagedesigner.ui.dialogfields.ContextableResourceButtonDialogField;
import org.eclipse.jst.pagedesigner.ui.dialogfields.StyleButtonDialogField;
import org.eclipse.jst.pagedesigner.utils.StructuredModelUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;

public class CellEditorFactory
implements ITagAttributeCellEditorFactory {
    @Override
    public CellEditor createCellEditor(Composite parent, IPropertyPageDescriptor attr, Element element) {
        String type = attr.getValueType();
        IPossibleValues pvs = (IPossibleValues)attr.getAdapter(IPossibleValues.class);
        IDefaultValue defaultValue = (IDefaultValue)attr.getAdapter(IDefaultValue.class);
        EditableDialogCellEditor ed = null;
        if ("org.eclipse.jst.jsf.core.attributevalues.RelativePathType".equalsIgnoreCase(type) || "org.eclipse.jst.jsf.core.attributevalues.WebPathType".equalsIgnoreCase(type)) {
            IProject project = this.getProject(element);
            IFile file = this.getFile(element);
            if (project != null) {
                ResourceDialogCellEditor cellEditor = new ResourceDialogCellEditor(parent);
                IMetaDataDomainContext context = null;
                context = file != null ? MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(file) : MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(project);
                ITaglibDomainMetaDataQuery query = (ITaglibDomainMetaDataQuery)MetaDataQueryFactory.getInstance().createQuery(context);
                Trait fileExt = query.findTrait(attr.getMetaDataContext().getEntity(), "file-extensions");
                Trait separator = query.findTrait(attr.getMetaDataContext().getEntity(), "separator");
                String[] fileExts = null;
                if (fileExt != null) {
                    List exts = TraitValueHelper.getValueAsListOfStrings((Trait)fileExt);
                    fileExts = exts.toArray(new String[exts.size()]);
                }
                String sep = null;
                if (separator != null) {
                    sep = TraitValueHelper.getValueAsString((Trait)separator);
                }
                if (fileExts != null) {
                    cellEditor.setSuffixs(fileExts);
                }
                if (sep != null) {
                    cellEditor.setSeparator(sep);
                }
                cellEditor.setProject(project);
                cellEditor.setReferredFile(file);
                if ("org.eclipse.jst.jsf.core.attributevalues.WebPathType".equalsIgnoreCase(type)) {
                    cellEditor.setWebPath(true);
                }
                if ("directive.include".equals(element.getLocalName()) || "include".equals(element.getLocalName())) {
                    cellEditor.setTransformJSPURL(false);
                }
                ed = cellEditor;
            }
        } else if ("org.eclipse.jst.jsf.core.attributevalues.ResourceBundleType".equals(type)) {
            ed = new LoadbundleSelectionCellEditor(parent, this.getProject(element));
        } else if ("org.eclipse.jst.jsf.core.attributevalues.CSSStyleType".equalsIgnoreCase(type)) {
            CSSDialogCellEditor cellEditor = new CSSDialogCellEditor(parent, attr, (IDOMElement)element);
            ed = cellEditor;
        } else {
            ed = pvs != null && pvs.getPossibleValues().size() > 0 ? LabeledStyleComboCellEditor.newInstance(parent, pvs, defaultValue, 0) : new TextCellEditor(parent);
        }
        return ed;
    }

    @Override
    public DialogField createDialogField(IPropertyPageDescriptor attr) {
        String type = attr.getValueType();
        IPossibleValues pvs = (IPossibleValues)attr.getAdapter(IPossibleValues.class);
        if ("org.eclipse.jst.jsf.core.attributevalues.RelativePathType".equals(type) || "org.eclipse.jst.jsf.core.attributevalues.WebPathType".equals(type)) {
            IMetaDataDomainContext context = MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(null);
            ITaglibDomainMetaDataQuery query = (ITaglibDomainMetaDataQuery)MetaDataQueryFactory.getInstance().createQuery(context);
            Trait fileExt = query.findTrait(attr.getMetaDataContext().getEntity(), "file-extensions");
            Trait seperator = query.findTrait(attr.getMetaDataContext().getEntity(), "separator");
            String[] fileExts = null;
            if (fileExt != null) {
                List exts = TraitValueHelper.getValueAsListOfStrings((Trait)fileExt);
                fileExts = exts.toArray(new String[exts.size()]);
            }
            String sep = null;
            if (seperator != null) {
                sep = TraitValueHelper.getValueAsString((Trait)seperator);
            }
            ContextableResourceButtonDialogField field = new ContextableResourceButtonDialogField();
            field.setLabelText(attr.getLabel());
            if (fileExts != null) {
                field.setSuffixs(fileExts);
            }
            if (sep != null) {
                field.setSeparator(sep);
            }
            if ("".equalsIgnoreCase(field.getSeparator())) {
                field.setResourceDescription(ResourceBoundle.getString("FileCellEditor.Msg"));
            } else {
                field.setResourceDescription(ResourceBoundle.getString("FileCellEditor.Msg1"));
            }
            field.setWebPath("org.eclipse.jst.jsf.core.attributevalues.WebPathType".equals(type));
            field.setRequired(attr.isRequired());
            field.setToolTip(attr.getDescription());
            return field;
        }
        if ("org.eclipse.jst.jsf.core.attributevalues.CLASSPATH_RESOURCE".equals(type) || "org.eclipse.jst.jsf.core.attributevalues.ResourceBundleType".equals(type)) {
            ClasspathResourceButtonDialogField field = new ClasspathResourceButtonDialogField();
            field.setRequired(attr.isRequired());
            field.setToolTip(attr.getDescription());
            field.setLabelText(attr.getLabel());
            return field;
        }
        if ("org.eclipse.jst.jsf.core.attributevalues.CSSStyleType".equalsIgnoreCase(type)) {
            StyleButtonDialogField field = new StyleButtonDialogField();
            field.setRequired(attr.isRequired());
            field.setToolTip(attr.getDescription());
            field.setLabelText(attr.getLabel());
            return field;
        }
        if (pvs != null && pvs.getPossibleValues().size() > 0) {
            MDEnabledComboDialogField field = new MDEnabledComboDialogField(0);
            field.setLabelText(attr.getLabel());
            field.setToolTip(attr.getDescription());
            field.setRequired(attr.isRequired());
            return field;
        }
        return null;
    }

    private IProject getProject(Element element) {
        IDOMModel model;
        IFile file;
        if (element instanceof IDOMElement && (file = StructuredModelUtil.getFileFor((IStructuredModel)(model = ((IDOMElement)element).getModel()))) != null) {
            return file.getProject();
        }
        return null;
    }

    @Override
    public String[] getSupportedValueTypes() {
        return null;
    }

    private IFile getFile(Element element) {
        if (element instanceof IDOMElement) {
            IDOMModel model = ((IDOMElement)element).getModel();
            IFile file = StructuredModelUtil.getFileFor((IStructuredModel)model);
            return file;
        }
        return null;
    }
}

