/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.parser;

import org.eclipse.wst.jsdt.core.tests.compiler.parser.AbstractCompletionTest;

public class FieldAccessCompletionTest
extends AbstractCompletionTest {
    public FieldAccessCompletionTest(String testName) {
        super(testName);
    }

    public void testAdditiveExpressionMinus() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\t\t\n\treturn 1 - fred().xyz;\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  return (1 - <CompleteOnMemberAccess:fred().x>);\n}\n", "x", "xyz", "<complete on additive expression minus>");
    }

    public void testAdditiveExpressionPlus() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\t\t\n\treturn 1 + fred().xyz;\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  return (1 + <CompleteOnMemberAccess:fred().x>);\n}\n", "x", "xyz", "<complete on additive expression plus>");
    }

    public void testAndExpression() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\t\n\treturn isTrue & fred().xyz;\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  return (isTrue & <CompleteOnMemberAccess:fred().x>);\n}\n", "x", "xyz", "<complete on and expression>");
    }

    public void testArgumentList() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\n\tbizz(1, \"2\", fred().xyz);\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  bizz(1, \"2\", <CompleteOnMemberAccess:fred().x>);\n}\n", "x", "xyz", "<complete on argument list>");
    }

    public void testArrayAccess() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\t\n\treturn v[fred().xyz];\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  return v[<CompleteOnMemberAccess:fred().x>];\n}\n", "x", "xyz", "<complete on array access>");
    }

    public void testArrayInitializer() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\t\t\n\tvar i = [fred().xyz];\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  var i = [<CompleteOnMemberAccess:fred().x>];\n}\n", "x", "xyz", "<complete on array initializer>");
    }

    public void testArrayInitializerComma() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\t\t\n\tvar i = [fred().xyz];\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  var i = [<CompleteOnMemberAccess:fred().x>];\n}\n", "x", "xyz", "<complete on array initializer comma>");
    }

    public void testAssignment() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\t\t\n\ti = fred().xyz;\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  i = <CompleteOnMemberAccess:fred().x>;\n}\n", "x", "xyz", "<complete on assignment>");
    }

    public void testBlock() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\n\ttry {\t\t\t\t\t\t\t\t\t\n\t\tfred().xyz = new Foo();\t\t\t\t\n\t} catch (e) {}\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  try \n    {\n      <CompleteOnMemberAccess:fred().x> = new Foo();\n    }\n  catch (e)     {\n    }\n}\n", "x", "xyz", "<complete on block>");
    }

    public void testBlockStatements() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\n\tvar i = 0;\t\t\t\t\t\t\t\t\n\tfred().xyz = new Foo();\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  var i = 0;\n  <CompleteOnMemberAccess:fred().x> = new Foo();\n}\n", "x", "xyz", "<complete on block statements>");
    }

    public void testBlockStatementsInInitializer() {
        this.runTestCheckMethodParse("function Bar() {\t\t\t\t\t\t\t\t\t\n\t{\t\t\t\t\t\t\t\t\t\t\t\n\t\tvar i = 0;\t\t\t\t\t\t\t\t\n\t\tfred().xyz = new Foo();\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function Bar() {\n  {\n    var i = 0;\n    <CompleteOnMemberAccess:fred().x> = new Foo();\n  }\n}\n", "x", "xyz", "<complete on block statements in initializer>");
    }

    public void testClassInstanceCreationExpression() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\n\tnew Bar(fred().xyz);\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  new   Bar(<CompleteOnMemberAccess:fred().x>);\n}\n", "x", "xyz", "<complete on class instance creation expression>");
    }

    public void testConditionalAndExpression() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\t\n\treturn isTrue && fred().xyz;\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  return (isTrue && <CompleteOnMemberAccess:fred().x>);\n}\n", "x", "xyz", "<complete on conditional and expression>");
    }

    public void testConditionalExpression() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\t\t\n\treturn fred().xyz == null ? null : new Bar();\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  return ((<CompleteOnMemberAccess:fred().x> == null) ? null : new Bar());\n}\n", "x", "xyz", "<complete on conditional expression>");
    }

    public void testConditionalExpressionConditionalExpression() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\t\n\treturn isTrue ? true : fred().xyz;\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  return (isTrue ? true : <CompleteOnMemberAccess:fred().x>);\n}\n", "x", "xyz", "<complete on conditional expression conditional expression>");
    }

    public void testConditionalOrExpression() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\t\n\treturn isTrue || fred().xyz;\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  return (isTrue || <CompleteOnMemberAccess:fred().x>);\n}\n", "x", "xyz", "<complete on conditional or expression>");
    }

    public void testDoExpression() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\n\tdo\t\t\t\t\t\t\t\t\t\t\n\t\tSystem.out.println();\t\t\t\t\n\twhile (fred().xyz);\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  do\n    System.out.println();\nwhile (<CompleteOnMemberAccess:fred().x>);\n}\n", "x", "xyz", "<complete on do expression>");
    }

    public void testDoStatement() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\n\tdo\t\t\t\t\t\t\t\t\t\t\n\t\tfred().xyz = new Foo();\t\t\t\t\n\twhile (true);\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  do\n    <CompleteOnMemberAccess:fred().x> = new Foo();\nwhile (true);\n}\n", "x", "xyz", "<complete on do statement>");
    }

    public void testEqualityExpression() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\t\n\treturn 1 == fred().xyz;\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  return (1 == <CompleteOnMemberAccess:fred().x>);\n}\n", "x", "xyz", "<complete on equality expression>");
    }

    public void testEqualityExpressionNot() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\t\n\treturn 1 != fred().xyz;\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  return (1 != <CompleteOnMemberAccess:fred().x>);\n}\n", "x", "xyz", "<complete on equality expression not>");
    }

    public void testExclusiveOrExpression() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\t\n\treturn isTrue ^ fred().xyz;\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  return (isTrue ^ <CompleteOnMemberAccess:fred().x>);\n}\n", "x", "xyz", "<complete on exclusive or expression>");
    }

    public void testForInit() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\n\tfor (var i = fred().xyz; i < 2; i++)\t\t\n\t\tSystem.out.println();\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  for (var i = <CompleteOnMemberAccess:fred().x>;; (i < 2); i ++) \n    System.out.println();\n}\n", "x", "xyz", "<complete on for init>");
    }

    public void testForStatement() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\n\tfor (var i = 0; i < 2; i++)\t\t\t\t\n\t\tfred().xyz = new Foo();\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  for (var i = 0;; (i < 2); i ++) \n    <CompleteOnMemberAccess:fred().x> = new Foo();\n}\n", "x", "xyz", "<complete on for statement>");
    }

    public void testForStatementExpression() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\n\tfor(var i = 0; fred().xyz > i; i++)\t\t\n\t\tSystem.out.println();\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  for (var i = 0;; (<CompleteOnMemberAccess:fred().x> > i); i ++) \n    System.out.println();\n}\n", "x", "xyz", "<complete on for statement expression>");
    }

    public void testForUpdate() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\n\tfor (var i = 0; i < 2; i+= fred().xyz)\t\n\t\tSystem.out.println();\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  for (var i = 0;; (i < 2); i += <CompleteOnMemberAccess:fred().x>) \n    System.out.println();\n}\n", "x", "xyz", "<complete on for update>");
    }

    public void testIfExpresionThen() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\n\tif (fred().xyz)\t\t\t\t\t\t\t\n\t\tSystem.out.println();\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  if (<CompleteOnMemberAccess:fred().x>)\n      System.out.println();\n}\n", "x", "xyz", "<complete on \"if expression then\">");
    }

    public void testIfExpresionThenElse() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\n\tif (fred().xyz)\t\t\t\t\t\t\t\n\t\tSystem.out.println();\t\t\t\t\n\telse\t\t\t\t\t\t\t\t\t\n\t\tSystem.out.println();\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  if (<CompleteOnMemberAccess:fred().x>)\n      System.out.println();\n  else\n      System.out.println();\n}\n", "x", "xyz", "<complete on \"if expression then else\">");
    }

    public void testIfThenElseStatement() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\n\tif (false)\t\t\t\t\t\t\t\t\n\t\t System.out.println();\t\t\t\t\n\telse\t\t\t\t\t\t\t\t\t\n\t\tfred().xyz = new Foo();\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  if (false)\n      System.out.println();\n  else\n      <CompleteOnMemberAccess:fred().x> = new Foo();\n}\n", "x", "xyz", "<complete on \"if then else\" statement>");
    }

    public void testIfThenStatement() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\n\tif (true)\t\t\t\t\t\t\t\t\n\t\tfred().xyz = new Foo();\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  if (true)\n      <CompleteOnMemberAccess:fred().x> = new Foo();\n}\n", "x", "xyz", "<complete on \"if then\" statement>");
    }

    public void testIfThenStatementElse() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\n\tif (true)\t\t\t\t\t\t\t\t\n\t\tfred().xyz = new Foo();\t\t\t\t\n\telse\t\t\t\t\t\t\t\t\t\n\t\tSystem.out.println();\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  if (true)\n      <CompleteOnMemberAccess:fred().x> = new Foo();\n  else\n      System.out.println();\n}\n", "x", "xyz", "<complete on \"if then statement else\">");
    }

    public void testInclusiveOrExpression() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\t\n\treturn isTrue | fred().xyz;\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  return (isTrue | <CompleteOnMemberAccess:fred().x>);\n}\n", "x", "xyz", "<complete on inclusive or expression>");
    }

    public void testLabeledStatement() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\n\tfredCall: fred().xyz = new Foo();\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  fredCall: <CompleteOnMemberAccess:fred().x> = new Foo();\n}\n", "x", "xyz", new String[]{"fredCall"}, "<complete on labeled statement>");
    }

    public void testMethodBody() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\n\tfred().xyz = new Foo();\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  <CompleteOnMemberAccess:fred().x> = new Foo();\n}\n", "x", "xyz", "<complete on method body>");
    }

    public void testMethodInvocation() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\n\tbizz(fred().xyz);\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  bizz(<CompleteOnMemberAccess:fred().x>);\n}\n", "x", "xyz", "<complete on method invocation>");
    }

    public void testMethodInvocationPrimary() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\n\tbuzz().bizz(fred().xyz);\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  buzz().bizz(<CompleteOnMemberAccess:fred().x>);\n}\n", "x", "xyz", "<complete on method invocation primary>");
    }

    public void testMultiplicativeExpressiondDivision() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\t\n\treturn 2 / fred().xyz;\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  return (2 / <CompleteOnMemberAccess:fred().x>);\n}\n", "x", "xyz", "<complete on multiplicative expression division>");
    }

    public void testMultiplicativeExpressionMultiplication() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\t\t\n\treturn 2 * fred().xyz;\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  return (2 * <CompleteOnMemberAccess:fred().x>);\n}\n", "x", "xyz", "<complete on multiplicative expression multiplication>");
    }

    public void testMultiplicativeExpressionRemainder() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\t\t\n\treturn 2 % fred().xyz;\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  return (2 % <CompleteOnMemberAccess:fred().x>);\n}\n", "x", "xyz", "<complete on multiplicative expression remainder>");
    }

    public void testPreIncrementExpressionMinusMinus() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\n\t-- fred().xyz;\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  -- <CompleteOnMemberAccess:fred().x>;\n}\n", "x", "xyz", "<complete on pre increment expression minus minus>");
    }

    public void testPreIncrementExpressionPlusPlus() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\n\t++ fred().xyz;\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  ++ <CompleteOnMemberAccess:fred().x>;\n}\n", "x", "xyz", "<complete on pre increment expression plus plus>");
    }

    public void testPrimaryNoNewArray() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\n\t(fred().xyz).zzz();\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  <CompleteOnMemberAccess:fred().x>.zzz();\n}\n", "x", "(fred().xyz)", "<complete on primary no new array>");
    }

    public void testRelationalExpressionGreaterThan() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\t\n\treturn 1 > fred().xyz;\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  return (1 > <CompleteOnMemberAccess:fred().x>);\n}\n", "x", "xyz", "<complete on relational expression greater than>");
    }

    public void testRelationalExpressionGreaterThanOrEquals() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\t\n\treturn 1 >= fred().xyz;\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  return (1 >= <CompleteOnMemberAccess:fred().x>);\n}\n", "x", "xyz", "<complete on relational expression greater than or equal>");
    }

    public void testRelationalExpressionLessThan() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\t\n\treturn 1 < fred().xyz;\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  return (1 < <CompleteOnMemberAccess:fred().x>);\n}\n", "x", "xyz", "<complete on relational expression less than>");
    }

    public void testRelationalExpressionLessThanOrEqual() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\t\n\treturn 1 <= fred().xyz;\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  return (1 <= <CompleteOnMemberAccess:fred().x>);\n}\n", "x", "xyz", "<complete on relational expression less than or equal>");
    }

    public void testReturnStatement() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\t\n\treturn fred().xyz;\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  return <CompleteOnMemberAccess:fred().x>;\n}\n", "x", "xyz", "<complete on return statement>");
    }

    public void testShiftExpressionLeft() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\t\t\n\treturn i << fred().xyz;\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  return (i << <CompleteOnMemberAccess:fred().x>);\n}\n", "x", "xyz", "<complete on shift expression left>");
    }

    public void testShiftExpressionRight() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\t\t\n\treturn i >> fred().xyz;\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  return (i >> <CompleteOnMemberAccess:fred().x>);\n}\n", "x", "xyz", "<complete on shift expression right>");
    }

    public void testShiftExpressionRightUnSigned() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\t\t\n\treturn i >>> fred().xyz;\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  return (i >>> <CompleteOnMemberAccess:fred().x>);\n}\n", "x", "xyz", "<complete on shift expression right unsigned>");
    }

    public void testStatementExpressionList() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\t\t\n\tfor (var i = 0, length = fred().xyz; i < 2; i++)\t\n\t\tSystem.out.println();\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  for (var i = 0;, var length = <CompleteOnMemberAccess:fred().x>;; (i < 2); i ++) \n    System.out.println();\n}\n", "x", "xyz", "<complete on statement expression list>");
    }

    public void testSwitchBlockStatement() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\n\tvar i =  0;\t\t\t\t\t\t\t\t\n\tswitch (i) {\t\t\t\t\t\t\t\n\t\tcase 0: fred().xyz = new Foo();\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  var i = 0;\n  switch (i) {\n  case 0 : ;\n      <CompleteOnMemberAccess:fred().x> = new Foo();\n  }\n}\n", "x", "xyz", "<complete on switch block statement>");
    }

    public void testSwitchExpression() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\n\tswitch (fred().xyz) {\t\t\t\t\t\t\n\t\tcase 0: System.out.println();\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  switch (<CompleteOnMemberAccess:fred().x>) {\n  case 0 : ;\n      System.out.println();\n  }\n}\n", "x", "xyz", "<complete on switch expression>");
    }

    public void testSwitchLabel() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\t\n\tvar i =  0;\t\t\t\t\t\t\t\t\t\n\tswitch (i) {\t\t\t\t\t\t\t\t\n\t\tcase fred().xyz: System.out.println();\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  var i = 0;\n  switch (i) {\n  case <CompleteOnMemberAccess:fred().x> : ;\n      System.out.println();\n  }\n}\n", "x", "xyz", "<complete on switch label>");
    }

    public void testThrowExpression() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\n\tthrow fred().xyz;\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  throw <CompleteOnMemberAccess:fred().x>;\n}\n", "x", "xyz", "<complete on throw expression>");
    }

    public void testUnaryExpressionBitwiseComplement() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\n\ti = ~ fred().xyz;\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  i = (~ <CompleteOnMemberAccess:fred().x>);\n}\n", "x", "xyz", "<complete on unary expression bitwise complement>");
    }

    public void testUnaryExpressionLogicalComplement() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\n\ti = ! fred().xyz;\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  i = (! <CompleteOnMemberAccess:fred().x>);\n}\n", "x", "xyz", "<complete on unary expression logical complement>");
    }

    public void testUnaryExpressionMinus() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\n\ti = - fred().xyz;\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  i = (- <CompleteOnMemberAccess:fred().x>);\n}\n", "x", "xyz", "<complete on unary expression minus>");
    }

    public void testUnaryExpressionPlus() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\n\ti = + fred().xyz;\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  i = (+ <CompleteOnMemberAccess:fred().x>);\n}\n", "x", "xyz", "<complete on unary expression plus>");
    }

    public void testVariableDeclarator() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\t\t\n\tvar i = fred().xyz;\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  var i = <CompleteOnMemberAccess:fred().x>;\n}\n", "x", "xyz", "<complete on variable declarator>");
    }

    public void testVariableInitializers() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\t\t\n\tvar i = 0, j = fred().xyz;\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  var i = 0, j = <CompleteOnMemberAccess:fred().x>;\n}\n", "x", "xyz", "<complete on variable initializers>");
    }

    public void testWhileExpression() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\n\twhile (fred().xyz)\t\t\t\t\t\t\n\t\tSystem.out.println();\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  while (<CompleteOnMemberAccess:fred().x>)    System.out.println();\n}\n", "x", "xyz", "<complete on while expresion>");
    }

    public void testWhileStatement() {
        this.runTestCheckMethodParse("function foo() {\t\t\t\t\t\t\t\t\n\twhile (true)\t\t\t\t\t\t\t\n\t\tfred().xyz = new Foo();\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\n", "x", "<CompleteOnMemberAccess:fred().x>", "function foo() {\n  while (true)    <CompleteOnMemberAccess:fred().x> = new Foo();\n}\n", "x", "xyz", "<complete on while statement>");
    }
}

