/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.ui.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;

public final class SharedWorkingCopyManager {
    private static final Map<IFacetedProject, IFacetedProjectWorkingCopy> sharedWorkingCopies = new HashMap<IFacetedProject, IFacetedProjectWorkingCopy>();
    private static final Map<IFacetedProject, Integer> sharedWorkingCopyUserCount = new HashMap<IFacetedProject, Integer>();

    public static synchronized IFacetedProjectWorkingCopy getWorkingCopy(IFacetedProject project) {
        IFacetedProjectWorkingCopy fpjwc = sharedWorkingCopies.get(project);
        if (fpjwc != null) {
            int userCount = sharedWorkingCopyUserCount.get(project);
            sharedWorkingCopyUserCount.put(project, userCount + 1);
        } else {
            fpjwc = project.createWorkingCopy();
            sharedWorkingCopies.put(project, fpjwc);
            sharedWorkingCopyUserCount.put(project, 1);
        }
        return fpjwc;
    }

    public static synchronized void releaseWorkingCopy(IFacetedProject project) {
        IFacetedProjectWorkingCopy fpjwc = sharedWorkingCopies.get(project);
        int usersCount = sharedWorkingCopyUserCount.get(project);
        if (usersCount == 1) {
            sharedWorkingCopies.remove(project);
            sharedWorkingCopyUserCount.remove(project);
            fpjwc.dispose();
        } else {
            sharedWorkingCopyUserCount.put(project, usersCount - 1);
        }
    }
}

