/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.wip;

import org.eclipse.wst.jsdt.chromium.DebugContext;
import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.UpdatableScript;
import org.eclipse.wst.jsdt.chromium.internal.ScriptBase;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipCommandProcessor;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipContextBuilder;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipScriptManager;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.debugger.SetScriptSourceData;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.debugger.SetScriptSourceParams;
import org.eclipse.wst.jsdt.chromium.util.GenericCallback;
import org.eclipse.wst.jsdt.chromium.util.RelaySyncCallback;

class WipScriptImpl
extends ScriptBase<String> {
    private final WipScriptManager scriptManager;

    WipScriptImpl(WipScriptManager scriptManager, ScriptBase.Descriptor<String> descriptor) {
        super(descriptor);
        this.scriptManager = scriptManager;
    }

    public RelayOk setSourceOnRemote(String newSource, UpdatableScript.UpdateCallback callback, SyncCallback syncCallback) {
        return this.sendLiveEditRequest(newSource, false, callback, syncCallback);
    }

    public RelayOk previewSetSource(String newSource, UpdatableScript.UpdateCallback callback, SyncCallback syncCallback) {
        return this.sendLiveEditRequest(newSource, true, callback, syncCallback);
    }

    private RelayOk sendLiveEditRequest(String newSource, boolean preview, final UpdatableScript.UpdateCallback updateCallback, SyncCallback syncCallback) {
        RelaySyncCallback relay = new RelaySyncCallback(syncCallback);
        final RelaySyncCallback.Guard guard = relay.newGuard();
        SetScriptSourceParams params = new SetScriptSourceParams((String)this.getId(), newSource, preview);
        GenericCallback<SetScriptSourceData> commandCallback = new GenericCallback<SetScriptSourceData>(){

            public void success(SetScriptSourceData value) {
                RelayOk relayOk = guard.getRelay().finish();
                guard.discharge(relayOk);
                WipContextBuilder contextBuilder = WipScriptImpl.this.scriptManager.getTabImpl().getContextBuilder();
                this.doStepIn(contextBuilder);
            }

            public void failure(Exception exception) {
                UpdatableScript.Failure failure = UpdatableScript.Failure.UNSPECIFIED;
                updateCallback.failure(exception.getMessage(), failure);
            }

            private void doStepIn(WipContextBuilder contextBuilder) {
                WipContextBuilder.WipDebugContextImpl currentContext;
                if (contextBuilder != null && (currentContext = contextBuilder.getCurrentContext()) != null) {
                    currentContext.continueVm(DebugContext.StepAction.IN, 0, null);
                }
            }
        };
        WipCommandProcessor commandProcessor = this.scriptManager.getTabImpl().getCommandProcessor();
        return commandProcessor.send(params, commandCallback, guard.asSyncCallback());
    }
}

