/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.monitor;

import org.eclipse.wst.wsi.internal.core.monitor.SocketHandler;

public class ChunkedData {
    protected boolean moreChunkedData = false;
    protected String chunkedData = "";
    protected SocketHandler socketHandler = null;

    public ChunkedData() {
    }

    public ChunkedData(SocketHandler socketHandler, boolean moreChunkedData) {
        this.socketHandler = socketHandler;
        this.moreChunkedData = moreChunkedData;
    }

    public ChunkedData(SocketHandler socketHandler, String chunkedData) {
        this.socketHandler = socketHandler;
        this.chunkedData = chunkedData;
        this.moreChunkedData = this.checkData(chunkedData);
    }

    public void addData(String chunkedData) {
        this.chunkedData = String.valueOf(this.chunkedData) + chunkedData;
        this.moreChunkedData = this.checkData(chunkedData);
    }

    public String getData() {
        return this.chunkedData;
    }

    public void clearData() {
        this.chunkedData = "";
    }

    public boolean isMoreChunkedData() {
        return this.moreChunkedData;
    }

    public boolean decodeAndAddDataToBuffer(StringBuffer messageBuffer) {
        boolean moreChunkedData = false;
        if (!this.moreChunkedData) {
            this.debug("decodeAndAddDataToBuffer", "chunkedData: " + this.chunkedData);
            moreChunkedData = this.decodeData(this.chunkedData, messageBuffer);
        }
        return moreChunkedData;
    }

    private boolean checkData(String chunkedData) {
        boolean moreChunkedData = false;
        if (chunkedData.indexOf("\r\n0\r\n") != -1) {
            moreChunkedData = false;
            this.debug("checkData", "Chunk contains [CRLF][0][CRLF], so there is no more data.");
        } else if (chunkedData.startsWith("0\r\n")) {
            moreChunkedData = false;
            this.debug("checkData", "Chunk data starts with [0][CRLF], so there is no more data.");
        } else {
            moreChunkedData = true;
        }
        return moreChunkedData;
    }

    private boolean decodeData(String chunkedData, StringBuffer messageBuffer) {
        boolean endOfData = false;
        int nextIndex = 0;
        int prevIndex = 0;
        int chunkSize = 0;
        String nextChunkData = null;
        while (!endOfData && nextIndex < chunkedData.length() && (nextIndex = chunkedData.indexOf("\r\n", prevIndex)) != -1) {
            String hexChunkedSize = chunkedData.substring(prevIndex, nextIndex);
            chunkSize = Integer.decode("0x" + hexChunkedSize);
            this.debug("decodeData", "chunkedSize: " + chunkSize);
            if (chunkSize == 0) {
                endOfData = true;
            } else {
                if (nextIndex + 2 + chunkSize > chunkedData.length()) break;
                nextChunkData = chunkedData.substring(nextIndex + 2, nextIndex + 2 + chunkSize);
                this.debug("decodeData", "nextChunkData: " + nextChunkData);
                if (messageBuffer != null) {
                    messageBuffer.append(nextChunkData);
                }
            }
            prevIndex = nextIndex + 2 + chunkSize + 2;
        }
        return endOfData;
    }

    private void debug(String method, String message) {
        this.socketHandler.debug("ChunkedData", method, message);
    }
}

