/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.tests.encoding.read;

import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.wst.xml.tests.encoding.TestsPlugin;
import org.eclipse.wst.xml.tests.encoding.util.ProjectUnzipUtility;

public class TestContentTypeDetection
extends TestCase {
    private static final boolean DEBUG = false;
    static IProject fTestProject;
    private static boolean fTestProjectInitialized;
    private static int nSetups;
    private static final String TEST_PROJECT_NAME = "org.eclipse.wst.xml.temp.tests.encoding.resource.newtests";

    static {
        nSetups = 0;
    }

    private static void createProject(IProject project, IPath locationPath, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("creating test project", 10);
        try {
            if (!project.exists()) {
                IProjectDescription desc = project.getWorkspace().newProjectDescription(project.getName());
                if (Platform.getLocation().equals((Object)locationPath)) {
                    locationPath = null;
                }
                desc.setLocation(locationPath);
                project.create(desc, monitor);
                monitor = null;
            }
            if (!project.isOpen()) {
                project.open(monitor);
                monitor = null;
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private static void getAndCreateProject() throws CoreException {
        IWorkspace workspace = TestsPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        fTestProject = root.getProject(TEST_PROJECT_NAME);
        TestContentTypeDetection.createProject(fTestProject, null, null);
        fTestProject.refreshLocal(2, null);
        TestContentTypeDetection.assertTrue((boolean)fTestProject.exists());
    }

    protected void doTest(String expectedContentType, String filePath, Class expectedException) throws CoreException, IOException {
        IFile file = (IFile)fTestProject.findMember(filePath);
        TestContentTypeDetection.assertNotNull((String)("Error in test case: file not found: " + filePath), (Object)file);
        IContentDescription streamContentDescription = this.doGetContentTypeBasedOnStream(file);
        IContentDescription fileContentDescription = this.doGetContentTypeBasedOnFile(file);
        IContentType fileContentType = fileContentDescription.getContentType();
        TestContentTypeDetection.assertNotNull((String)"file content type was null", (Object)fileContentType);
        IContentType streamContentType = streamContentDescription.getContentType();
        TestContentTypeDetection.assertNotNull((String)"stream content type was null", (Object)streamContentType);
        TestContentTypeDetection.assertEquals((String)"comparing content type based on file and stream: ", (Object)fileContentType, (Object)streamContentType);
        TestContentTypeDetection.assertEquals((String)"compareing with expected content type id", (String)expectedContentType, (String)fileContentType.getId());
    }

    protected IContentDescription doGetContentTypeBasedOnStream(IFile file) throws CoreException, IOException {
        IContentDescription streamContentDescription = null;
        try (InputStream inputStream = null;){
            inputStream = file.getContents();
            streamContentDescription = Platform.getContentTypeManager().getDescriptionFor(inputStream, file.getName(), IContentDescription.ALL);
        }
        TestContentTypeDetection.assertNotNull((String)"content description was null", (Object)streamContentDescription);
        return streamContentDescription;
    }

    protected IContentDescription doGetContentTypeBasedOnFile(IFile file) throws CoreException {
        IContentDescription fileContentDescription = file.getContentDescription();
        TestContentTypeDetection.assertNotNull((String)"file content description was null", (Object)fileContentDescription);
        return fileContentDescription;
    }

    protected void doTestForParent(String expectedContentType, String filePath, Class expectedException) throws CoreException, IOException {
        IFile file = (IFile)fTestProject.findMember(filePath);
        TestContentTypeDetection.assertNotNull((String)("Error in test case: file not found: " + filePath), (Object)file);
        IContentDescription contentDescription = file.getContentDescription();
        if (contentDescription == null) {
            try (InputStream inputStream = null;){
                inputStream = file.getContents();
                contentDescription = Platform.getContentTypeManager().getDescriptionFor(inputStream, file.getName(), IContentDescription.ALL);
            }
        }
        TestContentTypeDetection.assertNotNull((String)"content description was null", (Object)contentDescription);
        IContentType contentType = contentDescription.getContentType();
        TestContentTypeDetection.assertNotNull((String)"content type was null", (Object)contentType);
        IContentType parentContentType = contentType;
        boolean found = false;
        while (parentContentType != null && !found) {
            found = expectedContentType.equals(parentContentType.getId());
            parentContentType = parentContentType.getBaseType();
        }
        TestContentTypeDetection.assertTrue((String)("did not find '" + expectedContentType + "' in parent chain of base types"), (boolean)found);
    }

    protected void setUp() throws Exception {
        super.setUp();
        ++nSetups;
        if (!fTestProjectInitialized) {
            TestContentTypeDetection.getAndCreateProject();
            String destinationProjectString = fTestProject.getLocation().toOSString();
            String destinationFolder = String.valueOf(destinationProjectString) + "/";
            ProjectUnzipUtility projUtil = new ProjectUnzipUtility();
            projUtil.unzipAndImport(TestsPlugin.getTestResource("testfiles.zip"), destinationFolder);
            projUtil.initJavaProject(TEST_PROJECT_NAME);
            fTestProject.refreshLocal(2, null);
            fTestProjectInitialized = true;
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (--nSetups == 0) {
            // empty if block
        }
    }

    protected static IProject getTestProject() {
        return fTestProject;
    }
}

