/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.tests.internal.util;

import org.eclipse.jpt.common.ui.internal.swt.bindings.SWTBindingTools;
import org.eclipse.jpt.common.ui.internal.swt.widgets.DisplayTools;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class LabelModelBindingTest {
    private Composite composite;

    @Before
    public void setUp() {
        this.composite = new Composite((Composite)DisplayTools.getShell(), 0);
        this.composite.setLayout((Layout)new GridLayout());
    }

    @After
    public void tearDown() {
        if (this.composite != null) {
            this.composite.dispose();
            this.composite = null;
        }
    }

    @Test
    public void testSetImage() {
        Image expectedImage = new Image((Device)this.composite.getDisplay(), 16, 16);
        try {
            Label label = new Label(this.composite, 0);
            SimplePropertyValueModel imageModel = new SimplePropertyValueModel();
            SWTBindingTools.bindImageLabel((PropertyValueModel)imageModel, (Label)label);
            imageModel.setValue((Object)expectedImage);
            Assert.assertEquals((Object)expectedImage, (Object)label.getImage());
        }
        finally {
            expectedImage.dispose();
        }
    }

    @Test
    public void testSetImageDispose() {
        Image expectedImage = new Image((Device)this.composite.getDisplay(), 16, 16);
        try {
            Label label = new Label(this.composite, 0);
            SimplePropertyValueModel imageModel = new SimplePropertyValueModel();
            SWTBindingTools.bindImageLabel((PropertyValueModel)imageModel, (Label)label);
            label.dispose();
            imageModel.setValue((Object)expectedImage);
        }
        finally {
            expectedImage.dispose();
        }
    }

    @Test
    public void testSetText() {
        Label label = new Label(this.composite, 0);
        SimplePropertyValueModel textModel = new SimplePropertyValueModel();
        SWTBindingTools.bindTextLabel((PropertyValueModel)textModel, (Label)label);
        String expectedText = "This is a test";
        textModel.setValue((Object)expectedText);
        Assert.assertEquals((Object)expectedText, (Object)label.getText());
    }

    @Test
    public void testSetTextDispose() {
        Label label = new Label(this.composite, 0);
        SimplePropertyValueModel textModel = new SimplePropertyValueModel();
        SWTBindingTools.bindTextLabel((PropertyValueModel)textModel, (Label)label);
        label.dispose();
        String expectedString = "This is a test";
        textModel.setValue((Object)expectedString);
    }
}

