/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.model.ecore.xmi.impl;

import java.util.Map;
import org.apache.axis.model.ecore.EClass;
import org.apache.axis.model.ecore.EFactory;
import org.apache.axis.model.ecore.EObject;
import org.apache.axis.model.ecore.EReference;
import org.apache.axis.model.ecore.EStructuralFeature;
import org.apache.axis.model.ecore.xmi.XMIResource;
import org.apache.axis.model.ecore.xmi.XMLHelper;
import org.apache.axis.model.ecore.xmi.XMLResource;
import org.apache.axis.model.ecore.xmi.impl.XMLHandler;

public abstract class XMIHandler
extends XMLHandler {
    protected static final String XMI_ELEMENT_TYPE = "xmi";
    protected static final String XMI_UUID = "uuid";
    protected static final String XMI_EXTENSION = "Extension";
    protected static final String XMI_TYPE_ATTRIB = "xmi:type";
    protected static final String ID_ATTRIB = "xmi:id";
    protected static final String VERSION_ATTRIB = "xmi:version";
    protected static final String UUID_ATTRIB = "xmi:uuid";
    protected static final String XMI_ELEMENT_NAME = "xmi:XMI";

    public XMIHandler(XMLResource xmiResource, XMLHelper helper, Map options) {
        super(xmiResource, helper, options);
        this.hrefAttribute = "href";
        this.notFeatures.add(VERSION_ATTRIB);
        this.notFeatures.add(XMI_TYPE_ATTRIB);
        this.notFeatures.add(UUID_ATTRIB);
    }

    protected void processElement(String name, String prefix, String localName) {
        if (localName.equals("XMI")) {
            this.types.push(XMI_ELEMENT_TYPE);
            String namespace = this.helper.getURI(XMI_ELEMENT_TYPE);
            if (namespace != null && namespace.startsWith("http://schema.omg.org/spec/XMI/")) {
                ((XMIResource)this.xmlResource).setXMIVersion(namespace.substring("http://schema.omg.org/spec/XMI/".length()));
            }
            this.isRoot = false;
        } else if (this.isRoot) {
            String namespace = this.helper.getURI(XMI_ELEMENT_TYPE);
            if (namespace != null && namespace.startsWith("http://schema.omg.org/spec/XMI/")) {
                ((XMIResource)this.xmlResource).setXMIVersion(namespace.substring("http://schema.omg.org/spec/XMI/".length()));
            }
            super.processElement(name, prefix, localName);
        } else {
            super.processElement(name, prefix, localName);
        }
    }

    protected boolean isTextFeatureValue(Object type) {
        return super.isTextFeatureValue(type) && type != XMI_ELEMENT_TYPE;
    }

    protected EObject createDocumentRoot(String prefix, String uri, String name, EFactory eFactory, boolean top) {
        if (this.extendedMetaData != null && eFactory != null && this.extendedMetaData.demandedPackages().contains(eFactory.getEPackage())) {
            EClass eClass = (EClass)this.extendedMetaData.demandType(uri, name);
            EObject newObject = null;
            newObject = this.useNewMethods ? this.createObject(eFactory, eClass, true) : this.helper.createObject(eFactory, name);
            this.validateCreateObjectFromFactory(eFactory, name, newObject);
            this.handleObjectAttribs(newObject);
            if (top) {
                this.processTopObject(newObject);
            }
            return newObject;
        }
        return super.createDocumentRoot(prefix, uri, name, eFactory, top);
    }

    protected void createObject(EObject peekObject, EStructuralFeature feature) {
        String id = this.attribs.getValue("xmi:idref");
        if (id != null) {
            this.setValueFromId(peekObject, (EReference)feature, id);
            this.objects.push(null);
            this.mixedTargets.push(null);
            this.types.push("object");
        } else {
            super.createObject(peekObject, feature);
        }
    }

    protected void handleUnknownFeature(String prefix, String name, boolean isElement, EObject peekObject, String value) {
        if (XMI_EXTENSION.equals(name) && "http://www.omg.org/XMI".equals(this.helper.getURI(prefix))) {
            if (this.extendedMetaData == null) {
                this.setExtendedMetaDataOption(Boolean.TRUE);
            }
            this.recordUnknownFeature(prefix, name, isElement, peekObject, value);
        } else {
            super.handleUnknownFeature(prefix, name, isElement, peekObject, value);
        }
    }
}

