/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.resource.orm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum XmlDirection implements Enumerator
{
    IN(0, "IN", "IN"),
    OUT(1, "OUT", "OUT"),
    IN_OUT(2, "IN_OUT", "IN_OUT"),
    OUT_CURSOR(3, "OUT_CURSOR", "OUT_CURSOR");

    public static final int IN_VALUE = 0;
    public static final int OUT_VALUE = 1;
    public static final int IN_OUT_VALUE = 2;
    public static final int OUT_CURSOR_VALUE = 3;
    private static final XmlDirection[] VALUES_ARRAY;
    public static final List<XmlDirection> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new XmlDirection[]{IN, OUT, IN_OUT, OUT_CURSOR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static XmlDirection get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            XmlDirection result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static XmlDirection getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            XmlDirection result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static XmlDirection get(int value) {
        switch (value) {
            case 0: {
                return IN;
            }
            case 1: {
                return OUT;
            }
            case 2: {
                return IN_OUT;
            }
            case 3: {
                return OUT_CURSOR;
            }
        }
        return null;
    }

    private XmlDirection(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

