/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.antlr.runtime;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.libraries.antlr.runtime.CharStream;
import org.eclipse.persistence.internal.libraries.antlr.runtime.CharStreamState;

public class ANTLRStringStream
implements CharStream {
    protected char[] data;
    protected int n;
    protected int p = 0;
    protected int line = 1;
    protected int charPositionInLine = 0;
    protected int markDepth = 0;
    protected List<CharStreamState> markers;
    protected int lastMarker;
    public String name;

    public ANTLRStringStream() {
    }

    public ANTLRStringStream(String string) {
        this();
        this.data = string.toCharArray();
        this.n = string.length();
    }

    public ANTLRStringStream(char[] cArray, int n) {
        this();
        this.data = cArray;
        this.n = n;
    }

    public void reset() {
        this.p = 0;
        this.line = 1;
        this.charPositionInLine = 0;
        this.markDepth = 0;
    }

    @Override
    public void consume() {
        if (this.p < this.n) {
            ++this.charPositionInLine;
            if (this.data[this.p] == '\n') {
                ++this.line;
                this.charPositionInLine = 0;
            }
            ++this.p;
        }
    }

    @Override
    public int LA(int n) {
        if (n == 0) {
            return 0;
        }
        if (n < 0 && this.p + ++n - 1 < 0) {
            return -1;
        }
        if (this.p + n - 1 >= this.n) {
            return -1;
        }
        return this.data[this.p + n - 1];
    }

    @Override
    public int LT(int n) {
        return this.LA(n);
    }

    @Override
    public int index() {
        return this.p;
    }

    @Override
    public int size() {
        return this.n;
    }

    @Override
    public int mark() {
        CharStreamState charStreamState;
        if (this.markers == null) {
            this.markers = new ArrayList<CharStreamState>();
            this.markers.add(null);
        }
        ++this.markDepth;
        if (this.markDepth >= this.markers.size()) {
            charStreamState = new CharStreamState();
            this.markers.add(charStreamState);
        } else {
            charStreamState = this.markers.get(this.markDepth);
        }
        charStreamState.p = this.p;
        charStreamState.line = this.line;
        charStreamState.charPositionInLine = this.charPositionInLine;
        this.lastMarker = this.markDepth;
        return this.markDepth;
    }

    @Override
    public void rewind(int n) {
        CharStreamState charStreamState = this.markers.get(n);
        this.seek(charStreamState.p);
        this.line = charStreamState.line;
        this.charPositionInLine = charStreamState.charPositionInLine;
        this.release(n);
    }

    @Override
    public void rewind() {
        this.rewind(this.lastMarker);
    }

    @Override
    public void release(int n) {
        this.markDepth = n;
        --this.markDepth;
    }

    @Override
    public void seek(int n) {
        if (n <= this.p) {
            this.p = n;
            return;
        }
        while (this.p < n) {
            this.consume();
        }
    }

    @Override
    public String substring(int n, int n2) {
        return new String(this.data, n, n2 - n + 1);
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getCharPositionInLine() {
        return this.charPositionInLine;
    }

    @Override
    public void setLine(int n) {
        this.line = n;
    }

    @Override
    public void setCharPositionInLine(int n) {
        this.charPositionInLine = n;
    }

    @Override
    public String getSourceName() {
        return this.name;
    }

    public String toString() {
        return new String(this.data);
    }
}

