/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.core.javascript.search;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.web.core.internal.Logger;
import org.eclipse.wst.jsdt.web.core.javascript.IJsTranslation;
import org.eclipse.wst.jsdt.web.core.javascript.JsTranslationAdapter;
import org.eclipse.wst.jsdt.web.core.javascript.JsTranslationAdapterFactory;
import org.eclipse.wst.jsdt.web.core.javascript.search.JsSearchSupport;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.exceptions.UnsupportedCharsetExceptionWithDetail;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class JsSearchDocument {
    private String UNKNOWN_PATH;
    private String fJSPPathString;
    private String fCUPath;
    private SearchParticipant fParticipant;
    private long fLastModifiedStamp;
    private char[] fCachedCharContents;

    public JsSearchDocument(String filePath, SearchParticipant participant) {
        this.fJSPPathString = this.UNKNOWN_PATH = "**path unknown**";
        this.fCUPath = this.UNKNOWN_PATH;
        this.fParticipant = null;
        this.fJSPPathString = filePath;
        this.fParticipant = participant;
    }

    public SearchParticipant getParticipant() {
        return this.fParticipant;
    }

    public char[] getCharContents() {
        if (this.fCachedCharContents == null || this.isDirty()) {
            IJsTranslation trans = this.getJSTranslation();
            this.fCachedCharContents = trans != null ? trans.getJsText().toCharArray() : new char[]{};
            this.fCUPath = trans.getJavaPath();
        }
        return this.fCachedCharContents;
    }

    public String getJavaText() {
        return new String(this.getCharContents());
    }

    private IModelManager getModelManager() {
        return StructuredModelManager.getModelManager();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final IJsTranslation getJSTranslation() {
        IJsTranslation translation = null;
        IFile jspFile = this.getFile();
        if (!JsSearchSupport.isJsp(jspFile)) {
            return translation;
        }
        IStructuredModel model = null;
        try {
            try {
                IModelManager modelManager = this.getModelManager();
                if (modelManager != null) {
                    model = modelManager.getModelForRead(jspFile);
                }
                if (!(model instanceof IDOMModel)) return translation;
                IDOMModel xmlModel = (IDOMModel)model;
                JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)xmlModel);
                IDOMDocument doc = xmlModel.getDocument();
                JsTranslationAdapter adapter = (JsTranslationAdapter)doc.getAdapterFor(IJsTranslation.class);
                translation = adapter.getJsTranslation(false);
                return translation;
            }
            catch (IOException e) {
                Logger.logException(e);
                if (model == null) return translation;
                model.releaseFromRead();
                return translation;
            }
            catch (CoreException e) {
                Logger.logException(e);
                if (model == null) return translation;
                model.releaseFromRead();
                return translation;
            }
            catch (UnsupportedCharsetExceptionWithDetail unsupportedCharsetExceptionWithDetail) {
                if (model == null) return translation;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                model.releaseFromRead();
                return translation;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    public String getPath() {
        IJsTranslation trans;
        if ((this.fCUPath == null || this.isDirty() || this.fCUPath == this.UNKNOWN_PATH) && (trans = this.getJSTranslation()) != null) {
            this.fCUPath = trans.getJavaPath();
            this.fCachedCharContents = trans.getJsText().toCharArray();
        }
        return this.fCUPath != null ? this.fCUPath : this.UNKNOWN_PATH;
    }

    public IFile getFile() {
        Path jspPath;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile jspFile = root.getFile((IPath)(jspPath = new Path(this.fJSPPathString)));
        if (!jspFile.exists()) {
            jspFile = root.getFileForLocation((IPath)jspPath);
        }
        return jspFile;
    }

    private boolean isDirty() {
        boolean modified = false;
        IFile f = this.getFile();
        if (f != null) {
            long currentStamp = f.getModificationStamp();
            if (currentStamp != this.fLastModifiedStamp) {
                modified = true;
            }
            this.fLastModifiedStamp = currentStamp;
        }
        return modified;
    }

    public void release() {
    }

    public String toString() {
        return "[JSPSearchDocument:" + this.fJSPPathString + "]";
    }

    public String getEncoding() {
        return null;
    }

    public byte[] getByteContents() {
        return null;
    }
}

