/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.strategy;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.DirectoryArchiveLoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseApplication;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseArchive;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseWARFile;

public abstract class DirectoryLoadStrategyImpl
extends LoadStrategyImpl
implements DirectoryArchiveLoadStrategy {
    static boolean IS_AIX = "AIX".equals(System.getProperty("os.name"));
    protected String directoryUri;
    protected String directoryUriAsZipString;
    protected static char SEPARATOR_CHAR = java.io.File.separatorChar;

    public DirectoryLoadStrategyImpl(String aDirectoryUri) {
        this.setDirectoryUri(aDirectoryUri);
        String normalized = null;
        try {
            normalized = new java.io.File(aDirectoryUri).getCanonicalPath();
        }
        catch (IOException iOException) {
            normalized = aDirectoryUri;
        }
        this.setDirectoryUriAsZipString(normalized.replace(SEPARATOR_CHAR, '/'));
    }

    protected abstract void addDirectory(java.io.File var1, List var2);

    protected void addFile(java.io.File aFile, List aList) {
        String uri = this.getURIFrom(aFile);
        if (this.collectedLooseArchiveFiles.containsKey(uri)) {
            return;
        }
        File cFile = this.createFile(uri);
        cFile.setSize(aFile.length());
        cFile.setLastModified(aFile.lastModified());
        aList.add(cFile);
    }

    protected void addFiles(java.io.File aDirectory, List aList) {
        String[] fileNames = aDirectory.list();
        if (fileNames == null) {
            return;
        }
        int i = 0;
        while (i < fileNames.length) {
            java.io.File aFile;
            String fileName = ArchiveUtil.concatUri(aDirectory.getPath(), fileNames[i], SEPARATOR_CHAR);
            if (!(fileNames[i] == null || IS_AIX && ".backup".equals(fileNames[i]) || !(aFile = new java.io.File(fileName)).exists())) {
                if (aFile.isDirectory() && !this.isArchive(this.getURIFrom(aFile))) {
                    this.addDirectory(aFile, aList);
                } else {
                    this.addFile(aFile, aList);
                }
            }
            ++i;
        }
    }

    @Override
    protected boolean primContains(String uri) {
        return new java.io.File(this.getFileNameFrom(uri)).exists();
    }

    @Override
    public String getAbsolutePath() throws FileNotFoundException {
        return new java.io.File(this.getDirectoryUri()).getAbsolutePath();
    }

    protected abstract java.io.File getDirectoryForList();

    @Override
    public String getDirectoryUri() {
        return this.directoryUri;
    }

    public String getDirectoryUriAsZipString() {
        return this.directoryUriAsZipString;
    }

    protected String getFileNameFrom(String uri) {
        LooseArchive aLooseArchive = this.getLooseArchive();
        if (aLooseArchive != null) {
            String result = null;
            switch (aLooseArchive.eClass().getClassifierID()) {
                case 0: {
                    result = this.getURIFromLooseArchivesIfAvailable((List)((LooseApplication)aLooseArchive).getLooseArchives(), uri);
                    break;
                }
                case 5: {
                    result = this.getURIFromLooseArchivesIfAvailable((List)((LooseWARFile)aLooseArchive).getLooseLibs(), uri);
                }
            }
            if (result != null) {
                return result;
            }
        }
        String name = uri;
        if (SEPARATOR_CHAR != '/') {
            name = name.replace('/', SEPARATOR_CHAR);
        }
        return String.valueOf(this.getDirectoryUri()) + SEPARATOR_CHAR + name;
    }

    private String getURIFromLooseArchivesIfAvailable(List looseArchives, String uri) {
        for (LooseArchive looseArchiveElement : looseArchives) {
            if (!uri.equals(looseArchiveElement.getUri())) continue;
            return looseArchiveElement.getBinariesPath();
        }
        return null;
    }

    @Override
    public List getFiles() {
        ArrayList list = new ArrayList();
        java.io.File directory = this.getDirectoryForList();
        this.addFiles(directory, list);
        return list;
    }

    @Override
    public List getFiles(String subfolderPath) {
        ArrayList list = new ArrayList();
        java.io.File containerDirectory = this.getDirectoryForList();
        java.io.File subfolder = new java.io.File(containerDirectory, subfolderPath);
        this.addFiles(subfolder, list);
        return list;
    }

    @Override
    public InputStream getInputStream(String uri) throws IOException, FileNotFoundException {
        return new FileInputStream(this.getFileNameFrom(uri));
    }

    protected String getURIFrom(java.io.File aFile) {
        String name = "";
        String relative = null;
        String root = this.getDirectoryUriAsZipString();
        try {
            name = aFile.getCanonicalPath();
            relative = this.makeRelative(name, root);
        }
        catch (IOException iOException) {
            name = null;
        }
        if (relative == null) {
            name = aFile.getAbsolutePath();
            relative = this.makeRelative(name, root);
        }
        if (relative == null) {
            name = aFile.getPath();
            root = this.replaceSeparators(this.getDirectoryUri());
            relative = this.makeRelative(name, root);
        }
        return relative;
    }

    private String replaceSeparators(String path) {
        if (java.io.File.separatorChar != '/') {
            return path.replace(java.io.File.separatorChar, '/');
        }
        return path;
    }

    private String makeRelative(String fileName, String root) {
        String name;
        if (fileName == null || root == null) {
            return null;
        }
        int offset = root.length();
        while (offset > 0 && root.charAt(offset - 1) == '/') {
            --offset;
        }
        if (offset < root.length()) {
            if (++offset < root.length()) {
                root = root.substring(0, offset);
            }
        } else {
            root = String.valueOf(root) + '/';
        }
        name = (name = this.replaceSeparators(fileName)).startsWith(root) ? name.substring(root.length()) : null;
        return name;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public boolean isUsing(java.io.File aSystemFile) {
        java.io.File dir = new java.io.File(this.getDirectoryUri());
        return dir.equals(aSystemFile);
    }

    public void setDirectoryUri(String newDirectoryUri) {
        this.directoryUri = newDirectoryUri;
    }

    public void setDirectoryUriAsZipString(String newDirectoryUriAsZipString) {
        this.directoryUriAsZipString = newDirectoryUriAsZipString;
    }
}

