/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.modelqueryimpl.InferredGrammarBuildingCMDocumentLoader;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;

public class ReloadDependenciesHandler
extends AbstractHandler
implements IHandler {
    protected IStructuredModel model;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        ITextEditor textEditor = null;
        if (editor instanceof ITextEditor) {
            textEditor = (ITextEditor)editor;
        } else {
            Object o = editor.getAdapter(ITextEditor.class);
            if (o != null) {
                textEditor = (ITextEditor)o;
            }
        }
        if (textEditor != null) {
            IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
            IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForRead(document);
            if (model != null) {
                ModelQuery modelQuery = null;
                try {
                    modelQuery = ModelQueryUtil.getModelQuery((IStructuredModel)model);
                }
                finally {
                    model.releaseFromRead();
                }
                IDOMDocument domDocument = ((IDOMModel)model).getDocument();
                if (modelQuery != null && modelQuery.getCMDocumentManager() != null) {
                    modelQuery.getCMDocumentManager().getCMDocumentCache().clear();
                    InferredGrammarBuildingCMDocumentLoader loader = new InferredGrammarBuildingCMDocumentLoader((Document)domDocument, modelQuery);
                    loader.loadCMDocuments();
                }
            }
        }
        return null;
    }
}

