/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.tests.contentmodel;

import org.eclipse.wst.xml.core.internal.contentmodel.CMContent;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMGroup;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMVisitor;

public class CMUtility {
    public static boolean isNodeOrAncestorGroupRepeatable(CMContent content, CMNode child) {
        boolean result = CMUtility.isRepeatable(child);
        if (!result) {
            CanRepeatVisitor visitor = new CanRepeatVisitor((CMNode)content, child);
            visitor.visitCMNode((CMNode)content);
            result = visitor.getResult();
        }
        return result;
    }

    public static boolean isNodeRepeatable(CMContent content, CMNode child) {
        boolean result = CMUtility.isRepeatable(child);
        if (!result) {
            IsRepeatableVisitor visitor = new IsRepeatableVisitor((CMNode)content, child);
            visitor.visitCMNode((CMNode)content);
            result = visitor.getResult();
        }
        return result;
    }

    public static boolean isRepeatable(CMNode child) {
        boolean result = false;
        if (child instanceof CMContent) {
            CMContent content = (CMContent)child;
            result = content.getMaxOccur() > 1 || content.getMaxOccur() == -1;
        }
        return result;
    }

    protected static class CanRepeatVisitor
    extends CMVisitor {
        public boolean result;
        protected boolean isWithinRepeatableGroup;
        protected CMNode root;
        protected CMNode target;

        public CanRepeatVisitor(CMNode root, CMNode target) {
            this.root = root;
            this.target = target;
        }

        public void visitCMGroup(CMGroup group) {
            boolean oldIsWithinRepeatableGroup = this.isWithinRepeatableGroup;
            this.isWithinRepeatableGroup = CMUtility.isRepeatable((CMNode)group);
            super.visitCMGroup(group);
            this.isWithinRepeatableGroup = oldIsWithinRepeatableGroup;
        }

        public void visitCMElementDeclaration(CMElementDeclaration cmelement) {
            if (cmelement == this.target) {
                this.result = this.isWithinRepeatableGroup;
            }
        }

        public boolean getResult() {
            return this.result;
        }
    }

    protected static class IsRepeatableVisitor
    extends CMVisitor {
        public boolean result = false;
        protected CMGroup currentGroup;
        protected CMNode root;
        protected CMNode target;

        public IsRepeatableVisitor(CMNode root, CMNode target) {
            this.root = root;
            this.target = target;
        }

        public void visitCMGroup(CMGroup group) {
            CMGroup previousGroup = this.currentGroup;
            this.currentGroup = group;
            super.visitCMGroup(group);
            this.currentGroup = previousGroup;
        }

        public void visitCMElementDeclaration(CMElementDeclaration cmelement) {
            if (cmelement == this.target && this.currentGroup != null) {
                this.result = this.currentGroup.getOperator() == 2 && CMUtility.isRepeatable((CMNode)this.currentGroup);
            }
        }

        public boolean getResult() {
            return this.result;
        }
    }
}

