/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.jaxp.debug.invoker.test;

import java.util.List;
import org.eclipse.wst.xsl.jaxp.debug.invoker.IProcessorInvoker;
import org.eclipse.wst.xsl.jaxp.debug.invoker.PipelineDefinition;
import org.eclipse.wst.xsl.jaxp.debug.invoker.TransformDefinition;
import org.eclipse.wst.xsl.jaxp.debug.invoker.TypedValue;
import org.eclipse.wst.xsl.jaxp.debug.invoker.internal.JAXPSAXProcessorInvoker;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PipelineDefintionTest {
    PipelineDefinition pldef = null;

    @Before
    public void setUp() throws Exception {
        this.pldef = new PipelineDefinition();
    }

    @After
    public void tearDown() throws Exception {
        this.pldef = null;
    }

    @Test
    public void testAddTransformDefinition() throws Exception {
        this.setupTransformDefinition();
        List tdefs = this.pldef.getTransformDefs();
        Assert.assertNotNull((Object)tdefs);
        Assert.assertEquals((String)"Did not find expected transformation defs", (long)1L, (long)tdefs.size());
    }

    private TransformDefinition setupTransformDefinition() {
        TransformDefinition tdef = new TransformDefinition();
        this.pldef.addTransformDef(tdef);
        return tdef;
    }

    @Test
    public void testRemoveTransformDefintion() throws Exception {
        TransformDefinition tdef = this.setupTransformDefinition();
        Assert.assertEquals((long)1L, (long)this.pldef.getTransformDefs().size());
        this.pldef.removeTransformDef(tdef);
        Assert.assertEquals((long)0L, (long)this.pldef.getTransformDefs().size());
    }

    @Test
    public void testAddAttribute() throws Exception {
        this.setupAttribute();
        Assert.assertEquals((long)1L, (long)this.pldef.getAttributes().size());
    }

    private TypedValue setupAttribute() {
        TypedValue attr = new TypedValue("attr", "string", "1");
        this.pldef.addAttribute(attr);
        return attr;
    }

    @Test
    public void testRemoveAttribute() throws Exception {
        TypedValue attr = this.setupAttribute();
        this.pldef.addAttribute(attr);
        Assert.assertEquals((long)1L, (long)this.pldef.getAttributes().size());
        this.pldef.removeAttribute(attr);
        Assert.assertEquals((long)0L, (long)this.pldef.getAttributes().size());
    }

    @Test
    public void testConfigureInvoker() throws Exception {
        JAXPSAXProcessorInvoker invoker = new JAXPSAXProcessorInvoker();
        this.pldef.configure((IProcessorInvoker)invoker);
    }
}

