/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.tests.format;

import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.formatter.FormattingContext;
import org.eclipse.jface.text.formatter.IContentFormatterExtension;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.ui.text.JavaScriptSourceViewerConfiguration;
import org.eclipse.wst.jsdt.ui.text.JavaScriptTextTools;

public class FormattingTests
extends TestCase {
    public static final String DELIMITER = TextUtilities.getDefaultLineDelimiter((IDocument)new Document());
    protected static final String PREFIX = "// ";
    private static JavaScriptTextTools fJavaScriptTextTools;
    private static FormattingContext fFormattingContext;
    private static IContentFormatterExtension fFormatter;

    public FormattingTests() {
        super("Formatting Tests");
    }

    public FormattingTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite ts = new TestSuite(FormattingTests.class, "Formatting Tests");
        return new FormattingTestsSetup((Test)ts);
    }

    public void testLongMultipleComments() {
        String beforeContents = "//this is a really long comment that will have to be wrapped into multiple lines because it is so very very long" + DELIMITER + "//this is a really long comment that will have to be wrapped into multiple lines because it is so very very long" + DELIMITER;
        String afterContents = "// this is a really long comment that will have to be wrapped into multiple" + DELIMITER + PREFIX + "lines because it is so very very long" + DELIMITER + PREFIX + "this is a really long comment that will have to be wrapped into multiple" + DELIMITER + PREFIX + "lines because it is so very very long" + DELIMITER;
        FormattingTests.runFormatTest(beforeContents, afterContents);
    }

    public void testNestedLongMultipleComments() {
        String beforeContents = "dojo.declare(\"myDojo.Test\", [], {" + DELIMITER + "//this is a really long comment that will have to be wrapped into multiple lines because it is so very very long" + DELIMITER + "//this is a really long comment that will have to be wrapped into multiple lines because it is so very very long" + DELIMITER + DELIMITER + "//this is a shorter comment" + DELIMITER + "constructor : function() {" + DELIMITER + "}" + DELIMITER + "//this is a really long comment that will have to be wrapped into multiple lines because it is so very very long" + DELIMITER + "});";
        String afterContents = "dojo.declare(\"myDojo.Test\", [], {" + DELIMITER + "\t" + PREFIX + "this is a really long comment that will have to be wrapped into multiple" + DELIMITER + "\t" + PREFIX + "lines because it is so very very long" + DELIMITER + "\t" + PREFIX + "this is a really long comment that will have to be wrapped into multiple" + DELIMITER + "\t" + PREFIX + "lines because it is so very very long" + DELIMITER + DELIMITER + "\t" + PREFIX + "this is a shorter comment" + DELIMITER + "\t" + "constructor : function() {" + DELIMITER + "\t" + "}" + DELIMITER + PREFIX + "this is a really long comment that will have to be wrapped into multiple" + DELIMITER + PREFIX + "lines because it is so very very long" + DELIMITER + "});";
        FormattingTests.runFormatTest(beforeContents, afterContents);
    }

    private static void runFormatTest(String beforeContents, String afterContents) {
        Document toFormat = new Document(beforeContents);
        fJavaScriptTextTools.setupJavaDocumentPartitioner((IDocument)toFormat, "___java_partitioning");
        fFormatter.format((IDocument)toFormat, (IFormattingContext)fFormattingContext);
        FormattingTests.assertEquals((String)"The formatted document does not have the expected contents", (String)afterContents, (String)toFormat.get());
    }

    private static class FormattingTestsSetup
    extends TestSetup {
        private static final String WTP_AUTOTEST_NONINTERACTIVE = "wtp.autotest.noninteractive";
        private static String previousWTPAutoTestNonInteractivePropValue = null;

        public FormattingTestsSetup(Test test) {
            super(test);
        }

        public void setUp() throws Exception {
            fJavaScriptTextTools = JavaScriptPlugin.getDefault().getJavaTextTools();
            JavaScriptSourceViewerConfiguration config = new JavaScriptSourceViewerConfiguration(fJavaScriptTextTools.getColorManager(), JavaScriptPlugin.getDefault().getCombinedPreferenceStore(), null, "___java_partitioning");
            fFormatter = (IContentFormatterExtension)config.getContentFormatter(null);
            fFormattingContext = new FormattingContext();
            fFormattingContext.setProperty((Object)"formatting.context.preferences", (Object)JavaScriptCore.getOptions());
            fFormattingContext.setProperty((Object)"formatting.context.document", (Object)true);
            String noninteractive = System.getProperty(WTP_AUTOTEST_NONINTERACTIVE);
            previousWTPAutoTestNonInteractivePropValue = noninteractive != null ? noninteractive : "false";
            System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, "true");
        }

        public void tearDown() throws Exception {
            if (previousWTPAutoTestNonInteractivePropValue != null) {
                System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, previousWTPAutoTestNonInteractivePropValue);
            }
        }
    }
}

